//:  BeOSLookAndFeelTest.java

package com.be.swing.plaf.beos.test;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * No-brainer BeOS Look and Feel test class.
 *
 * @author  Michael Heuer
 * @version $Id: BeOSLookAndFeelTest.java,v 1.3 1999/11/10 04:01:20 heuermh Exp $
 */
public class BeOSLookAndFeelTest extends JFrame {
	JProgressBar pb;
	
	public BeOSLookAndFeelTest() {
		super("BeOS Look and Feel");            
		                        
		JPanel pane = (JPanel) getContentPane();
		
		pane.setLayout(new GridLayout(10,2,4,4));
		pane.setBorder(new EmptyBorder(10,10,10,10));

//              Use this code to enable "flash" debug painting on JComponent c
//
//              RepaintManager repaintManager = RepaintManager.currentManager(c);
//              repaintManager.setDoubleBufferingEnabled(false); 
//
//      // delay between flashes
//              DebugGraphics.setFlashTime(60);
//              c.setDebugGraphicsOptions(DebugGraphics.FLASH_OPTION);

//              Use this call to enable logging of all paint operations
//         of JComponent c to System.out
//              
//              c.setDebugGraphicsOptions(DebugGraphics.LOG_OPTION);
		
		JLabel l1 = new JLabel("Enabled label");
		JLabel l2 = new JLabel("Disabled label");
		
		l2.setEnabled(false);
		
		JRadioButton rb1 = new JRadioButton("Enabled radio button");
		JRadioButton rb2 = new JRadioButton("Disabled radio button");
		
		rb2.setEnabled(false);
		
		JCheckBox cb1 = new JCheckBox("Enabled check box");
		JCheckBox cb2 = new JCheckBox("Disabled check box");
		
		cb2.setEnabled(false);
		
		JButton b1 = new JButton("Enabled button");
		JButton b2 = new JButton("Disabled button");
		JButton b3 = new JButton("Default button");
		
		b2.setEnabled(false);
		
		JTextField tf1 = new JTextField("Enabled text field");
		JTextField tf3 = new JTextField("Enabled text field 2");
		
		JTextField tf2 = new JTextField("Disabled text field");
		JTextField tf4 = new JTextField("Disabled text field 2");
		
		tf2.setEnabled(false);
		tf4.setEnabled(false);
		
		JTextArea ta1 = new JTextArea("Enabled text area");
		JTextArea ta3 = new JTextArea("Enabled text area 2");
		
		JTextArea ta2 = new JTextArea("Disabled text area");
		JTextArea ta4 = new JTextArea("Disabled text area 2");
		
		ta2.setEnabled(false);
		ta4.setEnabled(false);

		pb = new JProgressBar(0, 10000);
		pb.setValue(0);

//		pb.setDebugGraphicsOptions(DebugGraphics.LOG_OPTION);

		Timer t = new Timer(60, new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
        		pb.setValue(pb.getValue() + 200);
        	}
        });

		t.start();
		
		JSlider js = new JSlider(0,100,10);
        js.setMajorTickSpacing(10);
        js.setMinorTickSpacing(5);
        js.setPaintLabels(true);
        js.setPaintTicks(true);

		JSlider js2 = new JSlider(0,100,10);
        js2.setMajorTickSpacing(50);
        js2.setMinorTickSpacing(25);
        js2.setPaintTicks(true);
        
        js2.setSnapToTicks(true);
                
		getRootPane().setDefaultButton(b3);
		
		pane.add(l1);	pane.add(l2);
		pane.add(rb1);  pane.add(cb1);
		pane.add(rb2);	pane.add(cb2);
		pane.add(b1);	pane.add(b2);
		pane.add(tf1);	pane.add(tf3);
		pane.add(tf2);	pane.add(tf4);
		pane.add(ta1);	pane.add(ta3);
		pane.add(ta2);	pane.add(ta4);
		pane.add(js);	pane.add(js2);
		pane.add(pb);	pane.add(b3);
	}


	public static void main(String args[]) {
	
		try {
		        UIManager.setLookAndFeel(new com.be.swing.plaf.beos.BeOSLookAndFeel());
//                      UIManager.setLookAndFeel(new com.sun.java.swing.plaf.motif.MotifLookAndFeel());
//                      UIManager.setLookAndFeel(new com.sun.java.swing.plaf.macos.MacOSLookAndFeel());
//                      UIManager.setLookAndFeel(new com.sun.java.swing.plaf.windows.WindowsLookAndFeel());
//
		} catch (Exception e) {
			System.err.println(e.toString());
		}

		BeOSLookAndFeelTest f = new BeOSLookAndFeelTest();
		
		f.pack();
		f.setVisible(true);
	}
}
