// DormantNodeStatusView.cpp
// e.moon 3jun99

#include "DormantNodeStatusView.h"

__USE_CORTEX_NAMESPACE

// -------------------------------------------------------- //
// constants
// -------------------------------------------------------- //

const rgb_color DormantNodeStatusView::s_backColor =
	tint_color(ui_color(B_PANEL_BACKGROUND_COLOR), B_LIGHTEN_2_TINT);
const rgb_color DormantNodeStatusView::s_topEdgeColor =
	tint_color(ui_color(B_PANEL_BACKGROUND_COLOR), B_DARKEN_1_TINT);

// -------------------------------------------------------- //
// ctor/dtor
// -------------------------------------------------------- //

DormantNodeStatusView::~DormantNodeStatusView() {}
DormantNodeStatusView::DormantNodeStatusView(
	BRect frame, uint32 resizeMode) :
	BView(frame, "statusView", resizeMode, B_WILL_DRAW) {

	SetHighColor(s_topEdgeColor);
	SetLowColor(s_backColor);	
	SetViewColor(B_TRANSPARENT_COLOR);
}
	
// -------------------------------------------------------- //
// BView impl.
// -------------------------------------------------------- //

void DormantNodeStatusView::Draw(BRect updateRect) {
	// draw top line
	if(updateRect.top == 0.0)
		StrokeLine(
			BPoint(updateRect.left, 0.0),
			BPoint(updateRect.right, 0.0));
	// fill remaining background area
	if(updateRect.bottom >= 1.0)
		FillRect(
			BRect(updateRect.left, 1.0, updateRect.right,
				updateRect.bottom), B_SOLID_LOW);
}	

// END -- DormantNodeStatusView.cpp --
