// DormantNodeView.h
// e.moon 2jun99
//
// RESPONSIBILITIES
// - display a list of all nodes available in add-on form.
// - generate drag messages that any application can use to instantiate
//   a given dormant node.
// - provide details for a given node
//   . name
//   . info
//   . node-kind flags
//   . possible count (if possible, boil down to
//                    'you can create one' or 'they're all used up.')
//   . input flavors
//   . output flavors
//
// HISTORY
//   e.moon		2jun99		Created.

#ifndef __DormantNodeView_H__
#define __DormantNodeView_H__

#include <View.h>
#include <ListView.h>

class BMediaRoster;

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class DormantNodeStatusView;
class DormantNodeListView;

class DormantNodeView :
	public		BView {
	typedef	BView _inherited;

public:				// messages
	enum outbound_message_t {
		M_INSTANTIATE_NODE				= 'dNV0'
	};
	
public:				// ctor/dtor
	virtual ~DormantNodeView();
	DormantNodeView(
		BRect frame, const char* pName,
		uint32 resizeMode=B_FOLLOW_ALL_SIDES);
		
public:				// operations
	BMediaRoster* roster() const { return m_pRoster; }
	
protected:			// internal operations

	// initialize all child views
	void initViews();

	// fetch all nodes & [re-]build list view
	void scanDormantNodes();

	// remove and deallocate each item in the list view
	void clearListView();

public:				// BHandler impl
	virtual void MessageReceived(BMessage* pMsg);

private:				// members
	BMediaRoster*		m_pRoster;
	BListView*			m_pListView;
	
	DormantNodeStatusView*		m_pStatusView;
};

// simple extension of BListView to implement drag'n'drop

class DormantNodeListView :
	public		BListView {
	typedef	BListView _inherited;
	
public:
	virtual ~DormantNodeListView();
	DormantNodeListView(BRect frame, const char* pName,
		uint32 resizeMode);
		
public:
	virtual void Draw(BRect updateRect);
	virtual void MouseDown(BPoint point);
	virtual void MouseMoved(
		BPoint point,
		uint32 transit,
		const BMessage* pDragMsg);
	virtual void MouseUp(BPoint point);
	
private:					// members
	bool					m_dragActive;
	bool					m_dragInProgress;
};

__END_CORTEX_NAMESPACE
#endif /*__DormantNodeView_H__*/
