// ChildNodeView.h (cortex/dr1)
// e.moon 6june99
//
//+++++ marked for death 11aug99 +++++
// NOTES +++++ [8jun99]
//    * TRANSPORT API +++++
//
// PURPOSE
//   Extends LiveNodeView to properly handle child nodes
//   (media nodes instantiated by this application, which
//   need to be handled properly (disconnected, released, etc.)
//
// HISTORY
//   e.moon		6june99		Begun

#ifndef __ChildNodeView_H__
#define __ChildNodeView_H__

#include "LiveNodeView.h"

// dr1 interim
class Transport;

class ChildNodeView :
	public		LiveNodeView {
	typedef	LiveNodeView _inherited;

public:					// ctor/dtor
	virtual ~ChildNodeView();
	ChildNodeView(
		MediaRoutingView* pRoutingView,
		const media_node& node);

public:					// LiveNodeView impl

	// layout
	virtual void populateMenu();
	virtual uint32 gridRowsNeeded() const;
	
	// handle resize
	virtual void FrameResized(float width, float height);

	// transport-icon click handler
	virtual void MouseDown(BPoint point);
	
	// draw the cell onto the given view
	virtual void drawCell(BView* v, BRect updateRect,
		bool bDrawBackground=true);

	// draw the transport icon
	virtual void drawTransportIcon(BView* v, BRect frame);

	// figure colors
	virtual void prepareColors();

public:					// operations
	virtual void releaseNode();

	void setActiveTransport(Transport* pTransport); //nyi
	Transport* activeTransport() const { return m_pActiveTransport; }

	// 8jun99: redraw transport-icon
	void invalidateTransportIcon();
	
public:					// BView impl
	virtual void DetachedFromWindow();

protected:				// internal operations
	virtual void handleTransportClick(BPoint point); //nyi
		
private:					// members
	bool						m_nodeReleased;

	Transport*		m_pActiveTransport;
	
	// frame for the transport icon
	BRect					m_transportIconFrame;

	rgb_color			m_backColorInactive;
	rgb_color			m_backColorActive;
	rgb_color			m_borderColor;
};

#endif /*__ChildNodeView_H__*/