// RoutingColumn.h
// e.moon 7may99 (MediaRoutingView)
//
// PURPOSE
//   Base class for the specific MediaRoutingView column
//   types (GutterColumn and NodeColumn, so far.)
//   Stores a list of wire segments touching or crossing
//   this column, for fast wire lookup.
//
// HISTORY
//   e.moon	7may99:	created

#ifndef __ROUTINGCOLUMN_H__
#define __ROUTINGCOLUMN_H__

#include <list>

#include "GridColumn.h"
#include "WireSegment.h"

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class RoutingColumn :
	public		GridColumn {
	
public:
	virtual ~RoutingColumn() {}
	RoutingColumn(float width, uint32 flags=0) :
		GridColumn(width, flags) {}

public:					// segment operations	
	const list<WireSegment>& segments() const { return m_segments; }
	bool removeSegment(const WireSegment& segment) {
		uint32 n = m_segments.size();
		m_segments.remove(segment);
		return (n - m_segments.size()) != 0;
	}
	
public:					// members [+++++ should NOT be public]

	// all wire segments touching this column
	list<WireSegment>		m_segments;
};


__END_CORTEX_NAMESPACE
#endif /* __ROUTINGCOLUMN_H__ */
