// RouteWindow.h
// e.moon 14may99
//
// PURPOSE
//   Window class containing a MediaRoutingView for
//   inspection & manipulation of Media Kit nodes.
//
// HISTORY
//   14may99		e.moon		Created from routeApp.cpp

#ifndef __ROUTEWINDOW_H__
#define __ROUTEWINDOW_H__

#include <list>

#include <Node.h>
#include <Window.h>

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class MediaRoutingView;
class NodeManager;

class InspectorWindow;

class RouteWindow :
	public		BWindow {
	typedef	BWindow _inherited;

public:													// messages
	enum message_t {
		M_TOGGLE_GROUP_INSPECTOR		=RouteWindow_message_base,
		
		// nodeID: int32
		M_SHOW_NODE_INSPECTOR,
		
		// groupID: int32
		M_REFRESH_TRANSPORT_SETTINGS,
		
		// [e.moon 20oct99]
		// inspector: pointer
		// frame: BRect
		M_INSPECTOR_CLOSED
	};

public:													// ctor/dtor
	virtual ~RouteWindow();
	RouteWindow(
		NodeManager*								manager);
		
public:													// inspector operations
public:													// BWindow impl
	bool QuitRequested();
	
public:													// BHandler impl
	void MessageReceived(
		BMessage*										message);

private:												// init helpers
	void buildViewMenu(
		BMenuBar*										menuBar);
	void populateFontMenu(
		BMenu*											menu);
	void populateFontSizeMenu(
		BMenu*											menu);
		
private:												// implementation
	friend class RouteApp;
	void _toggleGroupInspector();

	void _showNodeInspector(
		BMessage*										message); //nyi

	void _inspectorClosed(
		BMessage*										message); //nyi

	void _handleNodeSelected(
		BMessage*										message);

	void _handleGroupSelected(
		BMessage*										message);



	// refresh the transport window for the given group, if any		
	void _refreshTransportSettings(
		BMessage*										message); //nyi
		
	void _closeInspectors();
	
	BPoint _nextNodeInspectorPosition();

	// window positions	& font settings are archived
	// to attributes
	void _archiveSettings(
		BNode*											node); //nyi

	void _restoreSettings(
		BNode*											node); //nyi
	
private:												// members
	MediaRoutingView*				m_routingView;
	BScrollView*						m_scrollView;
		
	InspectorWindow*				m_groupInspectorWindow;
	list<InspectorWindow*>	m_nodeInspectorWindows;
	
	BWindow*								m_dormantNodeWindow;
	
	BMenuItem*							m_groupInspectorItem;
	BPoint									m_groupInspectorPosition;

	BPoint									m_nodeInspectorBasePosition;
		
	// all items in this menu control the routing view
	BMenu*									m_viewMenu;
	
private:													// constants
	static const BRect					s_initFrame;
	static const char* const		s_windowName;
};

__END_CORTEX_NAMESPACE
#endif /* __ROUTEWINDOW_H__ */
