// AudioAdapterNode.h

#ifndef __AudioAdapterNode_H__
#define __AudioAdapterNode_H__

#include "AudioFilterNode.h"

class _AudioAdapterNode :
	public	AudioFilterNode {
	typedef	AudioFilterNode _inherited;

public:													// ctor/dtor
	virtual ~_AudioAdapterNode();
	_AudioAdapterNode(
		const char*									name,
		IAudioOpFactory*						opFactory,
		BMediaAddOn*								addOn=0);

public:													// AudioFilterNode
	status_t getRequiredInputFormat(
		media_format&								ioFormat);
	status_t getPreferredInputFormat(
		media_format&								ioFormat);
		
	status_t getRequiredOutputFormat(
		media_format&								ioFormat);
	
	status_t getPreferredOutputFormat(
		media_format&								ioFormat);
	
	status_t validateProposedInputFormat(
		const media_format&					preferredFormat,
		media_format&								ioProposedFormat);

	status_t validateProposedOutputFormat(
		const media_format&					preferredFormat,
		media_format&								ioProposedFormat);

public:													// BBufferProducer/Consumer

	// lock input
	virtual status_t Connected(
		const media_source&					source,
		const media_destination&		destination,
		const media_format&					format,
		media_input*								outInput);

	// unlock input
	virtual void Disconnected(
		const media_source&					source,
		const media_destination&		destination);

	// lock output
	virtual void Connect(
		status_t										status,
		const media_source&					source,
		const media_destination&		destination,
		const media_format&					format,
		char*												ioName);
		
	// unlock output
	virtual void Disconnect(
		const media_source&					source,
		const media_destination&		destination);

//	// AudioFilterNode::FormatProposal() simply validates the proposed format.
//	// 17sep99: if an input connection's been made, specialize the given output
//	// format enough to suggest a buffer size (format & channel_count.)
//
//	status_t FormatProposal(
//		const media_source&					source,
//		media_format*								ioFormat);
};



#endif /*__AudioAdapterNode_H__*/