#ifndef BIGENDIANFIX_H
#define BIGENDIANFIX_H


#include "StudioModel.h"


#ifdef DEBUG
#define PINT(arg)   printf("%s == %d\n", #arg, arg);
#define PFLOAT(arg) printf("%s == %f\n", #arg, arg);
#define PSTR(arg)   printf("%s == %s\n", #arg, arg);
#else
#define PINT(arg)
#define PFLOAT(arg)
#define PSTR(arg)
#endif


#ifdef __cplusplus
extern "C" {
#endif


void FixVec3(vec3_t &arg);

int FixMDLHdr(studiohdr_t *hdr);
int FixMDLBone(mstudiobone_t *bone);
int FixMDLBoneController(mstudiobonecontroller_t *bonecontroller);
int FixMDLBBox(mstudiobbox_t *bbox);
int FixMDLSeqGroup(mstudioseqgroup_t *seqgroup);
int FixMDLSeqDesc(studiohdr_t *hdr, mstudioseqdesc_t *seqdesc);
int FixMDLEvent(mstudioevent_t *event);
int FixMDLPivot(mstudiopivot_t *pivot);
int FixMDLAttachment(mstudioattachment_t *attachment);
int FixMDLAnim(studiohdr_t *hdr);
int FixMDLBodyParts(studiohdr_t *hdr, mstudiobodyparts_t *bodyparts);
int FixMDLTexture(mstudiotexture_t *texture);
int FixMDLModel(studiohdr_t *hdr, mstudiomodel_t *model);
int FixMDLMesh(studiohdr_t *hdr, mstudiomesh_t *mesh);

int FixMDLIfBigEndian(void *mdl);


#ifdef __cplusplus
}
#endif


#endif
