#include <InterfaceKit.h>
#include <CheckBox.h>
#include <Menu.h>
#include <Slider.h>
#include <stdio.h>


#include "StudioModel.h"
#include "ViewerSettings.h"
#include "ControlView.h"


ControlView::ControlView(BRect frame) : 
   BTabView(frame, "ControlView", B_WIDTH_AS_USUAL, B_FOLLOW_BOTTOM|B_FOLLOW_LEFT_RIGHT)
{
   CreateRenderTab();
   CreateSequenceTab();
   CreateBodyTab();
   CreateTextureTab();
}


void ControlView::AttachedToWindow(void)
{
   BTabView::AttachedToWindow();

   renderModeMenu->SetTargetForItems(this);
   cbGround->SetTarget(this);
   cbBackground->SetTarget(this);
   cbHitBoxes->SetTarget(this);
   cbBones->SetTarget(this);
   cbAttachments->SetTarget(this);
   transparency->SetTarget(this);

   sequenceMenu->SetTargetForItems(this);
   speed->SetTarget(this);

   controllerMenu->SetTargetForItems(this);
   controller->SetTarget(this);
   bodypartsMenu->SetTargetForItems(this);
   submodelMenu->SetTargetForItems(this);
}


void ControlView::MessageReceived(BMessage *message)
{
   BMenuItem *item;

   switch (message->what) {
   case IDC_RENDERMODE:
      message->FindPointer("source", (void **)&item);
      g_viewerSettings.renderMode = renderModeMenu->IndexOf(item);
      break;

   case IDC_TRANSPARENCY:
      g_viewerSettings.transparency = (float) (100 - transparency->Value()) / 100.0;
      break;

   case IDC_GROUND:
      g_viewerSettings.showGround = (cbGround->Value() == B_CONTROL_ON);
      break;

   case IDC_BACKGROUND:
      g_viewerSettings.showBackground = (cbBackground->Value() == B_CONTROL_ON);
      break;

   case IDC_HITBOXES:
      g_viewerSettings.showHitBoxes = (cbHitBoxes->Value() ==  B_CONTROL_ON);
      break;

   case IDC_BONES:
      g_viewerSettings.showBones = (cbBones->Value() ==  B_CONTROL_ON);
      break;

   case IDC_ATTACHMENTS:
      g_viewerSettings.showAttachments = (cbAttachments->Value() ==  B_CONTROL_ON);
      break;

   case IDC_SEQUENCE:
      message->FindPointer("source", (void **)&item);
      g_studioModel.SetSequence(sequenceMenu->IndexOf(item));
      g_viewerSettings.sequence = sequenceMenu->IndexOf(item);
      break;

   case IDC_SPEEDSCALE:
      g_viewerSettings.speedScale = (float)(speed->Value()*5)/200;
      break;

   case IDC_BODYPART:
      message->FindPointer("source", (void **)&item);
      setBodypart(bodypartsMenu->IndexOf(item));
      break;

   case IDC_SUBMODEL:
      message->FindPointer("source", (void **)&item);
      g_studioModel.SetBodygroup(bodypartsMenu->IndexOf(bodypartsMenu->FindMarked()), 
				 submodelMenu->IndexOf(item));
      g_viewerSettings.submodels[bodypartsMenu->IndexOf(bodypartsMenu->FindMarked())] 
	 = submodelMenu->IndexOf(item);
      break;

   case IDC_CONTROLLER: 
      setBoneController();
      break;

   case IDC_CONTROLLERVALUE:
      setBoneControllerValue();
      break;
   }
}


void ControlView::CreateRenderTab(void)
{
   BView *view = new BView(Bounds(), "RenderTab", B_FOLLOW_ALL_SIDES, B_WILL_DRAW);

   view->SetViewColor(216, 216, 216, 0);

   BMenu *menu = new BPopUpMenu("Render Mode");
   BMenuItem *item;

   item = new BMenuItem("Wireframe", new BMessage(IDC_RENDERMODE));
   menu->AddItem(item);
   item = new BMenuItem("Flatshaded", new BMessage(IDC_RENDERMODE));
   menu->AddItem(item);
   item = new BMenuItem("Smoothshaded", new BMessage(IDC_RENDERMODE));
   menu->AddItem(item);
   item = new BMenuItem("Textured", new BMessage(IDC_RENDERMODE));
   item->SetMarked(1);
   menu->AddItem(item);
   BMenuField *popup = new BMenuField(BRect(5, 5, 105, 30),
				      "renderModeField", "Render Mode:", menu);
   popup->SetDivider(0);
   view->AddChild(popup);

   renderModeMenu = menu;

   transparency = new BSlider(BRect(5, 55, 210, 80), "Transparency", "Transparency", 
			      new BMessage(IDC_TRANSPARENCY), 1, 100);
   transparency->SetValue(1);
   view->AddChild(transparency);

   view->AddChild(cbGround = new BCheckBox(BRect(110, 5, 210, 25), "Ground", 
						 "Ground", new BMessage(IDC_GROUND)));

   view->AddChild(cbBackground = new BCheckBox(BRect(110, 38, 210, 58), "Background", 
						     "Background", new BMessage(IDC_BACKGROUND)));

   view->AddChild(cbHitBoxes = new BCheckBox(BRect(215, 5, 315, 25), "Hitboxes",
                                                   "Hit-Boxes", new BMessage(IDC_HITBOXES)));

   view->AddChild(cbBones = new BCheckBox(BRect(215, 38, 315, 58), "Bones",
                                                "Bones", new BMessage(IDC_BONES)));

   view->AddChild(cbAttachments = new BCheckBox(BRect(215, 71, 315, 91), "Attachments",
                                                "Attachments", new BMessage(IDC_ATTACHMENTS)));
   
   BTab *tab = new BTab();
   AddTab(view, tab);
   tab->SetLabel("Render");
}


void ControlView::CreateSequenceTab(void)
{
   BView *view = new BView(Bounds(), "SequenceTab", B_FOLLOW_ALL_SIDES, B_WILL_DRAW);

   view->SetViewColor(216, 216, 216, 0);

   BMenu *menu = new BPopUpMenu("Sequence");

   BMenuField *popup = new BMenuField(BRect(5, 5, 210, 30),
				      "sequenceField", "Sequence:", menu);
   popup->SetDivider(0);
   view->AddChild(popup);
   
   sequenceMenu = menu;
   sequenceMenu->SetEnabled(false);

   speed = new BSlider(BRect(5, 55, 210, 80), "SpeedScale", "Speed Scale", 
		       new BMessage(IDC_SPEEDSCALE), 0, 200);
   speed->SetValue(40);
   speed->SetEnabled(false);
   view->AddChild(speed);

   BTab *tab = new BTab();
   AddTab(view, tab);
   tab->SetLabel("Sequence");
}


void ControlView::CreateBodyTab(void)
{
   BView *view = new BView(Bounds(), "BodyTab", B_FOLLOW_ALL_SIDES, B_WILL_DRAW);

   view->SetViewColor(216, 216, 216, 0);

   BMenu *menu = new BPopUpMenu("Controller");

   BMenuField *popup = new BMenuField(BRect(5, 5, 105, 30),
				      "controllerField", "Controller:", menu);
   popup->SetDivider(0);
   view->AddChild(popup);

   controllerMenu = menu;
   controllerMenu->SetEnabled(false);
   
   controller = new BSlider(BRect(5, 55, 210, 80), "controllerSlider",
			    "Controller Value", new BMessage(IDC_CONTROLLERVALUE), 0, 100);
   controller->SetValue(50);
   controller->SetEnabled(false);
   view->AddChild(controller);

   menu = new BPopUpMenu("Body Part");
   popup = new BMenuField(BRect(110, 5, 210, 30),
			  "bodyPartField", "Body Part:", menu);
   popup->SetDivider(0);
   view->AddChild(popup);

   bodypartsMenu = menu;
   bodypartsMenu->SetEnabled(false);

   menu = new BPopUpMenu("Submodel");
   popup = new BMenuField(BRect(110, 35, 210, 55),
			  "submodelField", "Submodel:", menu);
   popup->SetDivider(0);
   view->AddChild(popup);

   submodelMenu = menu;
   submodelMenu->SetEnabled(false);

   BTab *tab = new BTab();
   AddTab(view, tab);
   tab->SetLabel("Body");
}


void ControlView::CreateTextureTab(void)
{
}


void ControlView::initSequences(void)
{
   Window()->Lock();
   studiohdr_t *hdr = g_studioModel.getStudioHeader ();
   if (hdr) {
      while(sequenceMenu->CountItems() > 0)
	 delete sequenceMenu->RemoveItem((long)0);
      
      for (int i=0; i < hdr->numseq; i++) {
	 mstudioseqdesc_t *pseqdescs = (mstudioseqdesc_t *)
	    ((byte *) hdr + hdr->seqindex);

	 BMenuItem *item = new BMenuItem(pseqdescs[i].label, new BMessage(IDC_SEQUENCE));
	 sequenceMenu->AddItem(item);
      }

      if (hdr->numseq > 0) {
	 sequenceMenu->ItemAt(0)->SetMarked(1);
	 g_studioModel.SetSequence(0);
	 g_viewerSettings.sequence = 0;

	 sequenceMenu->SetTargetForItems(this);
	 sequenceMenu->SetEnabled(true);
	 speed->SetEnabled(true);
      } else {
	 sequenceMenu->SetEnabled(false);
	 speed->SetEnabled(false);
      }
   } else {
      while(sequenceMenu->CountItems() > 0)
	 delete sequenceMenu->RemoveItem((long)0);

      sequenceMenu->SetEnabled(false);
      speed->SetEnabled(false);
   }
   Window()->Unlock();
}


void ControlView::initBodyparts(void)
{
   Window()->Lock();
   studiohdr_t *hdr = g_studioModel.getStudioHeader ();
   if (hdr) {
      while (bodypartsMenu->CountItems() > 0)
	 delete bodypartsMenu->RemoveItem((int32)0);

      mstudiobodyparts_t *pbodyparts = (mstudiobodyparts_t *)
	 ((byte *) hdr + hdr->bodypartindex);

      for (int i = 0; i < hdr->numbodyparts; i++) {

	 BMenuItem *item = new BMenuItem(pbodyparts[i].name, new BMessage(IDC_BODYPART));
	 bodypartsMenu->AddItem(item);
      }

      if (hdr->numbodyparts > 0) {
	 setBodypart(0);

	 bodypartsMenu->SetTargetForItems(this);
	 bodypartsMenu->SetEnabled(true);
      } else {
	 bodypartsMenu->SetEnabled(false);
      }
   } else {
      while (bodypartsMenu->CountItems() > 0)
	 delete bodypartsMenu->RemoveItem((int32)0);

      bodypartsMenu->SetEnabled(false);
      setBodypart(0);
   }
   Window()->Unlock();
}


void ControlView::initBoneControllers(void)
{
   Window()->Lock();
   studiohdr_t *hdr = g_studioModel.getStudioHeader ();
   if (hdr) {
      controllerMenu->SetEnabled(hdr->numbonecontrollers > 0);
      controller->SetEnabled(hdr->numbonecontrollers > 0);

      while (controllerMenu->CountItems() > 0)
	 delete controllerMenu->RemoveItem((long)0);

      mstudiobonecontroller_t *pbonecontrollers = 
	 (mstudiobonecontroller_t *) ((byte *) hdr + hdr->bonecontrollerindex);
      
      for (int i = 0; i < hdr->numbonecontrollers; i++) {
	 char str[32];
	 if (pbonecontrollers[i].index == 4) {
	    sprintf (str, "Mouth");
	 } else {
	    sprintf (str, "Controller %d", pbonecontrollers[i].index);
	 }

	 BMenuItem *item = new BMenuItem(str, new BMessage(IDC_CONTROLLER));
	 controllerMenu->AddItem(item);
      }
      
      if (hdr->numbonecontrollers > 0) {
	 controllerMenu->ItemAt(0)->SetMarked(1);
	 setBoneController();

	 controllerMenu->SetTargetForItems(this);
	 controllerMenu->SetEnabled(true);
	 controller->SetEnabled(true);
      } else {
	 controllerMenu->SetEnabled(false);
	 controller->SetEnabled(false);
      }
   } else {
      while (controllerMenu->CountItems() > 0)
	 delete controllerMenu->RemoveItem((long)0);
      
      controllerMenu->SetEnabled(false);
      controller->SetEnabled(false);
   }
   Window()->Unlock();
}


void ControlView::setShowBackground(bool status)
{
   cbBackground->SetValue(status);
   g_viewerSettings.showBackground = (cbBackground->Value() == B_CONTROL_ON);
}


void ControlView::setShowGround(bool status)
{
   cbGround->SetValue(status);
   g_viewerSettings.showGround = (cbGround->Value() == B_CONTROL_ON);
}


void ControlView::setBodypart(int index)
{
   studiohdr_t *hdr = g_studioModel.getStudioHeader ();
   if (hdr) {
      BMenuItem *item = bodypartsMenu->ItemAt(index);
      item->SetMarked(1);

      while (submodelMenu->CountItems() > 0)
	 delete submodelMenu->RemoveItem((long)0);

      mstudiobodyparts_t *pbodyparts = (mstudiobodyparts_t *)
	 ((byte *) hdr + hdr->bodypartindex);

      for (int i = 0; i < pbodyparts[index].nummodels; i++) {
	 char str[64];
	 sprintf (str, "Submodel %d", i + 1);

	 BMenuItem *item = new BMenuItem(str, new BMessage(IDC_SUBMODEL));
	 submodelMenu->AddItem(item);
      }

      if (pbodyparts[index].nummodels > 0) {
	 submodelMenu->ItemAt(0)->SetMarked(1);

	 submodelMenu->SetTargetForItems(this);
	 submodelMenu->SetEnabled(true);
      } else {
	 submodelMenu->SetEnabled(false);
      }

      g_studioModel.SetBodygroup(index, 0);
   } else {
      while (submodelMenu->CountItems() > 0)
	 delete submodelMenu->RemoveItem((long)0);

      submodelMenu->SetEnabled(false);
   }
}


void ControlView::setBoneController(void)
{
   studiohdr_t *hdr = g_studioModel.getStudioHeader();
   if (hdr) {
      mstudiobonecontroller_t *pbonecontrollers = 
	 (mstudiobonecontroller_t *) ((byte *) hdr + hdr->bonecontrollerindex); 
      
      BView *view = controller->Parent();
      
      view->RemoveChild(controller);
      delete controller;
      
      int controller_index = controllerMenu->IndexOf(controllerMenu->FindMarked());
      
      controller = new BSlider(BRect(5, 55, 210, 80), "controllerSlider",
			       "Controller Value", new BMessage(IDC_CONTROLLERVALUE), 
			       pbonecontrollers[controller_index].start, 
			       pbonecontrollers[controller_index].end);
      
      view->AddChild(controller);
 
      controller->SetValue((int)g_viewerSettings.controllers[controller_index]);
      controller->SetTarget(this);
   }
}


void ControlView::setBoneControllerValue(void)
{
   studiohdr_t *hdr = g_studioModel.getStudioHeader ();
   if (hdr) {
      mstudiobonecontroller_t *pbonecontrollers = 
	 (mstudiobonecontroller_t *) ((byte *) hdr + hdr->bonecontrollerindex);
      
      int controller_index = controllerMenu->IndexOf(controllerMenu->FindMarked());
      
      if (pbonecontrollers[controller_index].index == 4) {
	 g_studioModel.SetMouth ((float)controller->Value());
      } else {
	 g_studioModel.SetController (pbonecontrollers[controller_index].index, 
				      (float)controller->Value());
      }
      
      g_viewerSettings.controllers[controller_index] = (float)controller->Value();
   }
}
