#ifndef HLMVIEWER_H
#define HLMVIEWER_H


#include <DirectWindow.h>
#include <Application.h>


static const char *APP_SIG="application/x-vnd.dungan.hlmviewer";


class MenuView;
class ControlView;
class PAKView;
class GlView;
class BFilePanel;
class YColorControlWindow;


class HLMViewerWindow : public BDirectWindow {
   MenuView *menubar;
   ControlView *control;
   BWindow *pak_win;
   PAKView *pak;
   GlView *glview;

   BFilePanel *file_panel;

   YColorControlWindow *cWin1;
   YColorControlWindow *cWin2;
public:
   HLMViewerWindow(BRect frame);
   
   virtual bool QuitRequested(void);
   virtual void MessageReceived(BMessage *message);

   void loadModel(const char *filename);
   void centerView(void);
};


class HLMViewerApp : public BApplication {
   HLMViewerWindow *window;
public:
   HLMViewerApp(void) : BApplication(APP_SIG) {}

   virtual void ReadyToRun(void);
   virtual void RefsReceived(BMessage *message);
};


#endif
