// BitmapConversion.cpp
// © 1998 Matt Lewinski
// Simple BBitmap Conversions

#include "BitmapConversion.h"

// Convert a bitmap to type B_RGB_32_BIT.
BBitmap*	BitmapTo32(BBitmap* inBitmap) {
	BBitmap		*outBitmap;
	BScreen		*theScreen;
	int32		width, height;
	rgb_color		theRGB;
	uint32		*the32Bits, theColor;
	uint8		*the8Bits, theIndex, red, blue, green, alpha;

	// Create the return bitmap, and if the input bitmap is already
	// in the right type, copy the bits in.
	outBitmap		= new BBitmap(inBitmap->Bounds(), B_RGB_32_BIT);
	if(inBitmap->ColorSpace() == B_RGB_32_BIT) {
		outBitmap->SetBits(inBitmap->Bits(), inBitmap->BitsLength(), 0, B_RGB_32_BIT);
		return outBitmap;		
	}
	
	theScreen		= new BScreen();
	
	width 	= inBitmap->Bounds().Width();
	height 	= inBitmap->Bounds().Height();
	the32Bits	= (uint32*) outBitmap->Bits();
	the8Bits	= (uint8*) inBitmap->Bits();

	// Loop through the bitmap and convert pixels to 32 bit using the
	// BScreen's palette. 
	for(int32 x = 0; x <= width; x++) {
		for(int32 y = 0; y <= height; y++) {
			theIndex	= the8Bits[(int)(x + y * inBitmap->BytesPerRow())];
			theRGB = theScreen->ColorForIndex(theIndex);
					
			red		= theRGB.red;
			green	= theRGB.green;
			blue		= theRGB.blue;
			
			if(theIndex == B_TRANSPARENT_8_BIT)
				theRGB = B_TRANSPARENT_32_BIT;
			
			alpha	= theRGB.alpha;

			theColor = (blue << 24) | (green << 16) | (red << 8) | alpha;
			the32Bits[(int)(x + y * (outBitmap->BytesPerRow() / 4))] = theColor;
		}
	}
	return outBitmap;
}

// Convert a bitmap to type B_COLOR_8_BIT.
BBitmap*	BitmapTo8(BBitmap* inBitmap) {
	BBitmap		*outBitmap;
	BScreen		*theScreen;
	int32		width, height;
	rgb_color		theRGB;
	uint32		*the32Bits, theColor;
	uint8		*the8Bits, theIndex, red, blue, green, alpha;

	// Create the return bitmap, and if the input bitmap is already
	// in the right type, copy the bits in.
	outBitmap		= new BBitmap(inBitmap->Bounds(), B_COLOR_8_BIT);
	if(inBitmap->ColorSpace() == B_COLOR_8_BIT) {
		outBitmap->SetBits(inBitmap->Bits(), inBitmap->BitsLength(), 0, B_COLOR_8_BIT);
		return outBitmap;		
	}
		
	theScreen		= new BScreen();
	
	width = inBitmap->Bounds().Width();
	height = inBitmap->Bounds().Height();
	the8Bits	= (uint8*) outBitmap->Bits();
	the32Bits	= (uint32*) inBitmap->Bits();

	// Loop through the bitmap and convert pixels to 8 bit using
	// what the BScreen thinks is the closest match.
	for(int32 x = 0; x <= width; x++) {
		for(int32 y = 0; y <= height; y++) {
			theColor	= the32Bits[(int)(x + y * (inBitmap->BytesPerRow() / 4))];
			red		= (theColor >> 8) & 0xff;
			green	= (theColor >> 16) & 0xff;
			blue		= (theColor >> 24) & 0xff;
			alpha	= theColor & 0xff;
			theRGB.red 	= red;
			theRGB.blue 	= blue;
			theRGB.green 	= green;
			theRGB.alpha 	= alpha;
			theIndex		= theScreen->IndexForColor(theRGB);

			if(theRGB.red == B_TRANSPARENT_32_BIT.red && 
				theRGB.blue == B_TRANSPARENT_32_BIT.blue &&
				theRGB.green == B_TRANSPARENT_32_BIT.green)
			{
				theIndex = B_TRANSPARENT_8_BIT;
			}
			
			the8Bits[(int)(x + y * (outBitmap->BytesPerRow()))] = theIndex;
		}
	}
	return outBitmap;
}