// icon2tga.cpp
// © 1998 Matt Lewinski
// Streamable Bitmap (from datatypes library)

#include <Datatypes.h>
#include "BitmapStream.h"
#include "BitmapConversion.h"

const char kSignature[] = "application/x-vnd.lewinski-icon2tga";

int main(int argc, char** argv) {
	BApplication	*theApp;
	BBitmap		*outSMap, *outBMap;
	BDirectory	*currDirectory;
	BEntry		*inEntry, *theEntry;	
	BFile		*outSFile, *outBFile, *theAddon;;
	BNode		*inNode;
	BNodeInfo		*inNodeInfo;
	BPath		*thePath, *theParent;
	BitmapStream	*outSStream, *outBStream;
	char			*inName, *outSName, *outBName;

	if(argc <= 1) {
		printf("usage: img2icon <input icon>\n");
		return 1;
	}
	
	theApp		= new BApplication(kSignature);	
	outSMap		= new BBitmap(BRect(0, 0, 15, 15), B_COLOR_8_BIT);
	outBMap		= new BBitmap(BRect(0, 0, 31, 31), B_COLOR_8_BIT);
	currDirectory	= new BDirectory();
	outSFile 		= new BFile();
	outBFile 		= new BFile();
	inName 		= new char[B_FILE_NAME_LENGTH];
	outSName 		= new char[B_FILE_NAME_LENGTH];
	outBName 		= new char[B_FILE_NAME_LENGTH];			
	inEntry 		= new BEntry(argv[1]);
	inNode		= new BNode(inEntry);
	inNodeInfo	= new BNodeInfo(inNode);
	
	// Copy the bitmaps out of the Tracker
	inNodeInfo->GetTrackerIcon(outSMap, B_MINI_ICON);
	inNodeInfo->GetTrackerIcon(outBMap, B_LARGE_ICON);
	
	// Create the Bitmaps for writing.
	outSStream = new BitmapStream(BitmapTo32(outSMap));
	outBStream = new BitmapStream(BitmapTo32(outBMap));
	
	// Get the name of the input file.
	inEntry->GetName(inName);
	
	// Get the parent of the input file.
	inEntry->GetParent(currDirectory);
	
	// Append to filename.
	sprintf(outSName, "%s_small.tga", inName);
	sprintf(outBName, "%s_big.tga", inName);
	
	// Create files.
	currDirectory->CreateFile(outSName, outSFile, false);
	currDirectory->CreateFile(outBName, outBFile, false);
	
	// Check if datatypes is present.
	if(DATAVersion == NULL) {
		printf("fatal error: DATAVersion == NULL\n");
		return 1;
	}

	// Get the application signature.
	app_info	theInfo;
	if(be_app->GetAppInfo(&theInfo) != B_OK) {
		printf("fatal error: be_app->GetAppInfo()\n");
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
				
	theEntry		= new BEntry(&theInfo.ref, true);
	thePath 		= new BPath();
	theParent 	= new BPath();

	theEntry	->GetPath(thePath);
	thePath	->GetParent(theParent);
	theParent	->Append("datatypes");

	// Try initialization.
	if(DATAInit(kSignature, theParent->Path())) {
		printf("fatal error: DATAInit()\n");
		return 1;
	}

	// Write into new files.
	DATATranslate(*outSStream, NULL, NULL, *outSFile, 'TGA ');
	DATATranslate(*outBStream, NULL, NULL, *outBFile, 'TGA ');
	
	printf("Image creation sucessfully completed.\n");
	return 0;
}
