/*
 *  @(#) cAudioWrap.h 0.1, last edit: 04/04/97
 *  @(#) Copyright (C) 1997 Pierre Brua (brua@dess-info.u-strasbg.fr)
 * 
 *

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
// -------------------------------------------------------------------
// File Name : cAudioWrap.h
// Created   : 1997/03/30
// Version   : 0.1
// Author    : Pierre Brua
// Distrib   : 
// -------------------------------------------------------------------
// Purpose   : Allow an incoming buffered data flow to be
//             transmitted to the audio stream.
// -------------------------------------------------------------------
// Todo : (o : todo; / : begin; x : done)
//
// -------------------------------------------------------------------
// History :
// 	1997/03/30 : File created
// 	1997/04/02 : End of implementation
//
// -------------------------------------------------------------------
// symbol FIXME mark problems to fix. 
// -------------------------------------------------------------------
#if defined cAudioWrap_CYCLE
#error Header cyclic inclusion detected in cAudioWrap.h
#else // defined cAudioWrap_CYCLE
#define cAudioWrap_CYCLE
#if !defined (cAudioWrap_H)
#define cAudioWrap_H
// -------------------------------------------------------------------
// Includes

//
// -------------------------------------------------------------------
// defines

#define BUFFER_SIZE 524288	// 512 ko 
#define BEGINNING_DELAY 1  // the audio will play 2 seconds after we
                           // begin to decode(like the rabbit in the
                           // tale, you know ?)

#define FULL_WAITING (BEGINNING_DELAY*1000000)
                           // time the encoder will wait to put a
                           // buffer in audio_buffer
                           // this shouldn't be needed, but I don't
                           // know how to make acquire_sem_etc block

#define BYTES_PER_SAMPLE 2 // 2 = 16 bits
#define ERRORMSG(a,b) printf(b)

//
// -------------------------------------------------------------------
// Class cAudioWrap

class cAudioWrap
{
	public:
	// Standard services
	cAudioWrap (long nb_voices);
	~cAudioWrap (void);
	long AddData(char *buffer, long size);
	sem_id buffer_empty;
	sem_id buffer_full;
	sem_id memory_access;
	long buffer_begin; // position of the beginning of the buffer
	int v;
	uint16 *buffer_pos;
	uint8 audio_buffer[BUFFER_SIZE]; // store the audio data
	uint8 *buffer_max;
//	BAudioSubscriber    *fSubscriber;
//	long                fSubscriberID;
	BSubscriber			*fSubscriber;
	BDACStream			*fDACStream;
	long nbvoices;
	bool activate_warning;
	// Debug
/////////////////////	inline void SelfDisplay (cOStream& thatStream) const;
/////////////////////	bool OK (void) const;
	
	// Interface
	
	private:
	// Datas
	thread_id           thread_no;
	
	// Hidden services
	cAudioWrap (cAudioWrap&);
	void AddBuffer(char *buffer, long position, long size);
};

//
// -------------------------------------------------------------------
// static members


/*long EndPlayBack(void *UserData, long error);*/
static bool FillPlaybackBuffer(void *userData, char *buffer, size_t count, void *header);
static long AudioWrap2 (void *data);

//
// -------------------------------------------------------------------
// Operators

/*inline cOStream& operator<< (cOStream& thatStream, const cAudioWrap& toDisplay)
{
	toDisplay.SelfDisplay (thatStream);
	return thatStream;
}*/



//
// -------------------------------------------------------------------
#endif // !defined (cAudioWrap_H)
#undef cAudioWrap_CYCLE
#endif // else defined cAudioWrap_CYCLE