
/*
	Simple demo to demonstrate what correct and incorrect mixing sounds
	like when run together with mixtest.
*/


bool correctmix=true;

class mywin : public BWindow
{
	public:			mywin(BRect r,char *name,window_type type,ulong mode)
						: BWindow(r,name,type,mode)
					{}

	virtual bool	QuitRequested()
					{
						be_app->PostMessage(B_QUIT_REQUESTED);
						return TRUE;
					}
	
	virtual void	MessageReceived(BMessage *mes)
					{
						switch(mes->what)
						{
							case 'crct':
								correctmix=true;
								break;
							case 'ncrt':
								correctmix=false;
								break;
							default:
								inherited::MessageReceived(mes);
								break;
						}
					}
};


bool _process_sound(void *arg, char *buf, ulong count, void *info);


void main(void)
{
	BApplication app("application/x-marcone-mixtest");

	size_t buffersize;
	int32 buffercount;
	bool isrunning;
	int32 subscribercount;

	BSubscriber *audsub=new BSubscriber("mix-test");
	BDACStream *audstream=new BDACStream();
	audsub->Subscribe(audstream);

	audstream->GetStreamParameters(&buffersize,&buffercount,&isrunning,&subscribercount);

	audsub->EnterStream(NULL,true, /* neighbor, after */
					audstream, // void *arg
					_process_sound,
					NULL,
					true /* run as seperate thread */
				 );
	mywin *win=new mywin(BRect(300,100,450,170),"Mix-test",B_TITLED_WINDOW,0);
	BView *view=new BView(BRect(0,0,150,70),"",B_FOLLOW_ALL_SIDES,B_WILL_DRAW);
	view->SetViewColor(200,200,200);
	win->AddChild(view);
	BRadioButton *r1=new BRadioButton(BRect(10,20,200,36),"","Correct mixing",new BMessage('crct'));
	BRadioButton *r2=new BRadioButton(BRect(10,40,200,56),"","Incorrect mixing",new BMessage('ncrt'));
	view->AddChild(r1);
	view->AddChild(r2);
	r1->SetValue(1);
	
	win->Show();
	app.Run();
	
	audsub->ExitStream(true);                 // wait until subscriber exits
	audstream->SetStreamBuffers(buffersize,buffercount); // restore settings
}

float sinecount1=0;
float sinecount2=0;
float sinecount3=0;

bool _process_sound(void *arg, char *buf, ulong count, void *info)
{
	BDACStream *thisstream=(BDACStream *)arg;

	short *shortbuf=(short*)buf;
	long tmp;
	for(int i=0;i<count/2;i++)
	{
		tmp=float((sin(sinecount1*PI/360.0)+sin(sinecount2*PI/360.0)+sin(sinecount3*PI/360.0))*10000)+shortbuf[i];
		
		if(correctmix)
		{
			if(tmp>32767)
				shortbuf[i]=32767;
			else if(tmp<-32768)
				shortbuf[i]=-32768;
			else
				shortbuf[i]=tmp;
		}
		else
			shortbuf[i]=tmp;

		// major chord
		sinecount1+=4;
		sinecount2+=5.0396842;
		sinecount3+=5.993228308;
	}
	if(sinecount1>=36000)
		sinecount1-=36000;
	if(sinecount2>=36000)
		sinecount2-=36000;
	if(sinecount3>=36000)
		sinecount3-=36000;
	
	return true; // keep running
}

