/*
 *  mon_atraps.h - MacOS A-Line trap definitions
 *
 *  (C) 1997-1998 Marc Hellwig
 */

struct atrap_info {
	char *name;
	uint16 word;
};

static atrap_info atraps[] = {
	"NQDMisc"					, 0xABC3,
	"CopyMask"					, 0xA817,
	"MeasureText"				, 0xA837,
	"GetMaskTable"				, 0xA836,
	"CalcMask"					, 0xA838,
	"SeedFill"					, 0xA839,
	"InitCursor"				, 0xA850,
	"SetCursor"					, 0xA851,
	"HideCursor"				, 0xA852,
	"ShowCursor"				, 0xA853,
	"ShieldCursor"				, 0xA855,
	"ObscureCursor"				, 0xA856,
	"BitAnd"					, 0xA858,
	"BitXOr"					, 0xA859,
	"BitNot"					, 0xA85A,
	"BitOr"						, 0xA85B,
	"BitShift"					, 0xA85C,
	"BitTst"					, 0xA85D,
	"BitSet"					, 0xA85E,
	"BitClr"					, 0xA85F,
	"Random"					, 0xA861,
	"ForeColor"					, 0xA862,
	"BackColor"					, 0xA863,
	"ColorBit"					, 0xA864,
	"GetPixel"					, 0xA865,
	"StuffHex"					, 0xA866,
	"LongMul"					, 0xA867,
	"FixMul"					, 0xA868,
	"FixRatio"					, 0xA869,
	"HiWord"					, 0xA86A,
	"LoWord"					, 0xA86B,
	"FixRound"					, 0xA86C,
	"InitPort"					, 0xA86D,
	"InitGraf"					, 0xA86E,
	"OpenPort"					, 0xA86F,
	"LocalToGlobal"				, 0xA870,
	"GlobalToLocal"				, 0xA871,
	"GrafDevice"				, 0xA872,
	"SetPort"					, 0xA873,
	"GetPort"					, 0xA874,
	"SetPBits"					, 0xA875,
	"PortSize"					, 0xA876,
	"MovePortTo"				, 0xA877,
	"SetOrigin"					, 0xA878,
	"SetClip"					, 0xA879,
	"GetClip"					, 0xA87A,
	"ClipRect"					, 0xA87B,
	"BackPat"					, 0xA87C,
	"ClosePort"					, 0xA87D,
	"AddPt"						, 0xA87E,
	"SubPt"						, 0xA87F,
	"SetPt"						, 0xA880,
	"EqualPt"					, 0xA881,
	"StdText"					, 0xA882,
	"DrawChar"					, 0xA883,
	"DrawString"				, 0xA884,
	"DrawText"					, 0xA885,
	"TextWidth"					, 0xA886,
	"TextFont"					, 0xA887,
	"TextFace"					, 0xA888,
	"TextMode"					, 0xA889,
	"TextSize"					, 0xA88A,
	"GetFontInfo"				, 0xA88B,
	"StringWidth"				, 0xA88C,
	"CharWidth"					, 0xA88D,
	"SpaceExtra"				, 0xA88E,
	"StdLine"					, 0xA890,
	"LineTo"					, 0xA891,
	"Line"						, 0xA892,
	"MoveTo"					, 0xA893,
	"Move"						, 0xA894,
	"ShutDown"					, 0xA895,
	"HidePen"					, 0xA896,
	"ShowPen"					, 0xA897,
	"GetPenState"				, 0xA898,
	"SetPenState"				, 0xA899,
	"GetPen"					, 0xA89A,
	"PenSize"					, 0xA89B,
	"PenMode"					, 0xA89C,
	"PenPat"					, 0xA89D,
	"PenNormal"					, 0xA89E,
	"Unimplemented"				, 0xA89F,
	"StdRect"					, 0xA8A0,
	"FrameRect"					, 0xA8A1,
	"PaintRect"					, 0xA8A2,
	"EraseRect"					, 0xA8A3,
	"InverRect"					, 0xA8A4,
	"FillRect"					, 0xA8A5,
	"EqualRect"					, 0xA8A6,
	"SetRect"					, 0xA8A7,
	"OffsetRect"				, 0xA8A8,
	"InsetRect"					, 0xA8A9,
	"SectRect"					, 0xA8AA,
	"UnionRect"					, 0xA8AB,
	"Pt2Rect"					, 0xA8AC,
	"PtInRect"					, 0xA8AD,
	"EmptyRect"					, 0xA8AE,
	"StdRRect"					, 0xA8AF,
	"FrameRoundRect"			, 0xA8B0,
	"PaintRoundRect"			, 0xA8B1,
	"EraseRoundRect"			, 0xA8B2,
	"InverRoundRect"			, 0xA8B3,
	"FillRoundRect"				, 0xA8B4,
	"StdOval"					, 0xA8B6,
	"FrameOval"					, 0xA8B7,
	"PaintOval"					, 0xA8B8,
	"EraseOval"					, 0xA8B9,
	"InvertOval"				, 0xA8BA,
	"FillOval"					, 0xA8BB,
	"SlopeFromAngle"			, 0xA8BC,
	"StdArc"					, 0xA8BD,
	"FrameArc"					, 0xA8BE,
	"PaintArc"					, 0xA8BF,
	"EraseArc"					, 0xA8C0,
	"InvertArc"					, 0xA8C1,
	"FillArc"					, 0xA8C2,
	"PtToAngle"					, 0xA8C3,
	"AngleFromSlope"			, 0xA8C4,
	"StdPoly"					, 0xA8C5,
	"FramePoly"					, 0xA8C6,
	"PaintPoly"					, 0xA8C7,
	"ErasePoly"					, 0xA8C8,
	"InvertPoly"				, 0xA8C9,
	"FillPoly"					, 0xA8CA,
	"OpenPoly"					, 0xA8CB,
	"ClosePgon"					, 0xA8CC,
	"ClosePoly"					, 0xA8CC,
	"KillPoly"					, 0xA8CD,
	"OffsetPoly"				, 0xA8CE,
	"PackBits"					, 0xA8CF,
	"UnpackBits"				, 0xA8D0,
	"StdRgn"					, 0xA8D1,
	"FrameRgn"					, 0xA8D2,
	"PaintRgn"					, 0xA8D3,
	"EraseRgn"					, 0xA8D4,
	"InverRgn"					, 0xA8D5,
	"FillRgn"					, 0xA8D6,
	"BitMapRgn"					, 0xA8D7,
	"BitMapToRegion"			, 0xA8D7,
	"NewRgn"					, 0xA8D8,
	"DisposRgn"					, 0xA8D9,
	"DisposeRgn"				, 0xA8D9,
	"OpenRgn"					, 0xA8DA,
	"CloseRgn"					, 0xA8DB,
	"CopyRgn"					, 0xA8DC,
	"SetEmptyRgn"				, 0xA8DD,
	"SetRecRgn"					, 0xA8DE,
	"RectRgn"					, 0xA8DF,
	"OffsetRgn"					, 0xA8E0,
	"InsetRgn"					, 0xA8E1,
	"EmptyRgn"					, 0xA8E2,
	"EqualRgn"					, 0xA8E3,
	"SectRgn"					, 0xA8E4,
	"UnionRgn"					, 0xA8E5,
	"DiffRgn"					, 0xA8E6,
	"XOrRgn"					, 0xA8E7,
	"PtInRgn"					, 0xA8E8,
	"RectInRgn"					, 0xA8E9,
	"SetStdProcs"				, 0xA8EA,
	"StdBits"					, 0xA8EB,
	"CopyBits"					, 0xA8EC,
	"StdTxMeas"					, 0xA8ED,
	"StdGetPic"					, 0xA8EE,
	"ScrollRect"				, 0xA8EF,
	"StdPutPic"					, 0xA8F0,
	"StdComment"				, 0xA8F1,
	"PicComment"				, 0xA8F2,
	"OpenPicture"				, 0xA8F3,
	"ClosePicture"				, 0xA8F4,
	"KillPicture"				, 0xA8F5,
	"DrawPicture"				, 0xA8F6,
	"Layout"					, 0xA8F7,
	"ScalePt"					, 0xA8F8,
	"MapPt"						, 0xA8F9,
	"MapRect"					, 0xA8FA,
	"MapRgn"					, 0xA8FB,
	"MapPoly"					, 0xA8FC,
	"Count1Resources"			, 0xA80D,
	"Get1IxResource"			, 0xA80E,
	"Get1IxType"				, 0xA80F,
	"Unique1ID"					, 0xA810,
	"TESelView"					, 0xA811,
	"TEPinScroll"				, 0xA812,
	"TEAutoView"				, 0xA813,
	"Pack8"						, 0xA816,
	"FixATan2"					, 0xA818,
	"XMunger"					, 0xA819,
	"HOpenResFile"				, 0xA81A,
	"HCreateResFile"			, 0xA81B,
	"Count1Types"				, 0xA81C,
	"Get1Resource"				, 0xA81F,
	"Get1NamedResource"			, 0xA820,
	"ResourceDispatch"			, 0xA822,
	"MaxSizeRsrc"				, 0xA821,
	"InsMenuItem"				, 0xA826,
	"InsertMenuItem"			, 0xA826,
	"HideDItem"					, 0xA827,
	"HideDialogItem"			, 0xA827,
	"ShowDItem"					, 0xA828,
	"ShowDialogItem"			, 0xA828,
	"Pack9"						, 0xA82B,
	"Pack10"					, 0xA82C,
	"Pack11"					, 0xA82D,
	"Pack12"					, 0xA82E,
	"Pack13"					, 0xA82F,
	"Pack14"					, 0xA830,
	"Pack15"					, 0xA831,
	"ScrnBitMap"				, 0xA833,
	"SetFScaleDisable"			, 0xA834,
	"FontMetrics"				, 0xA835,
	"ZoomWindow"				, 0xA83A,
	"TrackBox"					, 0xA83B,
	"PrGlue"					, 0xA8FD,
	"InitFonts"					, 0xA8FE,
	"GetFName"					, 0xA8FF,
	"GetFNum"					, 0xA900,
	"FMSwapFont"				, 0xA901,
	"RealFont"					, 0xA902,
	"SetFontLock"				, 0xA903,
	"DrawGrowIcon"				, 0xA904,
	"DragGrayRgn"				, 0xA905,
	"NewString"					, 0xA906,
	"SetString"					, 0xA907,
	"ShowHide"					, 0xA908,
	"CalcVis"					, 0xA909,
	"CalcVBehind"				, 0xA90A,
	"ClipAbove"					, 0xA90B,
	"PaintOne"					, 0xA90C,
	"PaintBehind"				, 0xA90D,
	"SaveOld"					, 0xA90E,
	"DrawNew"					, 0xA90F,
	"GetWMgrPort"				, 0xA910,
	"CheckUpDate"				, 0xA911,
	"InitWindows"				, 0xA912,
	"NewWindow"					, 0xA913,
	"DisposWindow"				, 0xA914,
	"DisposeWindow"				, 0xA914,
	"ShowWindow"				, 0xA915,
	"HideWindow"				, 0xA916,
	"GetWRefCon"				, 0xA917,
	"SetWRefCon"				, 0xA918,
	"GetWTitle"					, 0xA919,
	"SetWTitle"					, 0xA91A,
	"MoveWindow"				, 0xA91B,
	"HiliteWindow"				, 0xA91C,
	"SizeWindow"				, 0xA91D,
	"TrackGoAway"				, 0xA91E,
	"SelectWindow"				, 0xA91F,
	"BringToFront"				, 0xA920,
	"SendBehind"				, 0xA921,
	"BeginUpDate"				, 0xA922,
	"EndUpDate"					, 0xA923,
	"FrontWindow"				, 0xA924,
	"DragWindow"				, 0xA925,
	"DragTheRgn"				, 0xA926,
	"InvalRgn"					, 0xA927,
	"InvalRect"					, 0xA928,
	"ValidRgn"					, 0xA929,
	"ValidRect"					, 0xA92A,
	"GrowWindow"				, 0xA92B,
	"FindWindow"				, 0xA92C,
	"CloseWindow"				, 0xA92D,
	"SetWindowPic"				, 0xA92E,
	"GetWindowPic"				, 0xA92F,
	"InitMenus"					, 0xA930,
	"NewMenu"					, 0xA931,
	"DisposMenu"				, 0xA932,
	"DisposeMenu"				, 0xA932,
	"AppendMenu"				, 0xA933,
	"ClearMenuBar"				, 0xA934,
	"InsertMenu"				, 0xA935,
	"DeleteMenu"				, 0xA936,
	"DrawMenuBar"				, 0xA937,
	"InvalMenuBar"				, 0xA81D,
	"HiliteMenu"				, 0xA938,
	"EnableItem"				, 0xA939,
	"DisableItem"				, 0xA93A,
	"GetMenuBar"				, 0xA93B,
	"SetMenuBar"				, 0xA93C,
	"MenuSelect"				, 0xA93D,
	"MenuKey"					, 0xA93E,
	"GetItmIcon"				, 0xA93F,
	"SetItmIcon"				, 0xA940,
	"GetItmStyle"				, 0xA941,
	"SetItmStyle"				, 0xA942,
	"GetItmMark"				, 0xA943,
	"SetItmMark"				, 0xA944,
	"CheckItem"					, 0xA945,
	"GetItem"					, 0xA946,
	"GetMenuItemText"			, 0xA946,
	"SetItem"					, 0xA947,
	"SetMenuItemText"			, 0xA947,
	"CalcMenuSize"				, 0xA948,
	"GetMHandle"				, 0xA949,
	"GetMenuHandle"				, 0xA949,
	"SetMFlash"					, 0xA94A,
	"PlotIcon"					, 0xA94B,
	"FlashMenuBar"				, 0xA94C,
	"AddResMenu"				, 0xA94D,
	"AppendResMenu"				, 0xA94D,
	"PinRect"					, 0xA94E,
	"DeltaPoint"				, 0xA94F,
	"CountMItems"				, 0xA950,
	"InsertResMenu"				, 0xA951,
	"DelMenuItem"				, 0xA952,
	"DeleteMenuItem"			, 0xA952,
	"UpdtControl"				, 0xA953,
	"NewControl"				, 0xA954,
	"DisposControl"				, 0xA955,
	"DisposeControl"			, 0xA955,
	"KillControls"				, 0xA956,
	"ShowControl"				, 0xA957,
	"HideControl"				, 0xA958,
	"MoveControl"				, 0xA959,
	"GetCRefCon"				, 0xA95A,
	"GetControlReference"		, 0xA95A,
	"SetCRefCon"				, 0xA95B,
	"SetControlReference"		, 0xA95B,
	"SizeControl"				, 0xA95C,
	"HiliteControl"				, 0xA95D,
	"GetCTitle"					, 0xA95E,
	"GetControlTitle"			, 0xA95E,
	"SetCTitle"					, 0xA95F,
	"SetControlTitle"			, 0xA95F,
	"GetCtlValue"				, 0xA960,
	"GetControlValue"			, 0xA960,
	"GetMinCtl"					, 0xA961,
	"GetControlMinimum"			, 0xA961,
	"GetMaxCtl"					, 0xA962,
	"GetControlMaximum"			, 0xA962,
	"SetCtlValue"				, 0xA963,
	"SetControlValue"			, 0xA963,
	"SetMinCtl"					, 0xA964,
	"SetControlMinimum"			, 0xA964,
	"SetMaxCtl"					, 0xA965,
	"SetControlMaximum"			, 0xA965,
	"TestControl"				, 0xA966,
	"DragControl"				, 0xA967,
	"TrackControl"				, 0xA968,
	"DrawControls"				, 0xA969,
	"GetCtlAction"				, 0xA96A,
	"GetControlAction"			, 0xA96A,
	"SetCtlAction"				, 0xA96B,
	"SetControlAction"			, 0xA96B,
	"FindControl"				, 0xA96C,
	"Draw1Control"				, 0xA96D,
	"Dequeue"					, 0xA96E,
	"Enqueue"					, 0xA96F,
	"WaitNextEvent"				, 0xA860,
	"GetNextEvent"				, 0xA970,
	"EventAvail"				, 0xA971,
	"GetMouse"					, 0xA972,
	"StillDown"					, 0xA973,
	"Button"					, 0xA974,
	"TickCount"					, 0xA975,
	"GetKeys"					, 0xA976,
	"WaitMouseUp"				, 0xA977,
	"UpdtDialog"				, 0xA978,
	"InitDialogs"				, 0xA97B,
	"GetNewDialog"				, 0xA97C,
	"NewDialog"					, 0xA97D,
	"SelIText"					, 0xA97E,
	"SelectDialogItemText"		, 0xA97E,
	"IsDialogEvent"				, 0xA97F,
	"DialogSelect"				, 0xA980,
	"DrawDialog"				, 0xA981,
	"CloseDialog"				, 0xA982,
	"DisposDialog"				, 0xA983,
	"DisposeDialog"				, 0xA983,
	"FindDItem"					, 0xA984,
	"FindDialogItem"			, 0xA984,
	"Alert"						, 0xA985,
	"StopAlert"					, 0xA986,
	"NoteAlert"					, 0xA987,
	"CautionAlert"				, 0xA988,
	"ParamText"					, 0xA98B,
	"ErrorSound"				, 0xA98C,
	"GetDItem"					, 0xA98D,
	"GetDialogItem"				, 0xA98D,
	"SetDItem"					, 0xA98E,
	"SetDialogItem"				, 0xA98E,
	"SetIText"					, 0xA98F,
	"SetDialogItemText"			, 0xA98F,
	"GetIText"					, 0xA990,
	"GetDialogItemText"			, 0xA990,
	"ModalDialog"				, 0xA991,
	"DetachResource"			, 0xA992,
	"SetResPurge"				, 0xA993,
	"CurResFile"				, 0xA994,
	"InitResources"				, 0xA995,
	"RsrcZoneInit"				, 0xA996,
	"OpenResFile"				, 0xA997,
	"UseResFile"				, 0xA998,
	"UpdateResFile"				, 0xA999,
	"CloseResFile"				, 0xA99A,
	"SetResLoad"				, 0xA99B,
	"CountResources"			, 0xA99C,
	"GetIndResource"			, 0xA99D,
	"CountTypes"				, 0xA99E,
	"GetIndType"				, 0xA99F,
	"GetResource"				, 0xA9A0,
	"GetNamedResource"			, 0xA9A1,
	"LoadResource"				, 0xA9A2,
	"ReleaseResource"			, 0xA9A3,
	"HomeResFile"				, 0xA9A4,
	"SizeRsrc"					, 0xA9A5,
	"GetResAttrs"				, 0xA9A6,
	"SetResAttrs"				, 0xA9A7,
	"GetResInfo"				, 0xA9A8,
	"SetResInfo"				, 0xA9A9,
	"ChangedResource"			, 0xA9AA,
	"AddResource"				, 0xA9AB,
	"AddReference"				, 0xA9AC,
	"RmveResource"				, 0xA9AD,
	"RmveReference"				, 0xA9AE,
	"ResError"					, 0xA9AF,
	"WriteResource"				, 0xA9B0,
	"CreateResFile"				, 0xA9B1,
	"SystemEvent"				, 0xA9B2,
	"SystemClick"				, 0xA9B3,
	"SystemTask"				, 0xA9B4,
	"SystemMenu"				, 0xA9B5,
	"OpenDeskAcc"				, 0xA9B6,
	"CloseDeskAcc"				, 0xA9B7,
	"GetPattern"				, 0xA9B8,
	"GetCursor"					, 0xA9B9,
	"GetString"					, 0xA9BA,
	"GetIcon"					, 0xA9BB,
	"GetPicture"				, 0xA9BC,
	"GetNewWindow"				, 0xA9BD,
	"GetNewControl"				, 0xA9BE,
	"GetRMenu"					, 0xA9BF,
	"GetNewMBar"				, 0xA9C0,
	"UniqueID"					, 0xA9C1,
	"SysEdit"					, 0xA9C2,
	"OpenRFPerm"				, 0xA9C4,
	"RsrcMapEntry"				, 0xA9C5,
	"Secs2Date"					, 0xA9C6,
	"SecondsToDate"				, 0xA9C6,
	"Date2Secs"					, 0xA9C7,
	"DateToSeconds"				, 0xA9C7,
	"SysBeep"					, 0xA9C8,
	"SysError"					, 0xA9C9,
	"PutIcon"					, 0xA9CA,
	"Munger"					, 0xA9E0,
	"HandToHand"				, 0xA9E1,
	"PtrToXHand"				, 0xA9E2,
	"PtrToHand"					, 0xA9E3,
	"HandAndHand"				, 0xA9E4,
	"InitPack"					, 0xA9E5,
	"InitAllPacks"				, 0xA9E6,
	"Pack0"						, 0xA9E7,
	"Pack1"						, 0xA9E8,
	"Pack2"						, 0xA9E9,
	"Pack3"						, 0xA9EA,
	"FP68K"						, 0xA9EB,
	"Pack4"						, 0xA9EB,
	"Elems68K"					, 0xA9EC,
	"Pack5"						, 0xA9EC,
	"Pack6"						, 0xA9ED,
	"DECSTR68K"					, 0xA9EE,
	"Pack7"						, 0xA9EE,
	"PtrAndHand"				, 0xA9EF,
	"LoadSeg"					, 0xA9F0,
	"UnLoadSeg"					, 0xA9F1,
	"Launch"					, 0xA9F2,
	"Chain"						, 0xA9F3,
	"ExitToShell"				, 0xA9F4,
	"GetAppParms"				, 0xA9F5,
	"GetResFileAttrs"			, 0xA9F6,
	"SetResFileAttrs"			, 0xA9F7,
	"MethodDispatch"			, 0xA9F8,
	"InfoScrap"					, 0xA9F9,
	"UnlodeScrap"				, 0xA9FA,
	"UnloadScrap"				, 0xA9FA,
	"LodeScrap"					, 0xA9FB,
	"LoadScrap"					, 0xA9FB,
	"ZeroScrap"					, 0xA9FC,
	"GetScrap"					, 0xA9FD,
	"PutScrap"					, 0xA9FE,
	"Debugger"					, 0xA9FF,
	"DisplayDispatch"			, 0xABEB,
	"IconDispatch"				, 0xABC9,
	"ThreadDispatch"			, 0xABF2,
	"DictionaryDispatch"		, 0xAA53,
	"DebugStr"					, 0xABFF,
	"PPC"						, 0xA0DD,
	"AliasDispatch"				, 0xA823,
	"Open"						, 0xA000,
	"Close"						, 0xA001,
	"Read"						, 0xA002,
	"Write"						, 0xA003,
	"Control"					, 0xA004,
	"Status"					, 0xA005,
	"KillIO"					, 0xA006,
	"GetVolInfo"				, 0xA007,
	"Create"					, 0xA008,
	"Delete"					, 0xA009,
	"OpenRF"					, 0xA00A,
	"Rename"					, 0xA00B,
	"GetFileInfo"				, 0xA00C,
	"SetFileInfo"				, 0xA00D,
	"UnmountVol"				, 0xA00E,
	"HUnmountVol"				, 0xA20E,
	"MountVol"					, 0xA00F,
	"Allocate"					, 0xA010,
	"GetEOF"					, 0xA011,
	"SetEOF"					, 0xA012,
	"FlushVol"					, 0xA013,
	"GetVol"					, 0xA014,
	"SetVol"					, 0xA015,
	"FInitQueue"				, 0xA016,
	"Eject"						, 0xA017,
	"GetFPos"					, 0xA018,
	"SetFilLock"				, 0xA041,
	"RstFilLock"				, 0xA042,
	"SetFilType"				, 0xA043,
	"SetFPos"					, 0xA044,
	"FlushFile"					, 0xA045,
	"HOpen"						, 0xA200,
	"HGetVInfo"					, 0xA207,
	"HCreate"					, 0xA208,
	"HDelete"					, 0xA209,
	"HOpenRF"					, 0xA20A,
	"HRename"					, 0xA20B,
	"HGetFileInfo"				, 0xA20C,
	"HSetFileInfo"				, 0xA20D,
	"AllocContig"				, 0xA210,
	"HSetVol"					, 0xA215,
	"HGetVol"					, 0xA214,
	"HSetFLock"					, 0xA241,
	"HRstFLock"					, 0xA242,
	"FSDispatch"				, 0xA060,
	"HFSDispatch"				, 0xA260,
	"HighLevelFSDispatch"		, 0xAA52,
	"InitZone"					, 0xA019,
	"GetZone"					, 0xA11A,
	"SetZone"					, 0xA01B,
	"FreeMem"					, 0xA01C,
	"MaxMem"					, 0xA11D,
	"NewPtr"					, 0xA11E,
	"NewPtrSys"					, 0xA51E,
	"NewPtrClear"				, 0xA31E,
	"NewPtrSysClear"			, 0xA71E,
	"DisposPtr"					, 0xA01F,
	"DisposePtr"				, 0xA01F,
	"SetPtrSize"				, 0xA020,
	"GetPtrSize"				, 0xA021,
	"NewHandle"					, 0xA122,
	"NewHandleClear"			, 0xA322,
	"NewHandleSys"				, 0xA522,
	"NewHandleSysClear"			, 0xA722,
	"DisposHandle"				, 0xA023,
	"DisposeHandle"				, 0xA023,
	"SetHandleSize"				, 0xA024,
	"GetHandleSize"				, 0xA025,
	"HandleZone"				, 0xA126,
	"ReallocHandle"				, 0xA027,
	"RecoverHandle"				, 0xA128,
	"HLock"						, 0xA029,
	"HUnlock"					, 0xA02A,
	"EmptyHandle"				, 0xA02B,
	"InitApplZone"				, 0xA02C,
	"SetApplLimit"				, 0xA02D,
	"BlockMove"					, 0xA02E,
	"BlockMoveData"				, 0xA22E,
	"MemoryDispatch"			, 0xA05C,
	"MemoryDispatchA0Result"	, 0xA15C,
	"DeferUserFn"				, 0xA08F,
	"DebugUtil"					, 0xA08D,
	"HeapDispatch"				, 0xA0A4,
	"PostEvent"					, 0xA02F,
	"PPostEvent"				, 0xA12F,
	"OSEventAvail"				, 0xA030,
	"GetOSEvent"				, 0xA031,
	"FlushEvents"				, 0xA032,
	"VInstall"					, 0xA033,
	"VRemove"					, 0xA034,
	"OffLine"					, 0xA035,
	"MoreMasters"				, 0xA036,
	"WriteParam"				, 0xA038,
	"ReadDateTime"				, 0xA039,
	"SetDateTime"				, 0xA03A,
	"Delay"						, 0xA03B,
	"CmpString"					, 0xA03C,
	"DrvrInstall"				, 0xA03D,
	"DrvrInstall"				, 0xA13D,
	"DrvrInstallRsrvMem"		, 0xA43D,
	"DrvrInstallRsrvMem"		, 0xA53D,
	"DrvrRemove"				, 0xA03E,
	"InitUtil"					, 0xA03F,
	"ResrvMem"					, 0xA040,
	"GetTrapAddress"			, 0xA146,
	"SetTrapAddress"			, 0xA047,
	"GetOSTrapAddress"			, 0xA346,
	"SetOSTrapAddress"			, 0xA247,
	"GetToolTrapAddress"		, 0xA746,
	"SetToolTrapAddress"		, 0xA647,
	"GetToolBoxTrapAddress"		, 0xA746,
	"SetToolBoxTrapAddress"		, 0xA647,
	"PtrZone"					, 0xA148,
	"HPurge"					, 0xA049,
	"HNoPurge"					, 0xA04A,
	"SetGrowZone"				, 0xA04B,
	"CompactMem"				, 0xA04C,
	"PurgeMem"					, 0xA04D,
	"AddDrive"					, 0xA04E,
	"RDrvrInstall"				, 0xA04F,
	"LwrString"					, 0xA056,
	"UprString"					, 0xA054,
	"SetApplBase"				, 0xA057,
	"HWPriv"					, 0xA198,
	"LowerText"					, 0xA056,
	"StripText"					, 0xA256,
	"UpperText"					, 0xA456,
	"StripUpperText"			, 0xA656,
	"OSDispatch"				, 0xA88F,
	"RelString"					, 0xA050,
	"CompareString"				, 0xA050,
	"ReadXPRam"					, 0xA051,
	"WriteXPRam"				, 0xA052,
	"InsTime"					, 0xA058,
	"InsXTime"					, 0xA458,
	"RmvTime"					, 0xA059,
	"PrimeTime"					, 0xA05A,
	"Microseconds"				, 0xA193,
	"PowerOff"					, 0xA05B,
	"MaxBlock"					, 0xA061,
	"PurgeSpace"				, 0xA162,
	"PurgeSpaceSys"				, 0xA562,
	"MaxApplZone"				, 0xA063,
	"MoveHHi"					, 0xA064,
	"StackSpace"				, 0xA065,
	"NewEmptyHandle"			, 0xA166,
	"HSetRBit"					, 0xA067,
	"HClrRBit"					, 0xA068,
	"HGetState"					, 0xA069,
	"HSetState"					, 0xA06A,
	"InitFS"					, 0xA06C,
	"InitEvents"				, 0xA06D,
	"StripAddress"				, 0xA055,
	"Translate24To32"			, 0xA091,
	"SetAppBase"				, 0xA057,
	"SwapMMUMode"				, 0xA05D,
	"SlotVInstall"				, 0xA06F,
	"SlotVRemove"				, 0xA070,
	"AttachVBL"					, 0xA071,
	"DoVBLTask"					, 0xA072,
	"SIntInstall"				, 0xA075,
	"SIntRemove"				, 0xA076,
	"CountADBs"					, 0xA077,
	"GetIndADB"					, 0xA078,
	"GetADBInfo"				, 0xA079,
	"SetADBInfo"				, 0xA07A,
	"ADBReInit"					, 0xA07B,
	"ADBOp"						, 0xA07C,
	"VADBProc"					, 0xA0AE,
	"GetDefaultStartup"			, 0xA07D,
	"SetDefaultStartup"			, 0xA07E,
	"InternalWait"				, 0xA07F,
	"RGetResource"				, 0xA80C,
	"GetVideoDefault"			, 0xA080,
	"SetVideoDefault"			, 0xA081,
	"DTInstall"					, 0xA082,
	"SetOSDefault"				, 0xA083,
	"GetOSDefault"				, 0xA084,
	"IOPInfoAccess"				, 0xA086,
	"IOPMsgRequest"				, 0xA087,
	"IOPMoveData"				, 0xA088,
	"PowerDispatch"				, 0xA09F,
	"PMgrOp"					, 0xA085,
	"IdleUpdate"				, 0xA285,
	"IdleState"					, 0xA485,
	"SerialPower"				, 0xA685,
	"Sleep"						, 0xA08A,
	"SleepQInstall"				, 0xA28A,
	"SlpQInstall"				, 0xA28A,
	"SleepQRemove"				, 0xA48A,
	"SlpQRemove"				, 0xA48A,
	"CommToolboxDispatch"		, 0xA08B,
	"SysEnvirons"				, 0xA090,
	"Gestalt"					, 0xA1AD,
	"NewGestalt"				, 0xA3AD,
	"ReplaceGestalt"			, 0xA5AD,
	"GetGestaltProcPtr"			, 0xA7AD,
	"InitProcMenu"				, 0xA808,
	"GetItemCmd"				, 0xA84E,
	"SetItemCmd"				, 0xA84F,
	"PopUpMenuSelect"			, 0xA80B,
	"KeyTrans"					, 0xA9C3,
	"KeyTranslate"				, 0xA9C3,
	"TEGetText"					, 0xA9CB,
	"TEInit"					, 0xA9CC,
	"TEDispose"					, 0xA9CD,
	"TextBox"					, 0xA9CE,
	"TETextBox"					, 0xA9CE,
	"TESetText"					, 0xA9CF,
	"TECalText"					, 0xA9D0,
	"TESetSelect"				, 0xA9D1,
	"TENew"						, 0xA9D2,
	"TEUpdate"					, 0xA9D3,
	"TEClick"					, 0xA9D4,
	"TECopy"					, 0xA9D5,
	"TECut"						, 0xA9D6,
	"TEDelete"					, 0xA9D7,
	"TEActivate"				, 0xA9D8,
	"TEDeactivate"				, 0xA9D9,
	"TEIdle"					, 0xA9DA,
	"TEPaste"					, 0xA9DB,
	"TEKey"						, 0xA9DC,
	"TEScroll"					, 0xA9DD,
	"TEInsert"					, 0xA9DE,
	"TESetJust"					, 0xA9DF,
	"TESetAlignment"			, 0xA9DF,
	"TEGetOffset"				, 0xA83C,
	"TEDispatch"				, 0xA83D,
	"TEStyleNew"				, 0xA83E,
	"TEFindWord"				, 0xA0FE,
	"TEFindLine"				, 0xA0FF,
	"OpenCPort"					, 0xAA00,
	"InitCPort"					, 0xAA01,
	"CloseCPort"				, 0xAA02,
	"NewPixMap"					, 0xAA03,
	"DisposPixMap"				, 0xAA04,
	"DisposePixMap"				, 0xAA04,
	"CopyPixMap"				, 0xAA05,
	"SetPortPix"				, 0xAA06,
	"NewPixPat"					, 0xAA07,
	"DisposPixPat"				, 0xAA08,
	"DisposePixPat"				, 0xAA08,
	"CopyPixPat"				, 0xAA09,
	"PenPixPat"					, 0xAA0A,
	"BackPixPat"				, 0xAA0B,
	"GetPixPat"					, 0xAA0C,
	"MakeRGBPat"				, 0xAA0D,
	"FillCRect"					, 0xAA0E,
	"FillCOval"					, 0xAA0F,
	"FillCRoundRect"			, 0xAA10,
	"FillCArc"					, 0xAA11,
	"FillCRgn"					, 0xAA12,
	"FillCPoly"					, 0xAA13,
	"RGBForeColor"				, 0xAA14,
	"RGBBackColor"				, 0xAA15,
	"SetCPixel"					, 0xAA16,
	"GetCPixel"					, 0xAA17,
	"GetCTable"					, 0xAA18,
	"GetForeColor"				, 0xAA19,
	"GetBackColor"				, 0xAA1A,
	"GetCCursor"				, 0xAA1B,
	"SetCCursor"				, 0xAA1C,
	"AllocCursor"				, 0xAA1D,
	"GetCIcon"					, 0xAA1E,
	"PlotCIcon"					, 0xAA1F,
	"OpenCPicture"				, 0xAA20,
	"OpColor"					, 0xAA21,
	"HiliteColor"				, 0xAA22,
	"CharExtra"					, 0xAA23,
	"DisposCTable"				, 0xAA24,
	"DisposeCTable"				, 0xAA24,
	"DisposCIcon"				, 0xAA25,
	"DisposeCIcon"				, 0xAA25,
	"DisposCCursor"				, 0xAA26,
	"DisposeCCursor"			, 0xAA26,
	"SeedCFill"					, 0xAA50,
	"CalcCMask"					, 0xAA4F,
	"CopyDeepMask"				, 0xAA51,
	"GetMaxDevice"				, 0xAA27,
	"GetCTSeed"					, 0xAA28,
	"GetDeviceList"				, 0xAA29,
	"GetMainDevice"				, 0xAA2A,
	"GetNextDevice"				, 0xAA2B,
	"TestDeviceAttribute"		, 0xAA2C,
	"SetDeviceAttribute"		, 0xAA2D,
	"InitGDevice"				, 0xAA2E,
	"NewGDevice"				, 0xAA2F,
	"DisposGDevice"				, 0xAA30,
	"DisposeGDevice"			, 0xAA30,
	"SetGDevice"				, 0xAA31,
	"GetGDevice"				, 0xAA32,
	"DeviceLoop"				, 0xABCA,
	"Color2Index"				, 0xAA33,
	"Index2Color"				, 0xAA34,
	"InvertColor"				, 0xAA35,
	"RealColor"					, 0xAA36,
	"GetSubTable"				, 0xAA37,
	"UpdatePixMap"				, 0xAA38,
	"NewCDialog"				, 0xAA4B,
	"NewColorDialog"			, 0xAA4B,
	"MakeITable"				, 0xAA39,
	"AddSearch"					, 0xAA3A,
	"AddComp"					, 0xAA3B,
	"SetClientID"				, 0xAA3C,
	"ProtectEntry"				, 0xAA3D,
	"ReserveEntry"				, 0xAA3E,
	"SetEntries"				, 0xAA3F,
	"QDError"					, 0xAA40,
	"SaveEntries"				, 0xAA49,
	"RestoreEntries"			, 0xAA4A,
	"DelSearch"					, 0xAA4C,
	"DelComp"					, 0xAA4D,
	"SetStdCProcs"				, 0xAA4E,
	"StdOpcodeProc"				, 0xABF8,
	"SetWinColor"				, 0xAA41,
	"GetAuxWin"					, 0xAA42,
	"SetCtlColor"				, 0xAA43,
	"SetControlColor"			, 0xAA43,
	"GetAuxCtl"					, 0xAA44,
	"GetAuxiliaryControlRecord"	, 0xAA44,
	"NewCWindow"				, 0xAA45,
	"GetNewCWindow"				, 0xAA46,
	"SetDeskCPat"				, 0xAA47,
	"GetCWMgrPort"				, 0xAA48,
	"GetCVariant"				, 0xA809,
	"GetControlVariant"			, 0xA809,
	"GetWVariant"				, 0xA80A,
	"DelMCEntries"				, 0xAA60,
	"DeleteMCEntries"			, 0xAA60,
	"GetMCInfo"					, 0xAA61,
	"SetMCInfo"					, 0xAA62,
	"DispMCInfo"				, 0xAA63,
	"DisposeMCInfo"				, 0xAA63,
	"GetMCEntry"				, 0xAA64,
	"SetMCEntries"				, 0xAA65,
	"MenuChoice"				, 0xAA66,
	"DialogDispatch"			, 0xAA68,
	"SetFractEnable"			, 0xA814,
	"FontDispatch"				, 0xA854,
	"InitPalettes"				, 0xAA90,
	"NewPalette"				, 0xAA91,
	"GetNewPalette"				, 0xAA92,
	"DisposePalette"			, 0xAA93,
	"ActivatePalette"			, 0xAA94,
	"SetPalette"				, 0xAA95,
	"NSetPalette"				, 0xAA95,
	"GetPalette"				, 0xAA96,
	"PmForeColor"				, 0xAA97,
	"PmBackColor"				, 0xAA98,
	"AnimateEntry"				, 0xAA99,
	"AnimatePalette"			, 0xAA9A,
	"GetEntryColor"				, 0xAA9B,
	"SetEntryColor"				, 0xAA9C,
	"GetEntryUsage"				, 0xAA9D,
	"SetEntryUsage"				, 0xAA9E,
	"CTab2Palette"				, 0xAA9F,
	"Palette2CTab"				, 0xAAA0,
	"CopyPalette"				, 0xAAA1,
	"PaletteDispatch"			, 0xAAA2,
	"EgretDispatch"				, 0xA092,
	"SoundDispatch"				, 0xA800,
	"SndDisposeChannel"			, 0xA801,
	"SndAddModifier"			, 0xA802,
	"SndDoCommand"				, 0xA803,
	"SndDoImmediate"			, 0xA804,
	"SndPlay"					, 0xA805,
	"SndControl"				, 0xA806,
	"SndNewChannel"				, 0xA807,
	"SlotManager"				, 0xA06E,
	"ScriptUtil"				, 0xA8B5,
	"SCSIAtomic"				, 0xA089,
	"SCSIDispatch"				, 0xA815,
	"Long2Fix"					, 0xA83F,
	"Fix2Long"					, 0xA840,
	"Fix2Frac"					, 0xA841,
	"Frac2Fix"					, 0xA842,
	"Fix2X"						, 0xA843,
	"X2Fix"						, 0xA844,
	"Frac2X"					, 0xA845,
	"X2Frac"					, 0xA846,
	"FracCos"					, 0xA847,
	"FracSin"					, 0xA848,
	"FracSqrt"					, 0xA849,
	"FracMul"					, 0xA84A,
	"FracDiv"					, 0xA84B,
	"FixDiv"					, 0xA84D,
	"NMInstall"					, 0xA05E,
	"NMRemove"					, 0xA05F,
	"QDExtensions"				, 0xAB1D,
	"ComponentDispatch"			, 0xA82A,
	"DockingDispatch"			, 0xAA57,
	"MixedModeDispatch"			, 0xAA59,
	"CodeFragmentDispatch"		, 0xAA5A,
	"TranslationDispatch"		, 0xABFC,
	"TextServicesDispatch"		, 0xAA54,
	"CursorDeviceDispatch"		, 0xAADB,
	"InitDogCow"				, 0xA89F,
	"EnableDogCow"				, 0xA89F,
	"DisableDogCow"				, 0xA89F,
	"Moof"						, 0xA89F,
	"HFSPinaforeDispatch"		, 0xAA52,
	"OCEUtils"					, 0xAA5C,
	"DigitalSignature"			, 0xAA5D,
	"TBDispatch"				, 0xAA5E,
	"CollectionMgr"				, 0xABF6,
	"ControlStripDispatch"		, 0xAAF2,
	"PowerMgrDispatch"			, 0xA09E,
	"ALMDispatch"				, 0xAAA4,
	"LayerDispatch"				, 0xA829,
	"DrvrInstallRsrvMem"		, 0xA43D,
	""							, 0
};
