/* Help strings.

   Copyright (C) 1993-1996 Sebastiano Vigna

    This file is part of ne, the nice editor.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

In other words, you are welcome to use, share and improve this program.
You are forbidden to forbid anyone else to use, share and improve
what you give them.   Help stamp out software-hoarding!  */


const char * const CLEAR_HELP[7] = {
	"Syntax: Clear",
	"Abbreviation: CL",
	"",
	"destroys the contents of the current document and of its undo buffer.",
	"Moreover, the document becomes unnamed. If the current document is",
	"marked as modified, you have to confirm the action."
};

const char * const OPEN_HELP[18] = {
	"Syntax: Open [FILENAME]",
	"Abbreviation: O",
	"",
	"loads the file specified by the FILENAME string into the current",
	"document.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can input the file name",
	"on the command line, the default being the current document name, if",
	"available.",
	"",
	"   If at the time the command is issued the current document is marked",
	"as modified, you have to confirm the action."
};

const char * const OPENNEW_HELP[6] = {
	"Syntax: OpenNew [FILENAME]",
	"Abbreviation: ON",
	"",
	"is the same as Open, but loads the file specified by the FILENAME",
	"string into a new document. See Open."
};

const char * const SAVE_HELP[12] = {
	"Syntax: Save",
	"Abbreviation: S",
	"",
	"saves the current document using its default file name.",
	"",
	"   If the current document is unnamed, the file requester is opened,",
	"and you are prompted to select a file (you can inhibit the file",
	"requester opening by using the NoFileReq command; see NoFileReq).",
	"",
	"   If you escape from the file requester, you can input the file name",
	"on the command line."
};

const char * const SAVEAS_HELP[14] = {
	"Syntax: SaveAs [FILENAME]",
	"Abbreviation: SA",
	"",
	"saves the current document using the specified string as file name.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can enter the file name",
	"on the input line, the default being the current document name, if",
	"available."
};

const char * const QUIT_HELP[6] = {
	"Syntax: Quit",
	"Abbreviation: Q",
	"",
	"closes all documents and exits. If some document is modified, you have",
	"to confirm the action."
};

const char * const EXIT_HELP[6] = {
	"Syntax: Exit",
	"Abbreviation: X",
	"",
	"saves all modified documents, closes them and exits. If some document",
	"cannot be saved, the action is suspended and an error message is issued."
};

const char * const NEWDOC_HELP[8] = {
	"Syntax: NewDoc",
	"Abbreviation: N",
	"",
	"creates a new, empty, unnamed document which becomes the current",
	"document.  The position of the document in the document list is just",
	"after the current document. The preferences of the new document are",
	"obtained by cloning the preferences of the current document."
};

const char * const CLOSEDOC_HELP[8] = {
	"Syntax: CloseDoc",
	"Abbreviation: CD",
	"",
	"closes the current document. The document is removed from ne's list",
	"and, in case it is the only existing document, ne exits. If the",
	"document was modified from the last save, you have to confirm your",
	"choice."
};

const char * const NEXTDOC_HELP[5] = {
	"Syntax: NextDoc",
	"Abbreviation: ND",
	"",
	"sets as current document the next document in the document list."
};

const char * const PREVDOC_HELP[5] = {
	"Syntax: PrevDoc",
	"Abbreviation: PD",
	"",
	"sets as current document the previous document in the document list."
};

const char * const SELECTDOC_HELP[14] = {
	"Syntax: SelectDoc",
	"Abbreviation: SD",
	"",
	"opens a requester containing the names of all the documents in memory.",
	"You can select the document you want to edit.",
	"",
	"   If you escape from the requester, you can enter the document name on",
	"the input line, the default being the current document name, if",
	"available.",
	"",
	"   This command is really useful only if you have a large (say, more",
	"than 10) number of documents loaded. Otherwise, NextDoc and PrevDoc",
	"should be enough. See NextDoc, and PrevDoc."
};

const char * const MARK_HELP[14] = {
	"Syntax: Mark [0|1]",
	"Abbreviation: M",
	"",
	"sets the mark at the current position or cancels the previous mark.",
	"The mark can then be used in order to perform clip operations. The clip",
	"commands act on the characters laying between the mark and the cursor.",
	"",
	"   If you call this command with no arguments, it will toggle the mark.",
	"If you specify 0 or 1, the mark will be canceled or set to the current",
	"position, respectively.  A capital M appears on the status bar, if",
	"the mark is active.",
	"",
	"   See Record, for the reason why the mark is implemented as a flag."
};

const char * const MARKVERT_HELP[10] = {
	"Syntax: MarkVert [0|1]",
	"Abbreviation: MV",
	"",
	"is the same as Mark, but the mark is interpreted as vertical by the",
	"clip handling commands. This means that the region manipulated by the",
	"cut/paste commands is the rectangle having as vertices the cursor and",
	"the mark.  Moreover, a capital V, rather than a capital M, will",
	"appear on the status bar. Vertical cut/paste operations are most useful",
	"for handling structured program indentation."
};

const char * const COPY_HELP[10] = {
	"Syntax: Copy [N]",
	"Abbreviation: C",
	"",
	"copies the contents of the characters laying between the cursor and the",
	"mark into the clip specified by the optional numeric argument, the",
	"default clip being the current clip, which can be set with the",
	"ClipNumber command (see ClipNumber). If the current mark was",
	"vertical, the rectangle of characters defined by the cursor and the",
	"mark is copied instead."
};

const char * const CUT_HELP[5] = {
	"Syntax: Cut [N]",
	"Abbreviation: CU",
	"",
	"acts just like Copy, but also deletes the block being copied."
};

const char * const PASTE_HELP[7] = {
	"Syntax: Paste [N]",
	"Abbreviation: P",
	"",
	"pastes the contents of specified clip, the default being current clip,",
	"which can be set with the ClipNumber command (see ClipNumber), at the",
	"cursor position."
};

const char * const PASTEVERT_HELP[7] = {
	"Syntax: PasteVert [N]",
	"Abbreviation: PV",
	"",
	"pastes vertically the contents of the specified clip, the default being",
	"the current clip. Each line of the clip is inserted on consecutive",
	"lines at the horizontal cursor position."
};

const char * const ERASE_HELP[6] = {
	"Syntax: Erase",
	"Abbreviation: E",
	"",
	"acts like Cut, but the block is just deleted, and not copied into any",
	"clip."
};

const char * const OPENCLIP_HELP[14] = {
	"Syntax: OpenClip [FILENAME]",
	"Abbreviation: OC",
	"",
	"loads the given file name as the current clip (just as if you copied",
	"it; see Copy).",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can enter the file name",
	"on the input line."
};

const char * const SAVECLIP_HELP[13] = {
	"Syntax: SaveClip [FILENAME]",
	"Abbreviation: SC",
	"",
	"saves the current clip on the given file name.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can enter the file name",
	"on the input line."
};

const char * const CLIPNUMBER_HELP[11] = {
	"Syntax: ClipNumber [N]",
	"Abbreviation: CN",
	"",
	"sets the current clip number. This number is used by OpenClip and",
	"SaveClip, and by Copy, Cut and Paste if they are called without",
	"any argument. Its default value is zero. N is limited only by the",
	"integer size of the machine ne is running on.",
	"",
	"   If the optional argument N is not specified, you can enter it on the",
	"input line, the default being the current clip number."
};

const char * const THROUGH_HELP[15] = {
	"Syntax: Through [COMMAND]",
	"Abbreviation: T",
	"",
	"asks the shell to execute COMMAND, piping the current block in the",
	"standard input, and replacing it with the output of the command. This",
	"command is most useful with filters, such as sort. Its practical",
	"effect is to pass the block through the specified filter.",
	"",
	"   Note that by selecting an empty block (or equivalently by having the",
	"mark unset) you can use Through in order to insert the output of any",
	"UN*X command in your file.",
	"",
	"   If the optional argument COMMAND is not specified, you can enter it",
	"on the input line."
};

const char * const FIND_HELP[12] = {
	"Syntax: Find [PATTERN]",
	"Abbreviation: F",
	"",
	"searches for the given pattern. The cursor is positioned on the first",
	"occurrence of the pattern, or an error message is given. The direction",
	"and the case sensitivity of the search are established by the value of",
	"the back search and case sensitive search flags. See SearchBack and",
	"CaseSearch.",
	"",
	"   If the optional argument PATTERN is not specified, you can enter it",
	"on the input line, the default being the last pattern used."
};

const char * const FINDREGEXP_HELP[12] = {
	"Syntax: FindRegExp [PATTERN]",
	"Abbreviation: FX",
	"",
	"searches the buffer for the given extended regular expression (see",
	"Regular Expressions) . The cursor is positioned on the first string",
	"matching the expression. The direction and the kind of search are",
	"established by the value of the back search and case sensitive search",
	"flags. See SearchBack and CaseSearch.",
	"",
	"   If the optional argument PATTERN is not specified, you can enter it",
	"on the input line, the default being the last pattern used."
};

const char * const REPLACE_HELP[46] = {
	"Syntax: Replace [STRING]",
	"Abbreviation: R",
	"",
	"moves on the first match of the most recent find string or regular",
	"expression, and then asks you which action to perform. You can choose",
	"among:",
	"",
	"   * replacing the string found with the given string and moving to the",
	"     next match (Yes);",
	"",
	"   * moving to the next match (No);",
	"",
	"   * replacing the string found with the given string, and stop the",
	"     search (Last);",
	"",
	"   * stopping immediately the search (Quit);",
	"",
	"   * replacing *all* occurrences of the find string with the given",
	"     string (All);",
	"",
	"   * reverting the search direction (Backward or Forward); this",
	"     choice will also modify the value of the back search flag.  See",
	"     SearchBack.",
	"",
	"   This command is mainly useful for interactive editing. ReplaceOnce,",
	"ReplaceAll and RepeatLast are more suited to macros.",
	"",
	"   If no find string was ever specified, you can enter it on the input",
	"line.  If the optional argument STRING is not specified, you can enter",
	"it on the input line, the default being the last string used. When the",
	"last search was a regular expression search (see FindRegExp), there are",
	"some special features you can use in the replace string (see Regular",
	"Expressions) .",
	"",
	"   Note that normally a search starts just one character after the",
	"cursor.  However, when Replace is invoked, the search starts at the",
	"character just *under* the cursor, so that you can safely Find a",
	"pattern and Replace it without having to move back.",
	"",
	"*Warning:* when recording a macro (see Record), there is no trace in",
	"the macro of your interaction with ne during the replacement process.",
	"When the macro is played, you will have again to choose which actions",
	"to perform. If you want to apply automatic replacement of strings for a",
	"certain number of times, you should look at ReplaceOnce, ReplaceAll and",
	"RepeatLast."
};

const char * const REPLACEONCE_HELP[10] = {
	"Syntax: ReplaceOnce [STRING]",
	"Abbreviation: R1",
	"",
	"acts just like Replace, but without any interaction with you (unless",
	"there is no find string). The first string matched by the last search",
	"pattern, if existing, is replaced by the given replacement string.",
	"",
	"   If the optional argument STRING is not specified, you can enter it on",
	"the input line, the default being the last string used."
};

const char * const REPLACEALL_HELP[12] = {
	"Syntax: ReplaceAll [STRING]",
	"Abbreviation: RA",
	"",
	"is similar to  ReplaceOnce, but replaces *all* occurrences of the",
	"last search pattern with the given replacement string.",
	"",
	"   If the optional argument STRING is not specified, you can enter it on",
	"the input line, the default being the last string used.",
	"",
	"   Note that Undo will restore *all* the occurrences of the search",
	"pattern this command replaced. See Undo."
};

const char * const REPEATLAST_HELP[26] = {
	"Syntax: RepeatLast [TIMES]",
	"Abbreviation: RL",
	"",
	"repeats for the given number of times the last find or replace operation",
	"(with replace we mean here a single replace, even if the last Replace",
	"operation ended with a global substitution).",
	"",
	"   This command is mainly useful for researching a given number of",
	"times, or replacing something a given number of times. The standard",
	"technique for accomplishing this is:",
	"",
	"  1. Find (or FindRegExp) the string you are interested in;",
	"",
	"  2. if you want to repeat a replace operation, ReplaceOnce with the",
	"     replacement string you are interested in;",
	"",
	"  3. now issue a RepeatLast N-1 command, where N is the number of",
	"     occurrences you wanted to skip over, or replace.",
	"",
	"",
	"   The important thing about this sequence of actions is that it will",
	"work this way even in a macro. The Replace command cannot be used in",
	"a macro unless you really want to interact with ne during the macro",
	"execution. This is the only reason why the commands ReplaceAll and",
	"ReplaceOnce are provided."
};

const char * const MATCHBRACKET_HELP[8] = {
	"Syntax: MatchBracket",
	"Abbreviation: MB",
	"",
	"moves the cursor over the bracket associated to the bracket the cursor",
	"is on. If the cursor is not on a bracket, or there is no bracket",
	"associated to the current one, an error message is issued. {}, (),",
	"[] and <> are recognized."
};

const char * const SEARCHBACK_HELP[14] = {
	"Syntax: SearchBack [0|1]",
	"Abbreviation: SB",
	"",
	"sets the back search flag. When this flag is true, every search or",
	"replacement command is performed backwards.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case b will appear on the status bar if the",
	"flag is true.",
	"",
	"   Note that this flag can be also set by the interaction happening",
	"during a replace. See Replace."
};

const char * const CASESEARCH_HELP[13] = {
	"Syntax: CaseSearch [0|1]",
	"Abbreviation: CS",
	"",
	"sets the case sensitivity flag. When this flag is true, the search",
	"commands distinguish between the upper case and lower case versions of",
	"a letter. By default the flag is false, since this seems to be what",
	"most user want.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case c will appear on the status bar if the",
	"flag is true."
};

const char * const RECORD_HELP[20] = {
	"Syntax: Record [0|1]",
	"Abbreviation: Rec",
	"",
	"sets the recording state flag. When this flag becomes true, a macro",
	"recording is initiated. When it becomes false, the macro recording is",
	"stopped, and the macro can be played (see Play).",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. An upper case R will appear on the status bar if the",
	"flag is true.",
	"",
	"   The reason for providing a flag instead of an explicit start/stop",
	"recording command pair is that this way it is possible to bind to the",
	"same key the start and stop recording command, while still being able",
	"to specifying \"absolute\" menu items (by using Record 0 and Record",
	"1). For instance, the default key binding for Control-T is simply",
	"Record, which means that this shortcut can be used both for",
	"initiating and for terminating a macro recording."
};

const char * const PLAY_HELP[14] = {
	"Syntax: Play [TIMES]",
	"Abbreviation: PL",
	"",
	"plays the current macro for the given number of times. If the optional",
	"argument TIMES is not specified, you can enter it on the input line.",
	"",
	"   A (possibly iterated) macro execution terminates as soon as its",
	"stream of instructions is exhausted, or one of its commands returns an",
	"error. This means that, for instance, you can perform some complex",
	"operation on all the lines contaning a certain pattern by recording a",
	"macro that searches for the pattern and performs the operation, and",
	"then playing it a preposterously huge number of times. Note that the",
	"execution of a macro can be interrupted by Control-\\."
};

const char * const MACRO_HELP[29] = {
	"Syntax: Macro [FILENAME]",
	"Abbreviation: MA",
	"",
	"executes the given file name as a macro.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can input the file name",
	"on the command line.",
	"",
	"   Note that macros whose name does not conflict with a command can be",
	"called without using Macro. Whenever ne is required to perform a",
	"command it cannot find in its internal tables, it will look for a macro",
	"named as the command. If also this search fails, ne looks in",
	"$HOME/.ne for a file named as the command.",
	"",
	"*Warning:* in order to (greatly) improve efficiency, the first time a",
	"macro is executed it is cached into a hash table and is kept *forever*",
	"in memory (unless the UnloadMacros command is issued; see",
	"UnloadMacros). The next time a macro with the same file name is",
	"invoked, the cached list is searched for it before accessing the file",
	"using a case insensitive string comparison. That is, if you call",
	"~/foobar/macro, a subsequent call for /usr/MACRO or just MaCrO",
	"will use the cached version. Note that the cache table is global to",
	"ne."
};

const char * const OPENMACRO_HELP[14] = {
	"Syntax: OpenMacro [FILENAME]",
	"Abbreviation: OM",
	"",
	"loads the given file name as the current macro (just as if you",
	"Recorded it; see Record).",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can input the file name",
	"on the command line."
};

const char * const SAVEMACRO_HELP[17] = {
	"Syntax: SaveMacro [FILENAME]",
	"Abbreviation: SM",
	"",
	"saves the current macro on the given file name.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq).",
	"",
	"   If you escape from the file requester, you can input the file name",
	"on the command line.",
	"",
	"   This command is of course most useful for saving macros you just",
	"recorded. The macros can then be loaded as normal text files for",
	"further editing, if necessary."
};

const char * const UNLOADMACROS_HELP[12] = {
	"Syntax: UnloadMacros",
	"Abbreviation: UM",
	"",
	"frees the macro cache list. After this command, the Macro command",
	"will be forced to search for the file containing the macro it has to",
	"play.",
	"",
	"   This command is really useful only if you are experimenting with a",
	"macro bound to some keystroke, and you are interactively modifying it",
	"and playing it.  UnloadMacros forces ne to look for the newer",
	"version available."
};

const char * const UNDO_HELP[7] = {
	"Syntax: Undo [N]",
	"Abbreviation: U",
	"",
	"undoes the last N actions. If N is not specified, it is assumed to be",
	"one. Once you undo a number of actions, you can Redo them (or part of",
	"them; see Redo)."
};

const char * const REDO_HELP[6] = {
	"Syntax: Redo [N]",
	"Abbreviation: RE",
	"",
	"redoes the last N actions. If N is not specified, it is assumed to be",
	"one. You can only Redo actions which have been Undone.  See Undo."
};

const char * const UNDELLINE_HELP[15] = {
	"Syntax: UndelLine [N]",
	"Abbreviation: UL",
	"",
	"inserts at the cursor position for N times the last non-empty line",
	"which was deleted with the DeleteLine command. If N is not specified,",
	"it is assumed to be one.",
	"",
	"   This command is most useful in that it allows a very fast way of",
	"moving one line around. Just delete it, and undelete it somewhere else.",
	"It is also an easy way to replicate a line without getting involved",
	"with clips.",
	"",
	"   Note that this command works independently of the status of the undo",
	"flag. See DoUndo."
};

const char * const DOUNDO_HELP[20] = {
	"Syntax: DoUndo [0|1]",
	"Abbreviation: DU",
	"",
	"sets the flag which enables or disables the undo system. When you turn",
	"the undo system off, all the recorded actions are discarded, and the",
	"undo buffers are reset.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case u will appear on the status bar if the",
	"flag is true.",
	"",
	"   The usefulness of this option relies in the fact the undo system is",
	"a major memory eater. If you plan to do massive editing (say, cutting",
	"and pasting megabytes of text) it is a good idea to disable the undo",
	"system, both for improving (doubling) performance and for using less",
	"(half) memory. Except for this, on a virtual memory system I see no",
	"reason to not keep the undo flag always true, and this is indeed the",
	"default."
};

const char * const CENTER_HELP[8] = {
	"Syntax: Center [N]",
	"Abbreviation: CE",
	"",
	"centers N lines from the cursor position onwards. If N is not",
	"specified, it is assumed to be one. The lines are centered with spaces,",
	"relatively to the value of the right margin as set by the RightMargin",
	"command. See RightMargin."
};

const char * const PARAGRAPH_HELP[15] = {
	"Syntax: Paragraph [N]",
	"Abbreviation: PA",
	"",
	"reformats N paragraphs from the cursor position onwards. If N is not",
	"specified, it is assumed to be one. The paragraph are formatted",
	"relatively to the value of the right margin as set by the RightMargin",
	"command. See RightMargin.",
	"",
	"   Do not ever ask me to implement justified paragraphing. I *hate*",
	"non-proportional justified text.",
	"",
	"   If you think paragraphing should insert \"smart\" spaces after full",
	"stops and colons, and do other such \"smart\" things, you should consider",
	"using a text formatter. TeX is usually the best choice."
};

const char * const TOUPPER_HELP[15] = {
	"Syntax: ToUpper [N]",
	"Abbreviation: TU",
	"",
	"uppers the case of the letters from the cursor position up to the end",
	"of a word, and moves to the fist letter of next word for N times.",
	"",
	"   The description of the command may seem a little bit cryptic. What",
	"is really happening is that there are situations where you want to",
	"upper case only the last part of a word. In this case, you just have to",
	"position the cursor in the first character you want to upper case, and",
	"use this command with no argument.",
	"",
	"   If you apply ToUpper on the first character of a word, it will",
	"just upper case N words."
};

const char * const TOLOWER_HELP[5] = {
	"Syntax: ToLower [N]",
	"Abbreviation: TL",
	"",
	"acts exactly like ToUpper, but lowers the case. See ToUpper."
};

const char * const CAPITALIZE_HELP[6] = {
	"Syntax: Capitalize [N]",
	"Abbreviation: CA",
	"",
	"acts exactly like ToUpper, but capitalizes, i.e., makes the first",
	"letter upper case and the other ones lower case. See ToUpper."
};

const char * const RIGHTMARGIN_HELP[12] = {
	"Syntax: RightMargin [N]",
	"Abbreviation: RM",
	"",
	"sets the right margin for all formatting operations, and for WordWrap",
	"(see WordWrap).",
	"",
	"   If the optional argument N is not specified, you can enter it on the",
	"input line, the default being the current value of the right margin.",
	"",
	"   A value of 0 for N will force ne to use (what it thinks it is) the",
	"current screen width as right margin."
};

const char * const WORDWRAP_HELP[12] = {
	"Syntax: WordWrap [0|1]",
	"Abbreviation: WW",
	"",
	"sets the word wrap flag. When this flag is true, ne will automatically",
	"break lines of text longer than the current right margin (see",
	"RightMargin) while you type them.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case w will appear on the status bar if the",
	"flag is true."
};

const char * const AUTOINDENT_HELP[21] = {
	"Syntax: AutoIndent [0|1]",
	"Abbreviation: AI",
	"",
	"sets the auto indent flag. When this flag is true, ne will",
	"automatically insert tabs and spaces on a new line (created by an",
	"InsertLine command, or by automatic word wrapping) in such a way to",
	"replicate the initial spaces of the previous line. Most useful for",
	"indenting programs.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case a will appear on the status bar if the",
	"flag is true.",
	"",
	"   AutoIndent features a nice interaction with Undo. Whenever a new",
	"line is created, the insertion of spaces is recorded as a separate",
	"action in the undo buffer (with respect to the line creation). If you",
	"are not satisfied with the indentation, just give the Undo command and",
	"the indentation will disappear (but the new line will remain in place,",
	"since its creation has been recorded as a separate action). See Undo."
};

const char * const AUTOPREFS_HELP[15] = {
	"Syntax: AutoPrefs [0|1]",
	"Abbreviation: AP",
	"",
	"sets the automatic preferences flag. If this flag is true, each time an",
	"Open command is executed and a file is loaded, ne will look for an",
	"automatic preferences file in the $HOME/.ne directory.  The",
	"preferences file name is given by the extension of the file loaded,",
	"postfixed with #ap. Thus, for instance, C sources have an associated",
	"c#ap file.  See Automatic Preferences.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case p will appear on the status bar if the",
	"flag is true."
};

const char * const BINARY_HELP[22] = {
	"Syntax: Binary [0|1]",
	"Abbreviation: B",
	"",
	"sets the binary flag. When this flag is true, loading and saving a",
	"document is performed in a different way. On loading, only nulls are",
	"considered newlines; on saving, nulls are saved instead of newlines.",
	"This allows you to edit a binary file, fix some text in it, and save it",
	"without modifying anything else. Normally, linefeeds, carriage returns",
	"and nulls are considered newlines, so that what you load will have all",
	"nulls and carriage returns substituted by newlines when saved.",
	"",
	"   Note that since usually binary files contain a great number of",
	"nulls, and every null will be considered a line terminator, the memory",
	"necessary for loading a binary file can be several times bigger than",
	"the length of the file. Thus, binary editing within ne should be",
	"considered not a normal, but rather an exceptional activity.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. An upper case B will appear on the status bar if the",
	"flag is true."
};

const char * const INSERT_HELP[12] = {
	"Syntax: Insert [0|1]",
	"Abbreviation: I",
	"",
	"sets the insert flag. If this flag is true, the text you type is",
	"inserted, otherwise it overwrites the existing characters. This is also",
	"true of the InsertChar command.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case i will appear on the status bar if the",
	"flag is true."
};

const char * const FASTGUI_HELP[14] = {
	"Syntax: FastGUI [0|1]",
	"Abbreviation: FG",
	"",
	"sets the fast graphical user interface flag. When this flag is true,",
	"ne tries to print as few as possible while displaying menus and the",
	"status bar. In particular, menu items are highlighted by the cursor",
	"only, and the status bar is not highlighted (which allows to print it",
	"with less characters). This option is very useful if you are using ne",
	"through a slow connection.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively."
};

const char * const FREEFORM_HELP[17] = {
	"Syntax: FreeForm [0|1]",
	"Abbreviation: FF",
	"",
	"sets the free form flag. When this flag is true, you can move with the",
	"cursor anywhere on the screen, even where no text is present (however,",
	"you cannot move inside the space expansion of a TAB character).",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case f will appear on the status bar if the",
	"flag is true.",
	"",
	"   The issue free-form-versus-non-free-form is a major religious war",
	"which is engaging hackers, lusers and programmers from day one. The due",
	"of the implementor is to allow both choices, and to set as default the",
	"correct one (in his humble opinion). In this case, non-free-form."
};

const char * const NOFILEREQ_HELP[10] = {
	"Syntax: NoFileReq [0|1]",
	"Abbreviation: NFR",
	"",
	"sets the file requester flag. When this flag is true, the file",
	"requester is never opened, under any circumstances.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively."
};

const char * const STATUSBAR_HELP[18] = {
	"Syntax: StatusBar [0|1]",
	"Abbreviation: ST",
	"",
	"sets the status bar flag. When this flag is true, the status bar is",
	"displayed at the bottom of the screen. There are only two reasons to",
	"turn off the status bar I am aware of:",
	"",
	"   * if you are using ne through a slow connection, updating the",
	"     line/column indicator can really slow down editing;",
	"",
	"   * scrolling caused by cursor movement on terminals which do not",
	"     allow to set a scrolling region can produce annoying flashes at",
	"     the bottom of the screen.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively."
};

const char * const READONLY_HELP[13] = {
	"Syntax: ReadOnly [0|1]",
	"Abbreviation: RO",
	"",
	"sets the read only flag. When this flag is true, no editing can be",
	"performed on the document (any such attempt produces an error message).",
	"This flag is automatically set whenever you open a file which you",
	"cannot write to.  See Open.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case r will appear on the status bar if the",
	"flag is true."
};

const char * const ESCAPETIME_HELP[14] = {
	"Syntax: EscapeTime [N]",
	"Abbreviation: ET",
	"",
	"sets the escape time. The Escape key is recognized as such after N",
	"tenths of second (see Motivations and Design). Along slow connections,",
	"it can happen that the default value of 10 is too low: in this case,",
	"escape sequences (e.g., those of the arrow keys) could be erroneously",
	"broken into an escape and some spurious characters. Rising the escape",
	"time usually solves this problem. Allowed values range from 0 to 255.",
	"",
	"   Note that the escape time is global to ne, and it is not saved.",
	"However, you can add manually to a preferences file an EscapeTime",
	"command."
};

const char * const TABSIZE_HELP[9] = {
	"Syntax: TabSize [SIZE]",
	"Abbreviation: TS",
	"",
	"sets the number of spaces ne will use when expanding a TAB character.",
	"",
	"   If the optional argument SIZE is not specified, you can enter it on",
	"the input line, the default being the current TAB size. Allowed values",
	"are strictly between 0 and half the width of the screen."
};

const char * const TURBO_HELP[29] = {
	"Syntax: Turbo [STEPS]",
	"Abbreviation: TUR",
	"",
	"sets the turbo parameter. When it is nonzero, iterated actions and",
	"global replaces will update at most STEPS line of the screen; then,",
	"update will be delayed to the end of the action.",
	"",
	"   This feature is most useful when massive operations (such as",
	"replacing thousands of occurrences of a pattern) have to be performed.",
	"After having updated STEPS lines, ne can proceed at maximum speed,",
	"because no visual update has to be performed.",
	"",
	"   The value of the turbo parameter has to be adapted to the kind of",
	"terminal you are using. Very high values (or zero, which completely",
	"disables the delayed update) can be good on high-speed terminals, since",
	"the time required for the visual updates is very small, and it is",
	"always safer to look at what the editor is really doing. On slow",
	"terminals, however, small values ensure that operations such as",
	"paragraph formatting will not take too long.",
	"",
	"   You have to be careful about setting the turbo parameter too low.",
	"ne keeps track internally of the part of the screen which needs",
	"refresh in a very rough way. This means that a value of less than, say,",
	"8 will force it to do a lot of unnecessary refresh.",
	"",
	"   The default value of this parameter is given by twice the number of",
	"lines of the screen, which for several reasons does seem to offer a",
	"good value."
};

const char * const VERBOSEMACROS_HELP[18] = {
	"Syntax: VerboseMacros [0|1]",
	"Abbreviation: VM",
	"",
	"sets the verbose macros flag. When this flag is true, all macros",
	"generated by recording or by automatic preferences saving will contain",
	"full names, instead of short names. This is highly desirable if you are",
	"going to manually editing the macro, but it can slow down considerably",
	"the parsing of the commands.",
	"",
	"   If you call this command with no arguments, it will toggle the flag.",
	"If you specify 0 or 1, the flag will be set to false or true,",
	"respectively. A lower case v will appear on the status bar if the",
	"flag is true.",
	"",
	"   The only reason to use this flag is when recording a macro that will",
	"be played a great number of times. Automatic preferences files are too",
	"short to be an issue with respect to execution timing."
};

const char * const LOADPREFS_HELP[17] = {
	"Syntax: LoadPrefs [FILENAME]",
	"Abbreviation: LP",
	"",
	"loads the given preference file, and sets the current preferences",
	"accordingly.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq). If you escape from the file requester, you can input",
	"the file name on the command line.",
	"",
	"   Note that a preferences file is just a macro containing option",
	"modifiers only. You can manually edit a preferences file for special",
	"purposes, such as filtering out specific settings.  See Hints and",
	"Tricks."
};

const char * const SAVEPREFS_HELP[11] = {
	"Syntax: SavePrefs [FILENAME]",
	"Abbreviation: SP",
	"",
	"saves the current preferences on the given file.",
	"",
	"   If the optional FILENAME argument is not specified, the file",
	"requester is opened, and you are prompted to select a file (you can",
	"inhibit the file requester opening by using the NoFileReq command;",
	"see NoFileReq). If you escape from the file requester, you can input",
	"the file name on the command line."
};

const char * const LOADAUTOPREFS_HELP[7] = {
	"Syntax: LoadAutoPrefs",
	"Abbreviation: LAP",
	"",
	"loads the preferences file in $HOME/.ne relative to the current",
	"document file name. If the current file name has no extension, the",
	"default preferences are loaded. See AutoPrefs."
};

const char * const SAVEAUTOPREFS_HELP[7] = {
	"Syntax: SaveAutoPrefs",
	"Abbreviation: SAP",
	"",
	"saves the current preferences on the file in $HOME/.ne relative to",
	"the current document file name. If the current file name has no",
	"extension, an error message is issued. See AutoPrefs."
};

const char * const SAVEDEFPREFS_HELP[6] = {
	"Syntax: SaveDefPrefs",
	"Abbreviation: SDP",
	"",
	"saves the current preferences on the $HOME/.ne/.default#ap file.",
	"This file is always loaded by ne at startup."
};

const char * const MOVELEFT_HELP[6] = {
	"Syntax: MoveLeft [N]",
	"Abbreviation: ML",
	"",
	"moves the cursor on the left by one character N times. If the optional",
	"N argument is not specified, it is assumed to be one."
};

const char * const MOVERIGHT_HELP[6] = {
	"Syntax: MoveRight [N]",
	"Abbreviation: MR",
	"",
	"moves the cursor on the right by one character N times. If the optional",
	"N argument is not specified, it is assumed to be one."
};

const char * const LINEUP_HELP[6] = {
	"Syntax: LineUp [N]",
	"Abbreviation: LU",
	"",
	"moves the cursor up by one line N times. If the optional N argument is",
	"not specified, it is assumed to be one."
};

const char * const LINEDOWN_HELP[6] = {
	"Syntax: LineDown [N]",
	"Abbreviation: LD",
	"",
	"moves the cursor down by one line N times. If the optional N argument",
	"is not specified, it is assumed to be one."
};

const char * const GOTOLINE_HELP[10] = {
	"Syntax: GotoLine [LINE]",
	"Abbreviation: GL",
	"",
	"moves the cursor on the LINEth line of the file. If LINE is greater",
	"than the number of lines of the file, the cursor is moved on the last",
	"line.",
	"",
	"   If the optional argument LINE is not specified, you can enter it on",
	"the input line, the default input being the current line number."
};

const char * const GOTOCOLUMN_HELP[8] = {
	"Syntax: GotoColumn [COLUMN]",
	"Abbreviation: GC",
	"",
	"moves the cursor on the COLUMNth column of the file.",
	"",
	"   If the optional argument LINE is not specified, you can enter it on",
	"the input line, the default input being the current column number."
};

const char * const GOTOMARK_HELP[9] = {
	"Syntax: GotoMark",
	"Abbreviation: GM",
	"",
	"moves the cursor to the current mark, if existing. See Mark.",
	"",
	"   This command is mainly useful if you forgot where you started",
	"marking.  If you want to record a position in a file and jump on it",
	"later, you may want to use a bookmark. See SetBookmark."
};

const char * const PREVPAGE_HELP[8] = {
	"Syntax: PrevPage [N]",
	"Abbreviation: PP",
	"",
	"moves the cursor N pages backward, if the cursor is on the first line",
	"of the screen; otherwise moves the cursor on the first line of the",
	"screen, and moves by N-1 pages. If the optional N argument is not",
	"specified, it is assumed to be one."
};

const char * const NEXTPAGE_HELP[8] = {
	"Syntax: NextPage [N]",
	"Abbreviation: NP",
	"",
	"moves the cursor N pages forward, if the cursor is on the last line of",
	"the screen; otherwise moves the cursor on the last line of the screen,",
	"and moves by N-1 pages. If the optional N argument is not specified, it",
	"is assumed to be one."
};

const char * const PREVWORD_HELP[8] = {
	"Syntax: PrevWord [N]",
	"Abbreviation: PW",
	"",
	"moves the cursor on the previous word N times. If the optional N",
	"argument is not specified, it is assumed to be one (in which case, if",
	"the cursor is in the middle of a word the effect is just to move it on",
	"the start of that word)."
};

const char * const NEXTWORD_HELP[6] = {
	"Syntax: NextWord [N]",
	"Abbreviation: NW",
	"",
	"moves the cursor on the next word N times. If the optional N argument",
	"is not specified, it is assumed to be one."
};

const char * const MOVEEOL_HELP[5] = {
	"Syntax: MoveEOL",
	"Abbreviation: EOL",
	"",
	"moves the cursor to the end of the current line."
};

const char * const MOVESOL_HELP[5] = {
	"Syntax: MoveSOL",
	"Abbreviation: SOL",
	"",
	"moves the cursor to the start of the current line."
};

const char * const MOVEEOF_HELP[5] = {
	"Syntax: MoveEOF",
	"Abbreviation: EOF",
	"",
	"moves the cursor to the end of the document (EOF = end of file)."
};

const char * const MOVESOF_HELP[5] = {
	"Syntax: MoveSOF",
	"Abbreviation: SOF",
	"",
	"moves the cursor to the start of the document (SOF = start of file)."
};

const char * const MOVEEOW_HELP[8] = {
	"Syntax: MoveEOW",
	"Abbreviation: EOW",
	"",
	"moves the cursor one character after the end of the word it is on.",
	"",
	"   This commands is extremely useful in macros, because it allows to",
	"copy precisely the word the cursor is on.  See Hints and Tricks."
};

const char * const TOGGLESEOF_HELP[10] = {
	"Syntax: ToggleSEOF",
	"Abbreviation: TSEOF",
	"",
	"moves the cursor to the start of document, if it is not already there;",
	"otherwise, moves it to the end of the document.",
	"",
	"   This kind of toggling command (also see ToggleSEOL) is very useful in",
	"order to gain some keystroke on systems with very few keys. See also",
	"MoveSOF, and MoveEOF."
};

const char * const TOGGLESEOL_HELP[10] = {
	"Syntax: ToggleSEOL",
	"Abbreviation: TSEOL",
	"",
	"moves the cursor to the start of the current line, if it is not already",
	"there; otherwise, moves it to the end of the current line.",
	"",
	"   This kind of toggling command (also see ToggleSEOF) is very useful in",
	"order to gain some keystroke on systems with very few keys. See also",
	"MoveSOL, and MoveEOL."
};

const char * const SETBOOKMARK_HELP[7] = {
	"Syntax: SetBookmark [N]",
	"Abbreviation: SBM",
	"",
	"sets the Nth bookmark to the current cursor position. If the optional N",
	"argument is not specified, it is assumed to be zero. There are ten",
	"bookmarks, numbered from 0 to 9."
};

const char * const GOTOBOOKMARK_HELP[7] = {
	"Syntax: GotoBookmark [N]",
	"Abbreviation: GBM",
	"",
	"moves the cursor to the Nth bookmark. If the optional N argument is not",
	"specified, it is assumed to be zero. There are ten bookmarks, numbered",
	"from 0 to 9."
};

const char * const INSERTCHAR_HELP[13] = {
	"Syntax: InsertChar CODE",
	"Abbreviation: IC",
	"",
	"inserts a character whose ASCII code is CODE at the current cursor",
	"position. CODE has always to be different from 0. All the currently",
	"active options (insert, word wrapping, auto indent, et cetera) are",
	"applied.",
	"",
	"   Note that inserting a line feed (10) is completely different from",
	"inserting a line with InsertLine. InsertChar 10 puts the control",
	"char Control-J in the text at the current cursor position.  See",
	"InsertLine."
};

const char * const DELETECHAR_HELP[10] = {
	"Syntax: DeleteChar [N]",
	"Abbreviation: DC",
	"",
	"deletes N characters from the text. If the optional N argument is not",
	"specified, it is assumed to be one. Deleting a character when the",
	"cursor is just after the last char on a line will join a line with the",
	"following one; in other word, the carriage return between the two lines",
	"will be deleted. Note that if the cursor is after the end of the",
	"current line, no action will be performed."
};

const char * const BACKSPACE_HELP[6] = {
	"Syntax: Backspace [N]",
	"Abbreviation: BS",
	"",
	"acts like DeleteChar, but moves to the right the cursor before",
	"deleting each character."
};

const char * const INSERTLINE_HELP[7] = {
	"Syntax: InsertLine [N]",
	"Abbreviation: IL",
	"",
	"inserts N lines at the current cursor position, breaking the current",
	"line. If the optional N argument is not specified, it is assumed to be",
	"one."
};

const char * const DELETELINE_HELP[9] = {
	"Syntax: DeleteLine [N]",
	"Abbreviation: DL",
	"",
	"deletes N lines at the current currsor position, putting the last one",
	"in the temporary buffer, from which it can be undeleted.  See",
	"UndelLine. If the optional N argument is not specified, it is assumed",
	"to be one. Note that this action is in no way inverse with respect to",
	"InsertLine."
};

const char * const DELETEEOL_HELP[10] = {
	"Syntax: DeleteEOL",
	"Abbreviation: DE",
	"",
	"deletes all characters from the current cursor position to the end of",
	"the line.",
	"",
	"   This command could be easily implemented with a macro, but it is",
	"such a common, basic editing feature that it seemed worth a separate",
	"implementation."
};

const char * const ABOUT_HELP[5] = {
	"Syntax: About",
	"Abbreviation: About",
	"",
	"displays a simple information line about ne on the status bar."
};

const char * const BEEP_HELP[6] = {
	"Syntax: Beep",
	"Abbreviation: BE",
	"",
	"beeps. If your terminal cannot beep, it flashes. If it cannot flash,",
	"nothing happens (but you have a very bad terminal)."
};

const char * const EXEC_HELP[13] = {
	"Syntax: Exec",
	"Abbreviation: EX",
	"",
	"prompts the user on the input line, asking for a command, and executes",
	"it. It is never registered while recording a macro (but the command you",
	"type is).",
	"",
	"   This command is mainly useful for key bindings, menu configurations,",
	"and in manually programmed macros.",
	"",
	"   Note that if the command you specify does not appear in ne's",
	"internal tables, it is considered to be a macro name. See Macro."
};

const char * const FLASH_HELP[6] = {
	"Syntax: Flash",
	"Abbreviation: FL",
	"",
	"acts as Beep, but interchanging the words \"beep\" and \"flash\".  Same",
	"comments apply. See Beep."
};

const char * const HELP_HELP[13] = {
	"Syntax: Help [NAME]",
	"Abbreviation: H",
	"",
	"displays some help about the command NAME (both the short and the long",
	"version are accepted). If no argument is given, a list of all existing",
	"commands in long form is displayed, allowing you to choose one. You can",
	"browse the help text with the standard navigation keys. If you press",
	"Return, the command list will be displayed again. If you press f1 or",
	"Escape, you will return to normal editing.",
	"",
	"   This command is never registered while recording a macro, so that",
	"you can safely access the help system while recording. See Record."
};

const char * const NOP_HELP[5] = {
	"Syntax: NOP",
	"Abbreviation: NOP",
	"",
	"does nothing. Mainly useful for inhibiting standard key bindings."
};

const char * const REFRESH_HELP[8] = {
	"Syntax: Refresh",
	"Abbreviation: REF",
	"",
	"refreshes the display. This command is very important, and should",
	"preferably be bound to the Control-L sequence, for historical",
	"reasons. It can always happen that a noisy phone line or a quirk in the",
	"terminal corrupts the display. This command restores it from scratch."
};

const char * const SUSPEND_HELP[6] = {
	"Syntax: Suspend",
	"Abbreviation: SU",
	"",
	"suspends ne; usually, the fg command is used in order to restart",
	"it."
};

const char * const SYSTEM_HELP[10] = {
	"Syntax: System [COMMAND]",
	"Abbreviation: SYS",
	"",
	"asks the shell to execute COMMAND. The terminal is temporarily reset to",
	"the state it was in before ne's activation, and COMMAND is started.",
	"When the execution is finished, ne returns in control.",
	"",
	"   If the optional argument COMMAND is not specified, you can enter it",
	"on the input line."
};

const char * const ESCAPE_HELP[7] = {
	"Syntax: Escape",
	"Abbreviation: ESC",
	"",
	"toggles on and off the menus, or escapes from the input line. This",
	"command is mainly useful for reprogramming the menu activator, and it is",
	"never registered while recording a macro. See Record."
};

