
/* actions.c */
int do_action ( buffer *b , action a , int c , char *p );

/* buffer.c */
char_pool *alloc_char_pool ( int size );
void free_char_pool ( char_pool *cp );
char_pool *get_char_pool ( buffer *b , char *p );
line_desc_pool *alloc_line_desc_pool ( int pool_size );
void free_line_desc_pool ( line_desc_pool *ldp );
buffer *alloc_buffer ( buffer *cur_b );
void free_buffer_contents ( buffer *b );
void clear_buffer ( buffer *b );
void free_buffer ( buffer *b );
int calc_lost_chars ( buffer *b );
buffer *get_nth_buffer ( int n );
buffer *get_buffer_named ( const char *p );
int modified_buffers ( void );
int save_all_modified_buffers ( void );
line_desc *alloc_line_desc ( buffer *b );
void free_line_desc ( buffer *b , line_desc *ld );
char *alloc_chars ( buffer *b , int len );
int alloc_chars_around ( buffer *b , line_desc *ld , int n , int check_first_before );
void free_chars ( buffer *b , char *p , int len );
int insert_lin ( buffer *b , line_desc *ld , int line , int pos );
int delete_lin ( buffer *b , line_desc *ld , int line );
int undelete_line ( buffer *b );
void delete_to_eol ( buffer *b , line_desc *ld , int line , int pos );
int insert_stream ( buffer *b , line_desc *ld , int line , int pos , const char *stream , int stream_len );
int insert_char ( buffer *b , line_desc *ld , int line , int pos , char c );
int insert_spaces ( buffer *b , line_desc *ld , int line , int pos , int n );
int delete_stream ( buffer *b , line_desc *ld , int line , int pos , int len );
int delete_char ( buffer *b , line_desc *ld , int line , int pos );
void change_filename ( buffer *b , char *name );
int load_file_in_buffer ( buffer *b , const char *name );
int load_fh_in_buffer ( buffer *b , int fh );
int save_buffer_to_file ( buffer *b , const char *name );
void auto_save ( buffer *b );

/* clips.c */
clip_desc *alloc_clip_desc ( int n , int size );
clip_desc *realloc_clip_desc ( clip_desc *cd , int n , int size );
void free_clip_desc ( clip_desc *cd );
clip_desc *get_nth_clip ( int n );
int copy_to_clip ( buffer *b , int n , int cut );
int erase_block ( buffer *b );
int paste_to_buffer ( buffer *b , int n );
int copy_vert_to_clip ( buffer *b , int n , int cut );
int erase_vert_block ( buffer *b );
int paste_vert_to_buffer ( buffer *b , int n );
int load_clip ( int n , const char *name );
int save_clip ( int n , const char *name );

/* command.c */
void build_hash_table ( void );
void build_command_name_table ( void );
action parse_command_line ( const char *command_line , int *num_arg , char **string_arg, int exec_only_options );
int execute_command_line ( buffer *b , const char *command_line );
macro_desc *alloc_macro_desc ( void );
void free_macro_desc ( macro_desc *md );
void record_action ( char_stream *cs , action a , int c , char *p , int verbose );
int play_macro ( buffer *b , char_stream *cs );
macro_desc *load_macro ( const char *name );
int execute_macro ( buffer *b , const char *name );
void help ( char *p );
int cmdcmp(const char *c, const char *m);
void unload_macros(void);

/* display.c */
void delay_update(buffer *b);
void mvaddstrn ( int y , int x , line_desc *ld , int start , int len , int tab_size , int cleared_at_end );
void update_partial_line ( buffer *b , int n , int start_x , int cleared_at_end );
void update_line ( buffer *b , int n );
void update_window_lines ( buffer *b , int start_line , int end_line , int doit );
void update_window ( buffer *b );
void update_deleted_char ( buffer *b , char c , line_desc *ld , int pos , int line , int x );
void update_inserted_char ( buffer *b , line_desc *ld , int pos , int line , int x );
void update_overwritten_char ( buffer *b , char old_char , line_desc *ld , int pos , int line , int x );
void reset_window ( void );
void refresh_window ( buffer *b );
void scroll_window ( buffer *b , int line , int n );

/* edit.c */
int to_upper ( buffer *b );
int to_lower ( buffer *b );
int capitalize ( buffer *b );
int match_bracket ( buffer *b );
int word_wrap ( buffer *b );
int paragraph ( buffer *b );
int center ( buffer *b );
int auto_indent_line ( buffer *b );

/* errors.c */

/* exec.c */
void new_list ( list *l );
void add_head ( list *l , node *n );
void add_tail ( list *l , node *n );
void rem ( node *n );
void add ( node *n , node *pos );
void free_list ( list *l , void (func )());
void apply_to_list ( list *l , void (func )());

/* help.c */

/* inputclass.c */

/* keys.c */
void read_key_capabilities ( void );
void set_escape_time( int new_escape_time );
int get_key_code ( void );

/* menu.c */
void print_message(const char *message);
int search_menu_title ( int n , int c );
int search_menu_item ( int n , int c );
void reset_status_bar ( void );
char *gen_flag_string ( buffer *b );
void draw_status_bar ( void );
int print_error ( int error_num );
void print_info ( int info_num );
void handle_menus ( void );
void get_menu_configuration ( char * );
void get_key_bindings ( char * );

/* names.c */

/* navigation.c */
int line_up ( buffer *b );
int line_down ( buffer *b );
int char_left ( buffer *b );
int char_right ( buffer *b );
int page_up ( buffer *b );
int page_down ( buffer *b );
void goto_line ( buffer *b , int n );
void goto_column ( buffer *b , int n );
void goto_pos ( buffer *b , int pos );
void move_to_sol ( buffer *b );
void move_to_eol ( buffer *b );
void reset_position_to_sof ( buffer *b );
void move_to_sof ( buffer *b );
void move_to_eof ( buffer *b );
void toggle_sof_eof ( buffer *b );
void toggle_sol_eol ( buffer *b );

/* ne.c */
buffer *new_buffer ( void );
int delete_buffer ( void );
int main ( int argc , char **argv );

/* prefs.c */
char *exists_prefs_dir ( void );
int save_prefs ( buffer *b , const char *name );
int load_prefs ( buffer *b , const char *name );
int load_auto_prefs ( buffer *b , const char *name );
int save_auto_prefs ( buffer *b , const char *name );


/* request.c */
int request_response ( buffer *b , const char *prompt , int default_value );
char request_char ( buffer *b , const char *prompt , const char default_value );
int request_number ( const char *prompt , int default_value );
char *request_string ( const char *prompt , const char *default_string , int accept_null_string );
char *request ( const char *prompt , const char *default_string , int alpha_allowed );
int request_strings ( const char * const * const entries , int num_entries , int max_name_len );
char *request_files ( const char *filename );
char *request_file ( buffer *b , const char *prompt , const char *default_name );
int request_document ( void );

/* search.c */
int find ( buffer *b , const char *pattern , int dir , int skip_first );
int replace ( buffer *b , int n , const char *string );
int find_regexp ( buffer *b , const char *regex , int dir , int skip_first );
int replace_regexp ( buffer *b , const char *string );
int search_word ( buffer *b , int dir );
void move_to_eow ( buffer *b );

/* signals.c */
void stop_ne( void );
void set_fatal_code ( void );
void block_signals ( void );
void release_signals ( void );
void set_stop ( int sig );

/* streams.c */
char_stream *alloc_char_stream ( int size );
void free_char_stream ( char_stream *cs );
char_stream *realloc_char_stream ( char_stream *cs , int size );
int add_to_stream ( char_stream *cs , const char *s , int len );
char_stream *reset_stream ( char_stream *cs );
int is_one_line ( char_stream *cs );
char_stream *load_stream ( char_stream *cs , const char *name );
char_stream *load_stream_from_fh ( char_stream *cs , int fh );
int save_stream ( char_stream *cs , const char *name );
int save_stream_to_fh ( char_stream *cs , int fh );

/* support.c */
const char *tilde_expand ( const char *filename );
const char *file_part ( const char *pathname );
char *str_dup ( const char *s );
void output_string ( const char *s );
int strcmpp ( const void *a , const void *b );
void set_interactive_mode ( void );
void unset_interactive_mode ( void );
int calc_len ( line_desc *ld , int n , int tab_size );
int calc_pos ( line_desc *ld , int n , int tab_size );

/* term.c */
void ring_bell ( void );
void do_flash ( void );
void set_terminal_modes ( void );
void reset_terminal_modes ( void );
void set_terminal_window ( int size );
void standout_on ( void );
void standout_off ( void );
void cursor_on ( void );
void cursor_off ( void );
void move_cursor ( int row , int col );
void clear_end_of_line ( int first_unused_hpos );
void clear_to_eol ( void );
void clear_to_end ( void );
void clear_entire_screen ( void );
void output_chars ( const char *string , int len );
void insert_chars ( const char *start , int len );
void delete_chars ( int n );
void ins_del_lines ( int vpos , int n );
void term_init ( void );

/* undo.c */
void start_undo_chain ( buffer *b );
void end_undo_chain ( buffer *b );
int add_undo_step ( buffer *b , int line , int pos , int len );
int add_to_undo_stream ( undo_buffer *ub , const char *p , int len );
void reset_undo_buffer ( undo_buffer *ub );
int undo ( buffer *b );
int redo ( buffer *b );
