#ifndef BE_FONT_ENCODING
#define BE_FONT_ENCODING

#include <SupportDefs.h>

#include "FontEncoding.h"

typedef char utf8char[5];

typedef struct {
	char *name; 
	// int16 code; // PDF char code (-1 = not used)
	int32 unicode; // BeOS char code
	utf8char utf8;
} BeCharacterEncoding;

class BeFontEncoding {
public:
	BeFontEncoding(BeCharacterEncoding *encoding);
	int32 getIndex(const char *name);
	const char *getUtf8(const char *name);
	const char *getUtf8At(int32 index);

	static uint16 toUnicode(const char *string);
	static int32 toUtf8(uint16 unicode, char *string);
private:
	BeCharacterEncoding *encoding;
	int32 size;
};

extern BeFontEncoding beSymbolEncoding;
extern BeFontEncoding beStandardEncoding;


#endif
