/*  
    BeOS Front-end of PDF file reader xpdf.
    Copyright (C) 1997 Benoit Triquet
    Copyright (C) 1998-99 Hubert Figuiere
    Copyright (C) 2000 Michael Pfeiffer
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include "FindTextWindow.h"

FindTextWindow::FindTextWindow(const char *text, BRect aRect, BLooper *looper) 
	: BWindow(aRect, "Find Text", 
		B_MODAL_WINDOW_LOOK,
		B_MODAL_APP_WINDOW_FEEL, 
		B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_NOT_CLOSABLE) {
	mLooper = looper;
	
	// center window
	aRect.OffsetBy(aRect.Width() / 2, aRect.Height() / 2);
	float width = 300, height = 45;
	aRect.SetRightBottom(BPoint(aRect.left + width, aRect.top + height));
	aRect.OffsetBy(-aRect.Width() / 2, -aRect.Height() / 2);
	// view for the background color
	BRect rect(0, 0, width, height);
	BView *view = new BView(rect, "status_view", B_FOLLOW_NONE, 0);
	view->SetViewColor(225, 255, 225, 255);

	mText = new BTextControl(BRect(10, 3, width-135, 20), "find", "Find: ", text, new BMessage('FIND'));
	mText->SetDivider(25);
	view->AddChild(mText);

	mPage = new BStringView(BRect(10, 21, 60, 40), "page", "Page:");
	view->AddChild(mPage);

	// 
	mFindStop = new BButton(BRect(width-125, 0, width-65, 20), "findStop", "Find", new BMessage('FIND'));
	view->AddChild(mFindStop);
	mAbort = new BButton(BRect(width-60, 0, width-5, 20), "abort", "Abort", new BMessage('ABRT'));
	view->AddChild(mAbort);

	AddChild(view);
	MoveTo(aRect.left, aRect.top);
	ResizeTo(width, height);
	mText->MakeFocus();
	Show();
}

void FindTextWindow::MessageReceived(BMessage *msg) {
	switch (msg->what) {
	case 'FIND': {
		const char *text = mText->Text();
		if (strlen(text) == 0) return;
		mFindStop->SetLabel("Stop");
		mFindStop->SetMessage(new BMessage('STOP'));
		mText->SetEnabled(false);
		
		BMessage msg((uint32)FIND_START_NOTIFY_MSG);
		msg.AddString("text", text);
		mLooper->PostMessage(&msg, NULL);
		break; }
	case 'ABRT':
		mLooper->PostMessage((uint32)FIND_ABORT_NOTIFY_MSG, NULL);
		break;
	case FIND_ABORT_NOTIFY_MSG:
		mFindStop->SetEnabled(false); 
		break;
	case 'STOP':
		mLooper->PostMessage((uint32)FIND_STOP_NOTIFY_MSG, NULL);
		break;
	case FIND_STOP_NOTIFY_MSG:
		mFindStop->SetLabel("Find");
		mFindStop->SetMessage(new BMessage('FIND'));
		mText->SetEnabled(true);
		break;
	case FIND_SET_PAGE_MSG: {
		int32 page;
		char buffer[20];
		msg->FindInt32("page", &page);
		sprintf(buffer, "Page: %d", page);
		mPage->SetText(buffer);
		break; }
	default:
		BWindow::MessageReceived(msg);
	}
}

