/*  
	BeOS Front-end du PDF file reader xpdf.
    Copyright (C) 1997 Benoit Triquet
    Copyright (C) 1998 Hubert Figuiere
	Copyright (C) 2000 Michael Pfeiffer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef FIND_TEXT_WINDOW_H
#define FIND_TEXT_WINDOW_H
#include <Window.h>
#include <Rect.h>
#include <String.h>
#include <Button.h>
#include <TextControl.h>
#include <SupportDefs.h>
#include <Looper.h>
#include <StringView.h>

class FindTextWindow : public BWindow {
public:
	FindTextWindow(const char *text, BRect, BLooper *looper);
	void MessageReceived(BMessage *msg);
	enum {
		FIND_START_NOTIFY_MSG = 'TSrt',
		FIND_STOP_NOTIFY_MSG = 'TStp',
		FIND_ABORT_NOTIFY_MSG = 'SAbt',
		TEXT_FOUND_NOTIFY_MSG = 'TFnd',
		TEXT_NOT_FOUND_NOTIFY_MSG = 'TNFd',
		FIND_SET_PAGE_MSG = 'FStP'
	};
protected:
	BLooper *mLooper;
	BButton *mFindStop, *mAbort;
	BTextControl *mText;
	BStringView *mPage;
};
#endif
