/*  
	BeOS Front-end du PDF file reader xpdf.
    Copyright (C) 1998 Hubert Figuiere
	Copyright (C) 2000 Michael Pfeiffer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _PDFVIEW_H_
#define _PDFVIEW_H_

#include <interface/Bitmap.h>
#include <interface/View.h>

#include <GString.h>
#include "Page.h"
#include "XRef.h"
#include "Catalog.h"

#include "PDFDoc.h"
#include "BeOutputDev.h"
#include "History.h"
#include "FindTextWindow.h"

class PDFWindow;

#define MIN_ZOOM	-5
#define MAX_ZOOM	5

class PDFView
	: public BView
{
public:
	PDFView (entry_ref * ref, BRect frame,
								const char *name,
								uint32 resizeMask,
								uint32 flags);
	virtual ~PDFView();
	bool LoadFile(entry_ref *ref, bool init = false);
	void SetViewCursor(BCursor *cursor, bool sync = true);

virtual	void Draw (BRect updateRect);
virtual void FrameResized (float width, float height);
virtual void AttachedToWindow ();
	void SkipMouseMoveMsgs();
virtual void KeyDown (const char * bytes, int32 numBytes);
virtual void MouseDown (BPoint point);
virtual void MouseMoved (BPoint point, uint32 transit, const BMessage *msg);
virtual void MouseUp (BPoint point);
virtual void ScrollTo (BPoint point);
virtual void MessageReceived(BMessage *msg);
void ScrollTo(float x, float y) { BView::ScrollTo(x, y); }
	bool IsOk();

	void SetPage ( int page, bool record = true );
	void Back();
	
	int Page() { return mCurrentPage; } ;

//	PDFDoc *Doc() { return mDoc; };
//	BeOutputDev *OutputDev() { return mOutputDev; };
	
	void SetZoom ( int zoom );
	void SetRotation ( float rot );
	void Redraw(PDFDoc *doc = NULL);

	void FixScrollbars ();

	int GetNumPages()
		{ return mDoc->getNumPages(); };
	int GetPageWidth(int page)
		{ return (int)mDoc->getPageWidth (page); };
	int GetPageHeight(int page)
		{ return (int)mDoc->getPageHeight (page); };

	status_t PageSetup();
	void Print();

	bool HandleLink(BPoint point);
	void DisplayLink(BPoint point);
	
	void Find(const char *s, PDFWindow *window, FindTextWindow *find);
	void StopFind();
	
	void Dump(); // called from BeOutputDev
	friend int32 printing_thread(void *data);
	
	void SetSelection(int xMin, int yMin, int xMax, int yMax);
	void GetSelection(int &xMin, int &yMin, int &xMax, int &yMax);
	void CopySelection();
private:
	PDFDoc * mDoc;
	bool mOk;
	int mZoom;
	BBitmap * mBitmap;
	BView * mOffscreenView;
	BeOutputDev * mOutputDev;
	int mCurrentPage;
	float mRotation;
	GString * mTitle;
	float mWidth, mHeight;		//document width and height
	LinkAction *mLinkAction;
	History mHistory;

	BCursor *mViewCursor;
	uint32 mMouseDown;		 
	BPoint mMousePosition;

	enum { 
		NOT_SELECTED = 0,
		DO_SELECTION, 
		SELECTED
	} mSelected;
	BPoint mSelectionStart;
	BRect mSelection;
	
	BMessage * mPrintSettings;

	void RecreateBitmap ();	
	void ScrollVertical(bool down, float by);
	void ScrollHorizontal(bool right, float by);
};


//////////////////////////////////////////////////////////////////
inline bool PDFView::IsOk()
{
	return mOk;
}

//////////////////////////////////////////////////////////////////

#endif
