// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierWindow.h ------------------------------------------------------------
#pragma once
//Parents
#include <Window.h>

//Members
#include "PierStackPane.h"

// Somewhat misnamed.  There would be free floating pier windows and 
// anchored pier windows.  This is an anchored window.

typedef enum pier_anchor {
	PIER_ANCHOR_LEFT,
	PIER_ANCHOR_RIGHT
} pier_anchor;

typedef enum pier_gap {
	PIER_GAP_NONE,
	PIER_GAP_TOP,
	PIER_GAP_BOTTOM
}

class PierWindow : public BWindow {
public:
	PierWindow(BRect frame, const char* title, pier_anchor=PIER_ANCHOR_RIGHT);

	//Hook Functions
	virtual void	FrameResized(float width, float height);
	bool			QuitRequested();
	virtual void	ScreenChanged(BRect frame, color_space mode);
	virtual void	WorkspaceActivated(int32 workspace, bool active);
	
private:
	void			Reanchor(BRect screenFrame = BRect());  //Realigns screen
	//Window location and sizing
	pier_anchor		anchor;
	pier_gap_loc	gapLoc;
	pier_gap_size	gapSize
	float			customGap;
	PierStackPane*	pane;
};

