// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierControls.h ========================================================
#pragma once
#include <View.h>
#include <Polygon.h>

// Constants =============================================================
// Messages
#define PIER_SCROLL 'PScr'

// PierClose =============================================================
class PierCloser : public BView {
public:
	PierCloser(BRect frame);
	virtual void	AttachedToWindow(void);
	virtual void 	Draw(BRect updateRect);
	virtual void	MouseDown(BPoint point);
};

// PierZoom ==============================================================
class PierZoomer : public BView {
public:
	PierZoomer(BRect frame);
	virtual void	AttachedToWindow(void);
	virtual void 	Draw(BRect updateRect);
	virtual void	MouseDown(BPoint point);
};

// PierScroll ============================================================
class PierScroller : public BView {
public:
	PierScroller(BRect frame, bool scrollUp);
	virtual void	AttachedToWindow(void);
	virtual void 	Draw(BRect updateRect);
	virtual void	MouseDown(BPoint point);
private:
	bool		scrollUp;
	BPolygon	poly;
};

// PierResize ============================================================
class PierResizer : public BView {
public:
	PierResizer(BRect frame);
	virtual void	AttachedToWindow(void);
	virtual void 	Draw(BRect updateRect);
	virtual void	MouseDown(BPoint point);
private:
	BPolygon	poly;
};
