// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierPane.h ============================================================
#pragma once

#include <View.h>
// Constants =============================================================
// pane ctor flags
enum {
	PIER_CLOSER		= 0x00000001,
	PIER_ZOOMER		= 0x00000002,
	PIER_SCROLLER	= 0x00000004,
	PIER_RESIZER	= 0x00000008
};

// pier_loc
typedef enum pier_loc {
	PIER_NONE,
	PIER_LEFT,
	PIER_TOP,
	PIER_RIGHT,
	PIER_BOTTOM
} pier_loc;

// pier_size
typedef enum pier_size {	
	PIER_CUSTOM,
	PIER_ZERO,
	PIER_SMALL,
	PIER_MEDIUM,
	PIER_LARGE
} pier_size;

// Standard sizes
#define PIER_HEADER_HDEF 14.0
#define PIER_WIDTH 115.0

// Colors
const rgb_color PIER_BG_COLOR			= {216,216,216,255};
const rgb_color PIER_RAISE_COLOR		= {255,255,255,255};
const rgb_color PIER_DROP_COLOR		= {194,194,194,255};
const rgb_color PIER_SEPARATOR_COLOR	= { 87, 87, 87,255};

// PierPaneSet ============================================================
class PierPaneSet;

// PierPane ===============================================================
class PierPane : public BView {
public:
	//Ctor/Dtor
	PierPane(
		BRect frame			= BRect(0,0,PIER_WIDTH,3*PIER_HEADER_HDEF), 
		const char *name	= "A Pane", 
		uint32 paneFlags	= PIER_CLOSER,
		uint32 resizingMode	= B_FOLLOW_LEFT | B_FOLLOW_TOP, 
		uint32 flags		= B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE | B_NAVIGABLE_JUMP);
	PierPane(BMessage* archive);
	
	//Virtual & Static Functions
	virtual status_t	Archive(BMessage * archive, bool deep = true) const;
	static  PierPane*	Instantiate(BMessage* archive);
	virtual void		AboutRequested(void);
	virtual void		Draw(BRect updateRect);
	virtual void		GetPreferredSize(float* width, float* height);
	virtual void		Hide(void);
	virtual void		MessageReceived(BMessage* message);
	virtual void		QuitRequested(void);
	virtual void		Resize(pier_size paneSize);
	virtual BRect		ResizeLimits(BPoint mouseDown);
	virtual void		ResizeMouseDown(BPoint point);
	virtual void		Scroll(bool scrollUp);
	virtual void		Show(void);
	virtual void		WorkspaceActivated(int32 workspace, bool active);
	virtual void		Zoom(bool zoomUp = true);
	
	// Data access
	void				SetAutoGrow(bool grow) {autoGrow = grow;}	//inline
	int32				HideCount(void) const {return hideCount;}	//inline
	PierPaneSet*		PaneParent(void) const {return paneParent;} //inline
	status_t			SetPaneParent(PierPaneSet* pane);

protected:
	// PaneParent
	PierPaneSet*		paneParent;
	// Flags
	uint32				paneFlags;
	bool				autoGrow;  
	bool				miniBars;
	// Size settings
	int32				hideCount;
	float				headerHeight;
	float				footerHeight;
	float				customWidth;
	float				customHeight;
	pier_size			paneSize;
	// Resizer
	BView*				resizer;
	BRect				resizeLimits;
	BPoint				resizeOffset;
	BPoint				resizePoint;
};

