// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierPaneSet.h ===========================================================
#pragma once

#include "PierPane.h"
#include <Rect.h>

class PierPaneSet {
public:
	// Ctor
	PierPaneSet(void);
	virtual ~PierPaneSet(void);

	// Add/Remove Pane
	virtual status_t	AddPane(PierPane* pane)	= 0;
	virtual status_t	RemovePane(PierPane* pane) = 0;

	// PaneSizing
	virtual void		PaneResized(PierPane* pane, float dwidth, float dheight) = 0;
	virtual BRect		PaneResizeLimits() = 0;
};
