// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierScrollable.h --------------------------------------------------------
#pragma once

#include "PierPane.h"

class PierScrollable : public BView {
public:
	// Constructor/Destructor
	PierScrollable(BRect frame, const char *name=NULL);
	PierScrollable(BMessage* archive);
   ~PierScrollable(void);
	
	// Virtual and static functions
	virtual status_t	Archive(BMessage * archive, bool deep = true) const;
	virtual void		GetPreferredSize(float* width, float* height);
	static  PierScrollable* Instantiate(BMessage* archive);
	
	// PaneSet Functions
	virtual status_t	AddPane(PierPane* pane);
	virtual status_t	RemovePane(PierPane* pane);
	virtual void		PaneResized(PierPane* pane, float dwidth, float dheight);
	virtual void		WorkspaceActivated(int32 workspace, bool active);

private:
	BList*	panes;
};

