// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierStackPane.h ------------------------------------------------------------
#pragma once

#include "PierPane.h"
#include "PierPaneSet.h"
#include "PierScrollable.h"

#pragma export on
class PierStackPane : public PierPane, public PierPaneSet {
public:
	// Ctor/Dtor
	PierStackPane(BRect frame, const char *name=NULL, 
		uint32 paneFlags = PIER_CLOSER | PIER_ZOOMER | PIER_SCROLLER | PIER_RESIZER);
	PierStackPane(BMessage* archive);
	
	// Virtual & Static Functions
	virtual void		AboutRequested(void);
	virtual void		AllAttached(void);
	virtual status_t	Archive(BMessage * archive, bool deep = true) const;
	virtual void		Draw(BRect updateRect);
	virtual void		GetPreferredSize(float* width, float* height);
	static  PierStackPane*	Instantiate(BMessage* archive);
	virtual void		WorkspaceActivated(int32 workspace, bool active);
	virtual void		Zoom(bool zoomUp = true);
		
	// PaneSet Commands
	virtual status_t	AddPane(PierPane* pane);
	virtual status_t	RemovePane(PierPane* pane);
	virtual void		PaneResized(PierPane* pane, float dwidth, float dheight)	;
	virtual BRect		PaneResizeLimits(void);

private:
	PierScrollable*		panes;
};
#pragma export off

