// Copyright 1998, Patrick S. M. Gratton, All rights reserved.
// PierWork.h ------------------------------------------------------------
#pragma once
#include "PierPane.h"
#include <ListView.h>
#include <ListItem.h>

// PierWorkItem ==========================================================
class PierWorkItem : public BStringItem {
public:
	PierWorkItem(const char *text, uint32 level = 0, bool expanded = true);
	PierWorkItem(BMessage *archive);
	virtual void DrawItem(BView *owner, BRect frame, bool complete = false);
	virtual void Update(BView *owner, const BFont *font);
};

// PierWorkList ==========================================================
class PierWorkList : public BListView {
public:
	PierWorkList(BRect frame, const char *name, 
		list_view_type type = B_SINGLE_SELECTION_LIST, 
		uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP, 
		uint32 flags = B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS);
	PierWorkList(BMessage *archive);
	virtual void SelectionChanged(void);
};

// PierWork ==============================================================
class PierWork : public PierPane {
public:
	// Structors
	PierWork(uint32 paneFlags = PIER_CLOSER | PIER_ZOOMER | PIER_RESIZER);
   ~PierWork();
   
	// Hook functions
	virtual void AboutRequested(void);
	virtual void AllAttached(void);
	virtual void Draw(BRect updateRect);
	virtual void GetPreferredSize(float* width, float* height);
	virtual void WorkspaceActivated(int32 workspace, bool active);

private:
	// Workspace Name Management
	void		ReadNames(void); // From preferences file
	void		UseNames(void);  // Rebuild List and menu
	int32		nspaces;
	char*		spaceNames[32];
	BListView*	listView;
};

