//	StripWindow.h

#pragma once

#include "StripColors.h"
#include "ModuleView.h"
#include <Window.h>

class StripWindow : public BWindow
{
	private:
	
		const static int defaultWidth;
		const static rgb_color baseColor;
		const static rgb_color titleColor;

		bool rolledUp;
		BList moduleList;

		void adjust(void);
		static bool recalcProc(void *, void *);
		static bool resizeProc(void *, void *);

	public:

		StripWindow();
		void ScreenChanged(BRect, color_space);
		bool QuitRequested(void);
		void AddModule(ModuleView *);
		void Recalc(void);
		void ShowHide(void);

		const static StripColors *colors;
		const static StripColors *titleColors;
};
