//	ModuleView.cpp

#pragma once

#include "ModuleView.h"
#include "ModuleFilter.h"
#include "StripWindow.h"
#include <Entry.h>
#include <Path.h>

typedef BView *(*ModuleProcPtr)(BEntry *);

const int ModuleView::moduleBorder = 4;

ModuleView::ModuleView(BView *theModule, image_id moduleImage)
	: BView(BRect(),NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP,B_WILL_DRAW | B_FRAME_EVENTS | B_FULL_UPDATE_ON_RESIZE)
{
	BRect bounds;

	module = theModule;
	image = moduleImage;
	msgFilter = new ModuleFilter(this);
	SetViewColor(StripWindow::colors->base);
	module->SetViewColor(StripWindow::colors->base);
	bounds = module->Bounds();
	ResizeTo(bounds.Width()+2*moduleBorder,bounds.Height()+2*moduleBorder);
	module->MoveTo(moduleBorder,moduleBorder);
	AddChild(module);
}

ModuleView::~ModuleView()
{
	RemoveChild(module);
	delete module;
	unload_add_on(image);
}

void ModuleView::AttachedToWindow(void)
{
	Window()->Lock();
	Window()->AddCommonFilter(msgFilter);
	Window()->Unlock();
}

void ModuleView::DetachedFromWindow(void)
{
	Window()->Lock();
	Window()->RemoveCommonFilter(msgFilter);
	Window()->Unlock();
}

void ModuleView::Draw(BRect clipRect)
{
	BRect rect;

	rect = Bounds();
	SetHighColor(StripWindow::colors->deepShadow);
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
	StrokeLine(rect.RightTop(),rect.RightBottom());
	SetHighColor(StripWindow::colors->highlight);
	StrokeLine(rect.LeftTop(),rect.RightTop());
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
	rect.InsetBy(1,1);
	SetHighColor(StripWindow::colors->shadow);
	StrokeLine(rect.LeftBottom(),rect.RightBottom());
	StrokeLine(rect.RightTop(),rect.RightBottom());
	SetHighColor(StripWindow::colors->brightHighlight);
	StrokeLine(rect.LeftTop(),rect.RightTop());
	StrokeLine(rect.LeftTop(),rect.LeftBottom());
}

void ModuleView::FrameResized(float width, float height)
{
	int widthOffset, heightOffset;

	widthOffset = width-module->Bounds().Width();
	heightOffset = height-module->Bounds().Height();
	module->MoveTo(widthOffset/2,heightOffset/2);
}

ModuleView *ModuleView::LoadModule(BEntry *moduleEntry)
{
	status_t err;
	BPath modulePath;
	ModuleProcPtr moduleProc;
	image_id moduleImage;
	BView *theModule;

	err = moduleEntry->GetPath(&modulePath);
	if (err != B_NO_ERROR)
		return NULL;
	moduleImage = load_add_on(modulePath.Path());
	if (moduleImage == B_ERROR)
		return NULL;
	err = get_image_symbol(moduleImage,"create_module",B_SYMBOL_TYPE_TEXT,&moduleProc);
	if (err != B_NO_ERROR)
	{
		unload_add_on(moduleImage);
		return NULL;
	}
	theModule = moduleProc(moduleEntry);
	if (!theModule)
	{
		unload_add_on(moduleImage);
		return NULL;
	}
	return new ModuleView(theModule,moduleImage);
}