#include "RunView.h"

// The view methods contain the actual working code, 
// and also the nifty replicant stuff. Read the comments
// for further enlightenment...

RunView::RunView(const char *text, const char *path)
	: BView(kWindowSiz,"Run", B_FOLLOW_LEFT_RIGHT, B_WILL_DRAW)
{
	// thePath will be used as the working directory when the command
	// is executed. The Run application sets path to the null string;
	// the Tracker add-on sets it to the current Tracker window.
	// When the view is replicated, it remembers its path.
	// 
	strcpy(thePath,path);
	
	// Create and add the text input box.
	theTextControl = new BTextControl(kTextSiz, "runtext", NULL, text, 
							NULL, B_FOLLOW_LEFT_RIGHT, 
							B_NAVIGABLE | B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE);
	AddChild(theTextControl);
	
	// Create and add the button.
	theButton = new BButton(kButtonSiz, "runbutton", kButtonText,
						new BMessage(kRunMsg), B_FOLLOW_RIGHT);
	AddChild(theButton);
	
	// Create and add the replicant dragger.
	// There's a bug (apparently in the Tracker) which
	// crashes the Tracker when the addon is replicated to
	// the desktop. Temporary solution: disable the BDragger
	// in the addon:
	// 
	if (!kAddOn)
		AddChild( new BDragger(BRect(0,0,7,7),this,B_FOLLOW_LEFT|B_FOLLOW_TOP) );
}

RunView::~RunView()
{
	
}

void RunView::AttachedToWindow(void)
{
	theTextControl->MakeFocus();
	theButton->MakeDefault(true);
	
	// The code for handling the button's BMessage
	// is contained in the view, not the window, so that
	// the view can be replicated. We'll have to 
	// retarget the button to point to me (the view):
	// 
	theButton->SetTarget(this);
	
	// Set the button to the proper size and position. 
	// Why is this necessary? I don't know, but I got some 
	// weird behavior where the button kept resizing after 
	// the view was replicated, and this fixed it:
	// 
	theButton->MoveTo(Bounds().right - (kWindowSiz.right - kButtonSiz.left),kButtonSiz.top);
	theButton->ResizeTo(kButtonSiz.Width(),kButtonSiz.Height());
	
	if (Parent())
		SetViewColor(Parent()->ViewColor());
}

void RunView::MessageReceived(BMessage *msg)
{
	if (msg->what == kRunMsg)
	{
		// The button has been pressed. Let the window know
		// by passing on the message which the button sent.
		// My windows will close themselves when they see it.
		// If I'm a replicant and I'm inside someone else's
		// window, it'll just ignore this message (good):
		// 
		Window()->PostMessage(msg);
		
		// Now, do stuff:
		// 
		RunCommand();
	}
	else
		BView::MessageReceived(msg);
}

void RunView::RunCommand(void)
{
	// All of the actual work is done inside this function.
	// That's right: I have about two hundred lines of
	// interface code and three lines of actual processing. 
	// Welcome to GUI programming.
	
	char temp[kCommandLen+kPathLen+12];
	char command[kCommandLen+1];
	
	// Truncate the input to 1024 characters so it fits in the buffer:
	strncpy(command,theTextControl->Text(),kCommandLen);
	
	// Create the command to pass to system():
	sprintf(temp,"cd \"%s\"; %s &", thePath, command);
	
	system(temp);
}

const char *RunView::Text(void)
{
	// Returns the contents of the Text Control.
	// My window wants to know this when it saves
	// its preferences before closing.
	//
	return theTextControl->Text();
}


// BArchivable functions, for replication. Boring stuff.
// For more information, read the replicant tutorials at 
// http://www.begeek.com/

RunView::RunView(BMessage *data) : BView(data)
{
	// My child views get replicated automagically by the BView
	// methods, but I lose my pointers to them. I can find them
	// again by name:
	//
	theTextControl = (BTextControl *)FindView("runtext");
	theButton = (BButton *)FindView("runbutton");
	
	// read the path archived in the BMessage:
	char *temp = "";
	if (data->FindString("RunView_path", &temp) == B_OK)
		strcpy(thePath,temp);
	
	// replicated view should not resize itself:
	SetResizingMode(B_FOLLOW_NONE);
}

status_t RunView::Archive(BMessage *data, bool deep) const
{
	status_t result = BView::Archive(data,deep);
	if(result == B_OK)
	{
		result = data->AddString("add_on",kAppSig);
		if (result == B_OK)
			result = data->AddString("class","RunView");
		if (result == B_OK)
			// archive the path into the BMessage
			result = data->AddString("RunView_path",thePath);
	}
	return result;
}

BArchivable *RunView::Instantiate(BMessage *data)
{
	if(validate_instantiation(data,"RunView"))
		return new RunView(data);
	else
		return NULL; 
}

void RunView::AboutRequested(void)
{
	BAlert *alert  = new BAlert("",
	"Run version 2.1, by Matt Brubeck, <snoopy@wport.com>. "
	"Lovingly hand-coded in Seattle, WA, USA. Mar 1998", "OK");
	alert->SetShortcut(0,B_ESCAPE);
	alert->Go();
	delete alert;
}