/** starter.cpp
*
*   Start applications (or scripts) based on mime-type and extension,
*   as specified in starter.conf
*
*   Willy Langeveld, may 1999. 
*
**/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


#include <OS.h>
#include <Application.h>
#include <Message.h>
#include <Messenger.h>
#include <Roster.h>
#include <NodeInfo.h>
#include <File.h>
#include <Path.h>
#include <stdarg.h>

#include "parser.hh"

#define STARTERCONF "/boot/home/config/settings/starter.conf"

int MyMain(int argc, char **argv)
{
   if (argc == 1) {
      printf("No arguments.\n");
      return(1);
   }

   FILE *fp = fopen(STARTERCONF, "r");
   if (fp == NULL) {
      printf("Configuration file %s not found\n", STARTERCONF);
      return(2);
   }

   ParsedStream *ps = new ParsedStream(fp);
   fclose(fp);

   ps->parse();

   for (int32 i = 1; i < argc; i++) {
      char *filename = argv[i];

      BFile file(filename, B_READ_ONLY);
      BNodeInfo bn(&file);

      char mimetype[512];
      status_t r = bn.GetType(mimetype);
      if (r != B_OK) {
         printf("Unable to find mime type for file %s\n", filename);
         continue;
      }

      char *extension = strrchr(filename, '.');
      if (extension == NULL) {
         printf("File %s has no extension\n", filename);
         continue;
      }

      ParserToken *tk = ps->firstline();

      int32 found = 0;
      while (tk) {
         tk = ps->first();
         if (tk->match(mimetype)) {
            if (tk = ps->next()) {
               if (tk->match(extension)) {
                  while (tk = ps->next()) {
                     char buffer[1024];
                     sprintf(buffer, tk->get(), filename);
                     system(buffer);
                  }
                  found = 1;
                  break;
               }
            }
         }
         tk = ps->nextline();
      }
      if (found == 0) {
         printf("No entry found for file %s\n", filename);
      }
   }

   delete ps;
   return(0);
}

class StarterApplication : public BApplication {
public:
   StarterApplication() :
      BApplication("application/x-vnd.VL-starter"),
      havearg(0)
   {
      return;
   };

   ~StarterApplication()
   {
      return;
   };

   virtual void RefsReceived(BMessage *message);
   virtual void ArgvReceived(int32 argc, char **argv);
   virtual void ReadyToRun(void);

private:
   int32       havearg;
};

int main(int argc, char **argv)
{
   StarterApplication *my_app = new StarterApplication();
   my_app->Run();
   delete my_app;
   return(0);
}

void StarterApplication::ArgvReceived(int32 argc, char **argv)
{
/*
*   Protect against multiple RefsReceived for the same instance of this
*   application. Shouldn't happen, since it is multiple launch
*/
   if (havearg) return;
   havearg = 1;

   MyMain(argc, argv);
   PostMessage(B_QUIT_REQUESTED);
   return;
}

void StarterApplication::RefsReceived(BMessage *message)
{
   uint32 type; 
   int32 count; 
   entry_ref ref; 
/*
*   Protect against multiple RefsReceived for the same instance of this
*   application. Shouldn't happen, since it is multiple launch
*/
   if (havearg) return;
   havearg = 1;

   message->GetInfo("refs", &type, &count); 
   if (type != B_REF_TYPE) return;
 
   for (long i = --count; i >= 0; i--) { 
      if (message->FindRef("refs", i, &ref) == B_OK) { 
         BEntry entry(&ref); 
         if (entry.IsFile()) {
            char *argv[3];

            app_info ai;
            GetAppInfo(&ai);
            BEntry aentry(&ai.ref);
            BPath apath;
            aentry.GetPath(&apath);
            const char *ap = apath.Path();
            char *acp = new char[strlen(ap) + 1];
            strcpy(acp, ap);
            argv[0] = acp;

            BPath path;
            entry.GetPath(&path);
            const char *p = path.Path();
            char *cp = new char[strlen(p) + 1];
            strcpy(cp, p);
            argv[1] = cp;
            argv[2] = 0;

            MyMain(2, argv);
            delete [] cp;
            delete [] acp;
         } 
      } 
   }
   PostMessage(B_QUIT_REQUESTED);
   return;
}

void StarterApplication::ReadyToRun(void)
{
/*
*   If we didn't get an Argv or Ref on startup, print usage
*   and quit
*/
   if (havearg == 0) {
      havearg = 1;

      char *argv[2];

      app_info ai;
      GetAppInfo(&ai);
      BEntry aentry(&ai.ref);
      BPath apath;
      aentry.GetPath(&apath);
      const char *ap = apath.Path();
      char *acp = new char[strlen(ap) + 1];
      strcpy(acp, ap);
      argv[0] = acp;

      argv[1] = NULL;

      MyMain(1, argv);
      delete [] acp;
      PostMessage(B_QUIT_REQUESTED);
   }
}
