/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "constant.h"
#include "T2SApp.h" 

int main() 
{ 
    T2SApp app ;
    app.Run() ; 
    
    return 0 ; 
}


T2SApp::T2SApp():BApplication( APP_SIGNATURE )
{ 
    BRect frame ;  
    
    frame.Set( 100, 100, 385, 265 ); 
    window = new T2SWindow( frame ); 
    window->Show(); 
} 


void T2SApp::RefsReceived( BMessage *msg )
{
    entry_ref ref;
    uint32    type;
    int32     count;

    msg->GetInfo( "refs", &type, &count ) ;
    if( type != B_REF_TYPE ) return ;                               
                                  
	if( msg->FindRef( "refs", 0, &ref ) != B_OK ) return ;
	BMessage aMessage( B_SIMPLE_DATA ) ;
	aMessage.AddRef( "refs", &ref ) ;

	window->Lock() ;
	BView *view = window->ChildAt( 0 ) ;
    window->Unlock() ;
    window->PostMessage( &aMessage, view ) ;
}
/*
 * End.
 */