/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include <Be.h>
#include <View.h>
#include <FilePanel.h>
#include <Slider.h>
#include <time.h>

#include "T2SView.h" 
#include "constant.h"
#include "T2SWindow.h" 


T2SView::T2SView( BRect frame ) 
    :BView( frame, PGMNAME, B_FOLLOW_ALL, B_WILL_DRAW )
{ 
    conv = new convert() ;
    _initWindow( frame ) ;
}


T2SView::~T2SView()
{
    delete savename ;
    delete conv ;
}


void T2SView::AttachedToWindow() 
{
    rgb_color slideBarColor = { 210, 210, 210 } ;  
    tabstop->SetBarColor( slideBarColor ) ;
    
    rgb_color viewColor = { 200, 200, 250 } ;
    SetViewColor( viewColor ) ; 
} 


void T2SView::_initWindow( BRect frame )
{

    base = new BBox( frame, 
                     "base", 
                     B_FOLLOW_ALL, 
                     B_WILL_DRAW,
                     B_PLAIN_BORDER ) ;

    BRect buttonFrame0( 210, 15, 275, 42 ) ; 
    inputButton = new BButton( buttonFrame0, "beepbutton", BTN0_NAME, 
                               new BMessage( MSG_OPEN_PRESSED ) ) ; 
    AddChild( inputButton ) ; 
    
    BRect buttonFrame10( 210, 50, 275, 77 ) ; 
    outputButton = new BButton( buttonFrame10, "beepbutton", BTN1_NAME, 
                               new BMessage( MSG_SAVE_PRESSED ) ) ; 
    outputButton->SetEnabled( false ) ;
    AddChild( outputButton ) ;    

    BRect buttonFrame20( 210, 89, 275, 116 ) ; 
    exeButton = new BButton( buttonFrame20, "beepbutton", BTN2_NAME, 
                               new BMessage( MSG_EXEC_PRESSED ) ) ; 
    exeButton->SetEnabled( false ) ;
    exeButton->MakeDefault( true ) ;
    AddChild( exeButton ) ;        
    
    BRect buttonFrame30( 210, 126, 275, 153 ) ; 
    dismisButton = new BButton( buttonFrame30, "beepbutton", BTN3_NAME, 
                               new BMessage( MSG_QUIT_PRESSED ) ) ; 
    AddChild( dismisButton );  

    BRect SliderFrame( 4, 15, 187, 30 ) ; 
	tabstop = new BSlider( SliderFrame, "", NULL, 
						   new BMessage( MSG_TABSTOP_SLID ), 
						   TABSTOP_MIN, TABSTOP_MAX ) ; 
	tabstop->SetLimitLabels( TABSTOP_MIN_CHAR, TABSTOP_MAX_CHAR ) ;

    BRect boxFrame0 ( 10, 10, 200, 42 ) ; 
    box0 = new BBox( boxFrame0, "box0" ) ; 
    box0->SetLabel( BOX0_NAME ) ;
    
    BRect rect( 8,11,186,30 ) ;
    inputtext = new BStringView( rect, "textview", "" ) ; 
    inputtext->SetFont( be_bold_font ) ;   
    inputtext->SetFontSize( 14 ) ;  
    box0->AddChild( inputtext ) ; 
    AddChild( box0 ) ; 

    BRect boxFrame10( 10, 45, 200, 77 ) ;  
    box10 = new BBox( boxFrame10, "box10" ) ; 
    box10->SetLabel( BOX1_NAME ) ; 
    
    outputtext = new BStringView( rect, "textview", "" ) ;
    outputtext->SetFont( be_bold_font ) ;   
    outputtext->SetFontSize( 14 ) ;  
	box10->AddChild( outputtext ) ; 
    AddChild( box10 ) ; 
	
    BRect boxFrame20( 10, 80, 200, 153 ) ;   
    box20 = new BBox( boxFrame20, "box1" ) ; 
    box20->SetLabel( BOX2_NAME ) ;
    box20->AddChild( tabstop ) ; 
    AddChild( box20 ) ; 
    AddChild( base ) ;
}


void T2SView::_BAlert( alert_type type, char *msg )
{
    (new BAlert( B_EMPTY_STRING,
            msg,
            "OK",
            NULL,
            NULL,
            B_WIDTH_AS_USUAL,
            type ))->Go() ;   
}


void T2SView::openpanel()
{
    if( openPanel == NULL ){
        openPanel = new BFilePanel ; 
        openPanel->Window()->SetTitle( BTN0_NAME ) ;
    }
    openPanel->Show() ;	
}


void T2SView::savepanel()
{
    if( savePanel == NULL ){
	    savePanel = new BFilePanel( B_SAVE_PANEL,
	                                new BMessenger( this ),
	                                NULL,			               
				                    0,
				                    false ) ;    
        savePanel->Window()->SetTitle( BTN1_NAME ) ;
    } 
    savePanel->Show() ;
}


void T2SView::_setEnableButtons( bool flg )
{
    if( flg == false ){
        inputButton->SetEnabled( flg ) ; 
        outputButton->SetEnabled( flg ) ;
        exeButton->SetEnabled( flg ) ; 
        dismisButton->SetEnabled( flg ) ; 
    } 
    else{
        inputButton->SetEnabled( flg ) ;
        outputButton->SetEnabled( flg ) ; 
        dismisButton->SetEnabled( flg ) ;    
    }  
}


void T2SView::tabstopSlid( BMessage *msg )
{
    tabstop_num = tabstop->Value();
    sprintf( tabstopchar, "%s%d", TABSTOP_LABEL, tabstop_num ) ;
    tabstop->SetLabel( tabstopchar ) ;
}


void T2SView::getOpenfname( BMessage *msg ) 
{
    char openfname[ B_FILE_NAME_LENGTH ] ;
    
   	if( msg->FindRef( "refs", &openref ) != B_OK ) return ;
   	
   	BEntry entry( &openref ) ;
   	if( !entry.Exists() ){
   	    char *errmsg = new char[ strlen( openfname ) + strlen( WARNING ) + strlen( NOT_EXIST ) +1 ] ;
   	    entry.GetName( openfname ) ;
   	    sprintf( errmsg, "%s%s%s", WARNING, openfname, NOT_EXIST ) ;
   	    fprintf( stderr, "%s\n", errmsg ) ;
   	    _BAlert( B_WARNING_ALERT, errmsg ) ;
   	    delete errmsg ;
   	    return ;
   	}
   	retmsg = conv->readSorceFile( &openref ) ;
    if( retmsg != NULL ){
        _BAlert( B_WARNING_ALERT, retmsg ) ;
        return ;
    }
    inputtext->SetText( openref.name ) ;
    outputButton->SetEnabled( true ) ;
}


void T2SView::getSavefname( BMessage *msg ) 
{
    char *sn ;

    msg->FindString( "name", &sn ) ;
    if( savename ) delete savename ;
    savename = new char[ strlen( sn ) +1 ] ;
    strcpy( savename, sn ) ;
    
    msg->FindRef( "directory",  &saveref ) ;
    outputtext->SetText( savename ) ;
    exeButton->SetEnabled( true ) ;   
}


void T2SView::resetSaveFname()
{
    outputtext->SetText( NULL ) ;
    exeButton->SetEnabled( false ) ;   
}


void T2SView::convertTab()
{
    retmsg = conv->createSaveFile( &saveref, savename ) ;
    if( retmsg != NULL ){
        goto ERROR ;
    }
   	_setEnableButtons( false ) ;
    conv->tabTospace( tabstop_num ) ;
    _BAlert( B_INFO_ALERT, COMPLET ) ;
    _setEnableButtons( true ) ;
  
    retmsg = conv->saveclose() ;
    if( retmsg != NULL ){
        goto ERROR ;
    }   
    return ;
    ERROR:
        _BAlert( B_WARNING_ALERT, retmsg ) ;
        return ;
}


short T2SView::retTabstop()
{
    return tabstop_num ;
}


void T2SView::setTabstop( short tb_num )
{
    tabstop_num = tb_num ;
    if( tabstop_num  < 1 || tabstop_num > 10 )
        tabstop_num = 4 ;
    if( tabstop != NULL ){
        sprintf( tabstopchar, "%s%d", TABSTOP_LABEL, tabstop_num ) ;
        tabstop->SetValue( tabstop_num ) ;
        tabstop->SetLabel( tabstopchar ) ;
    }
}
/*
 * End.
 */
