/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include <stdio.h>
#include <string.h>
#include "constant.h"
#include "tab2sp.h"

t2s::t2s()
{
    onechar  = ( char )NULL ;
    position = 0 ;
    internalDestbuff = NULL ;
}


t2s::~t2s()
{
    onechar  = ( char )NULL ;
    position = 0 ;
    if( internalDestbuff ) delete internalDestbuff ;
    internalDestbuff = NULL ;
}


int t2s::tabtospace( FILE *out,       /* Out */ 
                     FILE *in,        /* In  */
                     const int   tab_stop ) /* In  */
{
    register int  need_sp_num ;
    
    position = 0 ;
    for( onechar = fgetc( in ); feof( in ) == 0; onechar = fgetc( in ) ){
        switch( onechar ){
            case TAB :
/*
                tab_pos = ( position / tab_stop +1 ) * tab_stop ;
                need_sp_num =tab_pos - position ;
 */
                need_sp_num = tab_stop - ( position % tab_stop ) ;
                while( need_sp_num-- > 0 ) fputc( ( int )SP, out ) ;
//              position = 0 ;
                continue ;
            case CR :
            case LF :
                position = 0 ;
                break ;
            default :
                position++ ;
                break ;
        }/* switch end */
        fputc( ( int )onechar, out ) ;
        if( ferror( out ) ){
            return 1 ;
        } 
    }
    return 0 ;
}


int t2s::tabtospace( FILE *out,             /* Out */ 
                     const char  src[],     /* In  */
                     const int   srclen,    /* In  */
                     const int   tab_stop ) /* In  */
{
    register int cur ;
    register int  need_sp_num ;

    outcharc = 1 ;
    position = 0 ;
    for( cur = 0; cur < srclen; cur++ ){
        onechar = src[ cur ] ;
        switch( onechar ){
            case TAB :
                fwrite( outchar, 1, outcharc -1, out ) ;
                outcharc = 1 ;
            
                need_sp_num = tab_stop - ( position % tab_stop ) ;
                memset( sparry, SP, need_sp_num ) ; 
                fwrite( sparry, 1, need_sp_num, out ) ;
                position++;
                continue ;
            case CR :
            case LF :
                position = 0 ;
                break ;
            default :
                position++ ;
                break ;
        }/* switch end */
        if( (outcharc % OUTPUT_CHARS) ){
            outchar[ outcharc -1 ] = onechar ;
            outcharc++ ;
            continue ;
        }
        fwrite( outchar, 1, outcharc -1, out ) ;
        outcharc = 1 ;
    }
    fwrite( outchar, 1, outcharc -1, out ) ;
    return 0 ;
}


int t2s::tabtospace(       char  dest[],    /* Out */ 
                     const char  src[],     /* In  */
                     const int   srclen,    /* In  */
                     const int   tab_stop ) /* In  */
{
    register int cur ;
    register int destc ;
    register int  need_sp_num ;
//    int buffsize ;

    destc = 0 ;
    position = 0 ;
    for( cur = 0; cur < srclen; cur++ ){
        onechar = src[ cur ] ;
        switch( onechar ){
            case TAB :
/*
                tab_pos = ( position / tab_stop +1 ) * tab_stop ;
                need_sp_num =tab_pos - position ;
 */
                need_sp_num = tab_stop - ( position % tab_stop ) ;
                while( need_sp_num-- > 0 ){
                    dest[ destc ] = SP ;
                    destc++ ;
                }
                position = 0 ;
                continue ;
            case CR :
            case LF :
                position = 0 ;
                break ;
            default :
                position++ ;
                break ;
        } /* switch end */
        dest[ destc ] = onechar ;
        destc++ ;
    }

    dest[ destc ] = ( char )NULL ;
    return 0 ;
}


int t2s::_getinterbuffsize( char src[], int tab_stop )
{
    static int buffsize ;
    register int cur ;

    buffsize = 0 ;
    cur = 0 ;
    while( src[ cur ] != ( char )NULL ){
        if( src[ cur ] == TAB ) buffsize += tab_stop ;
        else                    buffsize++ ;
        cur++ ;
    }

    printf( "BUFFSIZE[%d]\n", buffsize ) ;
    return buffsize ;
}
/*
 * End.
 */