#include <stdio.h>
#include <string.h>
#include <SupportKit.h>

#define ec(x) {#x, B_##x##_CONVERSION}

struct encoding {
	char *name;
	uint32 code;
} codes[] = {
	ec(ISO1),ec(ISO2),ec(ISO3),ec(ISO4),ec(ISO5),ec(ISO6),ec(ISO7),
	ec(ISO8),ec(ISO9),ec(ISO10),
	ec(MAC_ROMAN),ec(SJIS),ec(EUC),
	ec(JIS),ec(MS_WINDOWS),ec(UNICODE),ec(KOI8R),ec(MS_WINDOWS_1251),
	ec(MS_DOS_866),
	{0, 0}  // must be last item
};

#define USAGE "\
USAGE: utf8_to_ascii [-c ascii_encoding] file\n\
if file is - standard input will be used\n\
-c define ascii encoding which can be: "

uint32 read_encoding(char *);
void print_usage(void);

uint32 encoding = codes[0].code;

int main(int argc, char **argv)
{

	if (argc > 1 && !strcmp(argv[1], "-c")) {
		argv += 2, argc -= 2;
		encoding = read_encoding(argv[0]);
		if (encoding == (uint32)-1) {
			fprintf(stderr, "Invalid encoding %s\n", argv[0]);
			print_usage();
			return -1;
		}
	}	

	if (argc < 2) {
		print_usage();
		return -1;
	}
	
	FILE *fp;
	int32 srclen, destlen;
	char readbuffer[1024], writebuffer[1024];
	
	if (strcmp(argv[1], "-"))
		fp = fopen(argv[1], "rb"); // open in binary mode
	else
		fp = stdin;
		
	if (!fp) {
		fprintf(stderr, "file %s not found\n", argv[1]);
		return -1;
	}
	
	while (1) {
		int32 state = 0;
		fgets(readbuffer, 1024, fp);
		if (feof(fp)) break;
		srclen = strlen(readbuffer);
		destlen = 1024;
	#ifdef TO_UTF
		convert_to_utf8(encoding, readbuffer, &srclen, 
			writebuffer, &destlen, &state);
	#else
		convert_from_utf8(encoding, readbuffer, &srclen, 
			writebuffer, &destlen, &state);
	#endif
		writebuffer[destlen] = 0;
		printf("%s", writebuffer);	
	}	
	
	if (fp != stdin)	
		fclose(fp);
		
	return 0;
}


uint32 read_encoding(char *en)
{
	int i;
	for (i = 0; codes[i].name; i++)
		if (!strcasecmp(codes[i].name, en))
			return codes[i].code;
		
	return (uint32)-1;
}

void print_usage(void)
{
	fprintf(stderr, USAGE);
	int i = 0;
	for (i = 0; codes[i].name; i++)
		fprintf(stderr, "%s ", codes[i].name);
	fprintf(stderr, "\nDefaults to %s\n", codes[0].name);
}