#include <stdio.h>
#include "basics.h"	/* fatal(), pfopen, my_fopen() */
#include "psearch.h"    /* search_file() */
#include "cfg.h"        /* read_cfg(), cfg_value() */
#include "psinfo.h"     /* psfont(), ps2pk_args() */


main(int argc, char *argv[]) {
   char *res = NULL, *mode = NULL, *mapinfo, *psname, args[80], *texfont;
   int dpi;

   if (argc != 2)
      fatal("Usage: psargs texfont\n");

   texfont = argv[1];
   pfopen = my_fopen;

   if (read_cfg(res, mode))
      fatal("No default printer data available in mtpk.cfg\n");
   
   if (psname = psfont(texfont, &mapinfo)) {
      ps2pk_args(mapinfo, args);
      dpi = atoi(cfg_value("res"));
      printf("ps2pk -X%d %s%s %s.%dpk\n", dpi, args, psname, texfont, dpi);
   }
   else
      printf("No map info for %s\n", texfont);

   exit(0);
}
