//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “ViewTxt.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A HTML-Viewing module
*/
//====//====//====//====//====//====//====//====//====//====//

#include "ViewBase.h"
#include "NTree.h"
#include "Hash.h"
#include "Schemes.h"
#include "Utils.h"
#include "UBuffer.h"
#include "Yate.h"
#include "cb_list.h"

#include <View.h>
#include <Region.h>

#include <stdio.h> //sprintf
#include <string.h> //sprintf

void ViewBase::DrawHTML(BRect dest,float tlx,float tly){
	int isbold=0,wasbold=0,uline=0;
	int isital=0,wasital=1,ndspace=0;
	float nfs=15,ofs=-1,spcwid;	
	float ulx,uly=-1;
	float ysp=20;
	char spa[256],sha[256*4];

	CList *SizeList=new CList();

	vv->SetDrawingMode(B_OP_COPY);
	vv->SetHighColor(0,0,0,255);
	vv->SetLowColor(255,255,255,255);
	vv->FillRect(dest,B_SOLID_LOW);

	int vmax=nt->Size()-1;

	int p0=1,intag=FALSE;
	float yy=0,xx=4;
	while (p0<vmax){
		int p1=p0+16;
		p1=BND(p1,1,vmax);
	
		int ll=nt->Fetch(spa,p1-p0,p0);
		char *fin=spa+ll;
		int spc=FALSE;
		char *src=spa-1,*dst=sha;
		while (++src<fin){

			if (src==spa+14){
				p1+=200-16;
				p1=BND(p1,1,vmax);
				ll+=nt->Fetch(spa+16,p1-p0-16,p0+16);
				fin+=ll;
			}

			if (*src<=(intag?31:32)){
				if (dst==sha){
					continue;
				}else{
					break;
				}
			}
			if (*src=='<'){
				if (dst!=sha){break;}else{intag=TRUE;}
			}

			*dst++=*src;
			if (*src=='>'){src++;break;}
		}
		
		if (dst>sha){
			if (intag){
				*dst=0;
				int hand=FALSE;
				char *mss=sha;
				int offt=FALSE;
				if (sha[1]=='/'){mss++;offt=TRUE;}
				{
					char cc=mss[1];
					if (cc>='a' && cc<='z')mss[1]+='A'-'a';
				}

				if (strcasecmp(sha,"<BR>")==0){
					xx=4;yy+=20;hand=TRUE;
				}
				if (mss[1]=='A'){
					if (offt){
						vv->SetHighColor(0,0,0,255);
						uline&=(~1);
					}else{
						vv->SetHighColor(0,0,255,255);
						uline|=1;
					}
					hand=TRUE;
				}
				if (mss[1]=='B' && mss[2]=='>'){isbold=!offt;hand=TRUE;}
				if (mss[1]=='I' && mss[2]=='>'){isital=!offt;hand=TRUE;}
				if (mss[1]=='H' && mss[3]=='>'){
					float fs=15;
					if (offt){
						int ct=SizeList->Num()-1;
						fs=SizeList->Item(ct);
						SizeList->RemIndex(ct);
						if (fs>6){
							nfs=fs;
							hand=TRUE;	
						}
					}else{
						switch(sha[2]){
							case '1':fs+=6;break;
							case '2':fs+=5;break;
							case '3':fs+=4;break;
							case '4':fs+=3;break;
							case '5':fs+=2;break;
						}
						if (fs!=15){
							SizeList->Add(nfs);
							nfs=fs;
							hand=TRUE;
						}
					}
					if (hand){
						xx=4;
						yy+=ysp;
					}
				}
				if (strcasecmp(sha,"<HR>")==0){
					hand=TRUE;
					yy+=ysp;xx=4;
					vv->StrokeLine(BPoint(4-tlx,yy-tly),BPoint(width-4-tlx,yy-tly),B_SOLID_HIGH);
					yy+=4;
				}
				if (strcasecmp(sha,"<TR>")==0){
					xx=4;yy+=ysp;hand=TRUE;
				}
				if (mss[1]=='P' && mss[2]=='>'){
					xx=4;yy+=ysp;hand=TRUE;
				}
				if (mss[1]=='L' && mss[2]=='I' && mss[3]=='>'){
					xx=4;yy+=ysp;hand=TRUE;
				}
				if (!hand){
//					printf("%s\n",sha);
				}
			}else{
				if (nfs!=ofs || isbold!=wasbold || isital!=wasital){
					ofs=nfs;
					wasbold=isbold;
					BFont mf(isbold?be_bold_font:be_plain_font2);	
					if (isital){
						font_family fam;
						font_style sty;
						mf.GetFamilyAndStyle(&fam,&sty);
						strcpy(sty,"Italic");
						mf.SetFamilyAndStyle(fam,sty);
					}
					mf.SetSize(nfs);
					vv->SetFont(&mf);
					ysp=nfs*1.3;
					spcwid=vv->StringWidth(" ");
				}
				float ww=vv->StringWidth(sha,dst-sha);
				float nx=xx+ww;
				if (nx>width-4){xx=4;nx=xx+ww;yy+=ysp;}

				if (yy-tly+nfs+ysp>=dest.top){
					vv->DrawString(sha,dst-sha,BPoint(xx-tlx,yy-tly+nfs));
					if (uline){
						if (uly!=yy){ulx=xx;}
						vv->StrokeLine(BPoint(ulx-tlx,yy-tly+nfs+1.0),BPoint(nx-tlx,yy-tly+nfs+1.0));
						ulx=nx;uly=yy;
					}else{
						uly=-1;
					}
				}
				xx=nx+spcwid;
				if (dst[-1]=='.'){
					xx+=spcwid;
				}
			}
		}
		if (dst[-1]=='>')intag=FALSE;
//		if (*src==10 || *src==13){intag=FALSE;}
		p0+=src-spa;
		if (yy-tly>dest.bottom)break;
	}

	delete(SizeList);
}

