//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “Yate.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	The fabled YateWindow class in all its Glory.
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef YATE_WINDOW_H

	#define YATE_WINDOW_H

	#include <Rect.h>
	#include <Window.h>
	#include <TextView.h>

	class BMenu;
	class BMenuBar;
	class BMenuItem;
	class BFilePanel;
	class BSBar;

	class BMapView;
	class StatusView;



	class YateWindow : public BWindow {

	public:
						YateWindow(BRect frame,class Buff *);
						virtual ~YateWindow();
		virtual bool    QuitRequested();
		virtual void    MessageReceived(BMessage *msg);
		virtual void    MenusBeginning();
		virtual void    ScreenChanged(BRect screen_size, color_space depth);
		void            ChangeBuff(Buff*);
		Buff*           MyBuff(){return(cb);}

		void            MyMetrics();
		void            Shove(BView *,BRect pl);
		void            FixDisp();

		void            MoveCurs(int cx,int cy);
		int32           mycurs;//for errors.. fixme :-)
		void            HandleFontDrop(BMessage *msg);

		StatusView      *sview;
	private:
		friend class StatusView;
		Buff            *cb;
		BMapView        *myview;
		long            KeyDown(BMessage *msg);
		//void            ChangeFont(BMessage*); using fontdrop now..
		void            GotoLine(BMessage *);
		int32           wincnt;
		int32           IsHScroll,IsMsg;

		BSBar           *scbh,*scbv;

		BMenu           *MenuFrom(struct MenIt *mi);
		void            CreateMenus(BMenu  *);

		BMenu           *topmenu;

		BMenu           *fname,*fstyle,*fsize;
		BMenu           *mback,*mdir,*mwin;
		BMenu           *mdoc,*medit1,*medit2,*mdoclist;
		BMenu           *mmime,*mcurs,*mview,*menc;
		BMenuItem       *icurs,*iback,*ifname,*ifstyle,*ifsize;
		BMenuItem       *idir,*imime,*iview;

		BMenuItem       *mnxt,*mprv;
		BList           bmen,fnl,fsl;

		thread_id       drth;
		port_id         drprt;

		char            oldtitle[1024];

		void            DoMenuFontName();
		void            DoMenuFontSize();
		void            DoDocList();
		void            DoNextError(BMessage *);

		BRect       rmyview,rssv,rsbh,rsbv;

		void Fumble(BMenu *top,BMenuItem **mi,BMenu **mn,MenIt *mit);
		friend class YateApplication;
	};

	class STextView:public BTextView{
		public:
					STextView(BRect frame,const char *name,uint32 flags,long msg);
			virtual void KeyDown(const char *bytes, int32 numBytes);
			virtual void Draw(BRect);
			virtual void MakeFocus(bool focusState = TRUE);

	   private:
			long mymsg;
	};

	class StatusView : public BView {
		public:
			StatusView(BRect rect, char *name,port_id pp);
			virtual ~StatusView();
			virtual void Draw(BRect);
			BRect       xpos,ypos,spos,rpos,mpos;
			void    SetPos(int xx,int yy);
			void    SetSearch(const char *);
			void    SetReplace(const char *);
			void    ShowMsg(const char *m);
			STextView   *xrv,*yrv,*srv,*rrv,*mrv;
			void MyNav(STextView *,int dir);

		private:
			int cvx,cvy;
	};

#endif



