/* CoPyRiGhT=(c) Novell, Inc. 1994. All Rights Reserved. */
/* VeRsIoN=0.01 */
/* Emulate DOS version of SELECT.EXE */
  G.!Debug=0
 
  /* Get my messages */
  MsgFile='SELECT.MSG'
  Do i=1 While(Lines(MsgFile)>0)
    G.!MSG.i=LineIn(MsgFile)
  End
  G.!MSG.0=i-1
  Call CloseFile(MsgFile)
  If G.!MSG.0=0 then do
    Say 'Unable to open' MsgFile
    Return(255)
  End
 
  /* Load IBM OS/2 function package */
  Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
  if RxFuncQuery('SysLoadFuncs') \=0 then ,
    return(Err(2,'RxFuncAdd','SysLoadFuncs','REXXUTIL'))
  Call SysLoadFuncs
 
  G.!DAT.!HighWater=0
  G.!DAT.0=0
  G.!Language=0
  G.!Lang.0=0
  G.!Product=0
 
  /* Process Paramaters passed in */
  Parse Arg G.!FileName G.!Parms
  If G.!FileName='' | G.!FileName='.' then G.!FileName='SELECT'
  G.!FileName=TransFileName(G.!FileName)
  i=LastPos('\',G.!FileName)
  If i\=0 then Do
    G.!FilePath=Left(G.!FileName,i-1)'\'
    G.!FileName=SubStr(G.!FileName,i+1)
  End
  Else G.!FilePath=''
  Parse Var G.!FileName G.!FileName'.'  /* Ignore .EXT */
 
  /* Read in FileName.DAT */
  rcc=GetFile(G.!FilePath||G.!FileName'.DAT')
  if rcc\=0 then return(255)
 
  Call ParseFile 1  /* go extract stuff from the file */
 
  If Symbol('G.!TAG.0.0.!LNGPATH')=='VAR' then LngPath=G.!TAG.0.0.!LNGPATH
  Else LngPath='..\'
  LngPath=FixPath(LngPath)
 
  If Symbol('G.!TAG.0.0.!PRDPREPATH')=='VAR' then PrdPrePath=G.!TAG.0.0.!PRDPREPATH
  Else PrdPrePath='..\'
  PrdPrePath=FixPath(PrdPrePath)
 
  If Symbol('G.!TAG.0.0.!PRDPOSTPATH')=='VAR' then PrdPostPath=G.!TAG.0.0.!PRDPOSTPATH
  Else PrdPostPath='..\'
  PrdPostPath=FixPath(PrdPostPath)
 
 
 
  Call GetFiles LngPath,G.!FileName'.LNG'
 
  Call ParseFile 2  /* go extract stuff from the file */
 
 
  Lang=GetLang()
  If Lang>0 then Do
    ToDo=GetProd(Lang,PrdPrePath,PrdPostPath)
    If ToDo\='' then do
      Call SysCls
      Do 5;Say;End
      Parse Var ToDo Path '0'x Program '0'x RParam
      Parse Var Path ','Path
      Path=StripQuotes(Path)
      Parse Var Program ','Program
      Program=StripQuotes(Program)
      Parse Var RParam ','RParam
      RParam=StripQuotes(RParam)
If G.!Debug then do
      Say 'Path='Path
      Say 'Pgm ='Program
      Say 'Parm='RParam
End
      CurDir=Directory()
      NewDir=Directory(Path)
      'CALL' Program RParam G.!Parms
      CurDir=Directory(CurDir)
    End
  End
  Return(255)
 
 
GetProd: Procedure Expose G. /* Get a Product */
  Parse Arg Lang,PrdPrePath,PrdPostPath
 
  LangName=G.!TAG.Lang.0.!VLANGUAGE
  Call GetFiles PrdPrePath,PrdPostPath||LangName'\'G.!FileName'.PRD'
  Call ParseFile 3  /* go extract stuff from the file */
 
  i=1
  If G.!Product>1 Then Do
    Do Forever
if G.!Debug then Say 'GetProd'
else ,
      Call SysCls
      Do 5;Say;End
      Say G.!TAG.Lang.0.!TITLE1
      Do i=1 to G.!Product
        Say " " i".->" G.!TAG.Lang.i.!MENU1
      End
      Pull i
      If i='' then leave
      If DataType(i,'W') then ,
        If i>0 & i<=G.!Product then leave
    End
  End
  If i='' then return('')
  If Symbol('G.!TAG.'Lang'.'i'.!RPARAM')=='VAR' then ,
    RParam=G.!TAG.Lang.i.!RPARAM
  Else RParam=''
  If Symbol('G.!TAG.'Lang'.'i'.!PATH')=='VAR' then ,
    Path=G.!TAG.Lang.i.!PATH
  Else Path=''
  Program=G.!TAG.Lang.i.!PROGRAM
Return(Path '0'x Program '0'x RParam)
 
GetLang: Procedure Expose G. /* Get a Language */
 
  SNWL=Value('SNWL',,'OS2ENVIRONMENT')
  Do i=1 to G.!Lang.0
    LangNum=G.!Lang.i
    Lang=G.!TAG.LangNum.0.!VLANGUAGE
    If SNWL=Translate(Lang) then leave
  End
  If i>G.!Lang.0 then do
    i=G.!Lang.0
    If i>1 then Do Forever
if G.!Debug then Say 'GetLang'
else ,
      Call SysCls
      Do 5;Say;End
      Do i=1 to G.!Lang.0
        Lang=G.!Lang.i
        Say " " i".->" G.!TAG.Lang.0.!MENU
      End
      Pull i
      If i='' then leave
      If DataType(i,'W') then ,
        If i>0 & i<=G.!Lang.0 then leave
    End
  End
  If i='' then i=0
  if i>0 then do
    LangNum=G.!Lang.i
    Lang=G.!TAG.LangNum.0.!VLANGUAGE
    SNWL=Translate(Lang)
    Call Value 'SNWL',SNWL,'OS2ENVIRONMENT'
    Call Value 'NWLANGUAGE',SNWL,'OS2ENVIRONMENT'
  End
  Else LangNum=0
Return(LangNum)
 
FixPath: Procedure Expose G. /* fixup path */
  Parse Arg Path
  If Path='' then Path='.'
  Path=TransFileName(Path)
  If Path='' then Path='.'
  If Right(Path,1)==':' Then Path=Path'.'
  If Right(Path,1)\=='\' Then Path=Path'\'
Return(Path)
 
GetFiles: Procedure Expose G.  /* Find and readin all associated files */
  Parse Arg Path,FileName
 
  Lang.0=0
  Call SysFileTree Path'*.*','LANG.','D'
  Do i=1 to Lang.0
    Parse Var Lang.i . . . . Language
    j=LastPos('\',Language)
    If j\=0 then Language=SubStr(Language,j+1)
    j=LastPos(':',Language)
    If j\=0 then Language=SubStr(Language,j+1)
    ThisFile=Path||Language'\'FileName
    If Left(Language,1)\=='_' then Call GetFile(ThisFile)
  End
Return(0)
 
 
GetFile: Procedure Expose G.  /* read in a file */
  Parse Arg FileName
  start=G.!DAT.0
  Do i=start+1 While(Lines(FileName))
    G.!DAT.i=Translate(LineIn(FileName),' ','09'x)
    If G.!DAT.i='' then i=i-1 /* ignore blank lines */
    If Left(Word(G.!Dat.i,1),1)==';' then i=i-1 /* ignore comments */
  End
  G.!DAT.0=i-1
  Call CloseFile FileName
  If G.!DAT.0=start & Symbol('G.!DAT.'i)\='VAR' Then do
    Call SayMsg 31,FileName /* Could not open xxx */
    Return(255)
  End
Return(0)
 
ParseFile: Procedure Expose G.  /* parse input file */
  Parse Arg Pass
  l=G.!Language
  p=G.!Product
  Do i=G.!DAT.!HighWater+1 to G.!DAT.0
if 0 then say G.!DAT.i
    Parse var G.!DAT.i Tag ':' TagValue
    Tag='!'Translate(Tag)
    TagValue=Strip(TagValue)
    If Symbol(Tag)\=='BAD' then Select
      When Tag=='!VLANGUAGE' then do /* NWLANGUAGE name */
        Parse Var TagValue Num','TagValue
        If Symbol('G.'Num)\=='BAD' then do
          l=Num
          G.!Language=l
          G.!TAG.l.0.Tag=StripQuotes(TagValue)
if G.!Debug then say 'G.!TAG.'l'.0.'Tag'='G.!TAG.l.0.Tag
          j=G.!Lang.0+1
          G.!Lang.0=j
          G.!Lang.j=l
        End
      End
      When Tag=='!LANGUAGE' then do   /* Language of following stuff */
        If Symbol('G.'TagValue)\=='BAD' then do
          G.!Language=TagValue
          G.!Product=G.!Product+1
          l=TagValue
          p=G.!Product
        End
      End
      OtherWise do
        G.!TAG.l.p.Tag=StripQuotes(TagValue) /* Something else */
if G.!Debug then say 'G.!TAG.'l'.'p'.'Tag'='G.!TAG.l.p.Tag
      End
    End
  End
  G.!DAT.!HighWater=G.!DAT.0
if G.!Debug then pull .
Return
 
StripQuotes: Procedure Expose G. /* throw away quotes */
  Parse Arg Tag
  Tag=Strip(Tag)
  If Left(Tag,1)='"' | Left(Tag,1)=="'" then ,
    Tag=SubStr(Tag,2,Length(Tag)-2)
Return(Tag)
 
CloseFile: Procedure Expose G.  /* Close a File */
  Parse Arg FileName
Return(Stream(FileName,'COMMAND','CLOSE'))
 
TransFileName: Procedure Expose G. /* Fixup FileName */
  Parse Arg FileName
Return(Translate(FileName,'\','/'))
 
SayMsg: Procedure Expose G. /* Say the message */
  Parse Arg MsgNum,P1,P2,P3
  ThisMsg=GetMsg(MsgNum,P1,P2,P3)
  Do While(ThisMsg\='')
    i=LastPos(' ',ThisMsg,70)
    If Length(ThisMsg)<=70 then i=0
    if i=0 then i=70
    cr=Index(ThisMsg,'0D'x)
    if cr=0 then cr=Length(ThisMsg)
    i=Min(i,cr)
    Say Left(ThisMsg,i)
    ThisMsg=SubStr(ThisMsg,i+1)
  End
Return(0)
 
GetMsg: Procedure Expose G. /* Get the message and do substitutions */
  Parse Arg MsgNum,P1,P2,P3
  If MsgNum>G.!MSG.0 then Return('')
  ThisMsg=G.!MSG.MsgNum
  Do i=1 to 3
    x=Index(ThisMsg,'%'i)
    if x=0 then iterate
    ThisMsg=Left(ThisMsg,x-1)||Arg(i+1)||SubStr(ThisMsg,x+2)
  End
  OutMsg=''
  Do Until (X=0)
    Repl=''
    X=Index(ThisMsg,'\')
    If x=0 then iterate
    OutMsg=OutMsg||Left(ThisMsg,x-1)
    y=Translate(SubStr(ThisMsg,x+1,1))
    ThisMsg=SubStr(ThisMsg,x+2)
    Select
      When y='N' then Repl='200D0A'x
      When y='\' then Repl='\'
      Otherwise Repl=y
    End
    OutMsg=OutMsg||Repl
  End
  OutMsg=OutMsg||ThisMsg
 
Return(OutMsg)
 
Err:Procedure Expose G. /* Display an error message */
  Parse arg ErrNum,P1,P2,P3
  Call SayMsg ErrNum,P1,P2,P3
Return(ErrNum)
 
Index:Procedure
  Parse Arg HayStack,Needle,Start
  If \DataType(Start,'W') then Start=1
  If Start<1 then Start=1
  Len=Length(Needle)
  If Len=0 then Return(1)
  Do i=Start to Length(HayStack)
    If SubStr(HayStack,i,Len)==Needle then Return(i)
  End
Return(0)
