'[PROCEDURE]
'Purpose = This procedure creates a popup menu for attached servers.
'[PARAM1]
'Purpose = The menu title.
'Type = String
'Default = " Attached Server List "
'[RETURN]
'Purpose = Returns an object with the attributes ITEM,NUMBER,KEY,ERROR.
'Type = Object
'ITEM is a string that has the selected item.
'NUMBER has the selected item Connection number.
'KEY is the key that the user pressed to exit the menu.
'ERROR is the error number.
'[EXAMPLE]
'ServObj = RPC:Call("","SERVPICK.BAS"," You are attached to the following servers: ")
'If (ServPick.Error = 0)
'   Print("The selected server is: ",ServObj.Item); Newline
'   Print("The connection ID is  : ",ServObj.Number); Newline
'   Print("The key is: ",ServObj.Key); Newline
'EndIf

#include "KEY.H"
#include "SYS.H"

Local("Msg","Window1","choice1","MsgLen","object1","ReturnObject","Con")
Local("ServerName")
Msg = Param(1," Attached Server List ")

If (MATH:Mod(STR:Length(Msg),2) != 0) & (STR:Length(Msg) < 74)
   Msg = " " + Msg
EndIf

MsgLen = STR:Length(Msg)
If (MsgLen < 40)
   Msglen = 40
EndIf
If (MsgLen <= 74)
   Window1 = WIN:Menu:Define(8,38 - MsgLen / 2)
   WIN:Title(Msg)
Else
   MsgLen = 74
   Window1 = WIN:Menu:Define(8,38 - MsgLen / 2)
   WIN:Title(STR:Sub(Msg,1,74))
EndIf

Con = 0
Do While (Con < 8)
   ServerName = NET:Server:Name(Con)
   If (ServerName != NULL)
      WIN:Menu:Item:Add(STR:Pad:Right(STR:Sub(ServerName,1,40),40) + STR:Pad:Right(DATA:String(Con),3))
   EndIf
   Con = Con + 1
EndDo

Choice1 = WIN:Menu:Start()

If (Choice1 = 0)
   ReturnObject = OBJECT:Make("ERROR",1) + OBJECT:Make("Item","") + OBJECT:Make("Number","-1") + OBJECT:Make("KEY","")
Else
   ReturnObject = OBJECT:Make("ERROR",0) + OBJECT:Make("Item",STR:Trim:All(STR:Sub(WIN:Menu:Item:Name(Choice1),1,40))) + OBJECT:Make("Number",STR:Sub(WIN:Menu:Item:Name(Choice1),40,3)) + OBJECT:Make("KEY",DATA:String(KEY:Last))
EndIf

WIN:Close()
Return(ReturnObject)

