' (C) Copyright 1993-1996 HITECSOFT CORP. All rights reserved.

Sub DoCopy
Print("From: ",Param(1)); NewLine
Print("To  : ",Param(2))

If (DIR:File:Copy(Param(1),Param(2)))
   Print(" ....Copy OK. Size(",SYS:Error:Number,")")
Else
   Print(" ....Copy failed!")
   ERROR = True
EndIf

NewLine
NewLine
Return(True)

End Sub
Sub Find1st
Local("TempO","Server")

TempO = Param(1)
DirO = DIR:File:First(Source)
Do While ((DirO.Error = 0) & (DirO.Type != "FILE"))
   DirO = DIR:File:Next(DirO)
EndDo
If (DirO.Error != 0)
   ERROR = True
   Return("")
EndIf
If (TempO.Server.Name != "")
   Server = TempO.Server.Name + "/"
Else
   Server = ""
EndIf

Return(Server + TempO.Volume.Name + TempO.Path + DirO.Name + "." + DirO.Extension)


End Sub
Sub FindNext
Local("TempO","Server")

TempO = Param(1)
DirO = DIR:File:Next(DIRO)
Do While (DirO.Error = 0)
   If DirO.Type = "FILE"
      Exit
   EndIf
   DirO = DIR:File:Next(DirO)
EndDo

If (DirO.Error != 0)
   ERROR = True
   Return("")
EndIf

If (TempO.Server.Name != "")
   Server = TempO.Server.Name + "/"
Else
   Server = ""
EndIf

Return(Server + TempO.Volume.Name + TempO.Path + DirO.Name + "." + DirO.Extension)

End Sub
Sub main

If (SYS:Param:Count < 3)
   NewLine
   Print("Usage:"); NewLine
   Print(SYS:Param(1)," [SERVER/][VOLUME:][PATH\]Source [SERVER/][VOLUME:][PATH\]Destination")
   NewLine
   Return
EndIf
ERROR = False
source = SYS:Param(2)
dest = SYS:Param(3)

If (SingleFileCopy(SOURCE,DEST))
   Quit
EndIf

SourceO = DIR:Object(Source)
SourceFullPath = Find1st(SourceO)
If (ERROR)
   Print("File not Found!"); NewLine
   Return
EndIf


Do While (!ERROR)
   
   SourceO = DIR:Object(SourceFullPath)
   DestO = DIR:Object(dest)
   
   If (DestO.File.Name = "*")
      DestO.File.Name = SourceO.File.Name
      If (DestO.File.Extension = "*")
         DestO.File.Extension = SourceO.File.Extension
      EndIf
   EndIf
   
   If (DestO.Server.Name != "")
      Server = DestO.Server.Name + "/"
   Else
      Server = ""
      DestO.Path = ""
   EndIf
   If ((DestO.File.Extension != "*") & (DestO.File.Extension != ""))
      FileName = DestO.File.Name + "." + DestO.File.Extension
   Else
      FileName = DestO.File.Name
   EndIf
   
   DestFullPath = Server + DestO.Volume.Name + DestO.Path + FileName
   
   DoCopy(SourceFullPath,DestFullPath)
   
   SourceFullPath = FindNext(SourceO)
   If (ERROR)
      Return
   EndIf
   
EndDo

End Sub
Sub SingleFileCopy
Local("SOURCEO","DESTO","SERVER","FILENAME","DESTFULLPATH")

SOURCE = Param(1)
DEST = Param(2)

SourceO = DIR:Object(SOURCE)
DestO = DIR:Object(dest)
If ((SOURCEO.FILE.NAME = "*") | (SOURCEO.FILE.EXTENSION = "*"))
   ' OK SOURCE FILE HAS WILD CHAR SO RETURN FALSE
   Return(False)
EndIf

If (DestO.File.Name = "*")
   DestO.File.Name = SourceO.File.Name
   If (DestO.File.Extension = "*")
      DestO.File.Extension = SourceO.File.Extension
   EndIf
EndIf

If (DestO.Server.Name != "")
   Server = DestO.Server.Name + "/"
Else
   Server = ""
EndIf
If ((DestO.File.Extension != "*") & (DestO.File.Extension != ""))
   FileName = DestO.File.Name + "." + DestO.File.Extension
Else
   FileName = DestO.File.Name
EndIf

DestFullPath = Server + DestO.Volume.Name + DestO.Path + FileName

DoCopy(Source,DestFullPath)

Return(True)
End Sub
