/*******************************************************************************
**
** (c) Copyright 1995 - 1996 Novell, Inc.  All rights reserved.
**
**      File:  CgiApi.h  : NetWare HTTP CGI Interface Definition File.
**
**  $Logfile:   J:/WEBSERV/PRODTREE/DISK1/WEB/SAMPLES/CGIPARSE/INC/VCS/CGIAPI.H_V  $
** $Revision:   1.1  $
**     $Date:   30 Apr 1996 10:44:50  $
**   $Author:   PTANG  $
**
**  Comments:  This file contains the structure definitions and API
**             prototypes necessary to interface with the NetWare Http
**             Server.
** 
** Exported API Functions Contained in this File:
**
**    CgiAuthenticate         // ???
**    CgiEnvGet               // Returns the string associated with the specified environment variable
**    CgiEnvPut               // Creates or modifies the specified environment variable
**    CgiEnvListCreate        // Creates an "argv" type array of environment variable strings
**    CgiEnvListDestroy       // Destroys an "argv" type array of environment variable strings
**    CgiExtDeReg             // Deregisters the calling CGI Extension NLM
**    CgiExtReg               // Registers the calling CGI Extension NLM
**    CgiFileClose            // Write to disk IF the disk write bit was specified on the OPEN
**    CgiFileDataCat          // Append data to the end of the logical memory file
**    CgiFileDataDelete       // Delete data from the logical memory file
**    CgiFileDataFind         // Locate data in the logical memory file
**    CgiFileDataInsert       // Insert data into the logical memory file
**    CgiFileOpen             // Allocates a struct, If the filePath is valid, read from disk file to memory file
**    CgiFileRead             // Read data from the logical file and write it to an output buffer
**    CgiFileSeek             // Set the logical offset of the current memory file position
**    CgiFileStrCat           // Append a sub-string to the offset of the memory file
**    CgiFileStrDelete        // Find and delete a substring from the memory version of the file
**    CgiFileStrFind          // Search the string start from the begining of the memory file 
**    CgiFileStrInsert        // Insert a string into the logical memory file
**    CgiFileStrmRead         // Read data from the socket into the logical memory file
**    CgiFileStrmWrite        // Write data from the logical memory file to the socket
**    CgiFileWrite            // Write data from a buffer to the logical memory file
**    CgiLogAccess            // Generates an entry in the common log file
**    CgiLogError             // Generates an entry in the common error file
**    CgiMemFree              // Frees memory allocated through CgiMemGet
**    CgiMemGet               // Allocates memory through the memory manager subsystem
**    CgiMutexLock            // Does an SMP Lock on all threads running in the specified CGI Extension NLM 
**    CgiMutexUnlock          // Does an SMP Unlock for threads running in the specified CGI Extension NLM
**    CgiStatusGet            // Returns the current status value from caller's Cgi_t struct
**    CgiStatusSet            // Sets the current status value in caller's Cgi_t struct
**    CgiStrDup               // Returns strdup(), but uses local memory manager
**    CgiStrmCharGet          // Read a character from the input stream
**    CgiStrmCharPut          // Write a character to the output stream
**    CgiStrmCharUnGet        // Returns the last character read from the input stream
**    CgiStrmDataGet          // Read data from the input stream
**    CgiStrmDataPut          // Write data to the output stream
**    CgiStrmFileSend         // Sends the specified file to the output stream
**    CgiStrmFlush            // Flushs buffered data to the output stream
**    CgiStrmPrintf           // Takes sprint style input and sends the resukt to the output stream
**    CgiStrmStdHdrSend       // Sends a standard HTTP header to the output stream
**    CgiStrmStrGet           // Reads a logical input line from the input stream
**    CgiStrmStrPut           // Writes a logical line to the output stream
**    CgiUrlEscape            // Escapes the characters of the specified URL
**    CgiUrlSet               // Duplicates/sets the URL in the caller's Cgi_t struct for re-parsing by the server
**    CgiUrlUnEscape          // Unescapes the characters of the specified URL
**    CgiWorkPtrGet           // Returns the caller's work pointer from the Cgi_t struct
**    CgiWorkPtrSet           // Sets the caller's work pointer in the Cgi_t struct
**
*******************************************************************************/
#ifndef _CgiApi_Included             /* Make sure this file has not already   */
#define _CgiApi_Included             /* been included.  If not, define it.    */
/******************************************************************************/

#include "nwtypes.h"

/******************************************************************************/
/*************************** API Error Return Codes ***************************/
/******************************************************************************/

#define  CgiC_SysMsgBase                  0x00800000  /* base number for the NetWare Web Server System Messages */

#define  CgiE_UnableToSetStrmDelay        0x00800001  /* "The NetWare Web Server was unable to modify the delay mode of the network connection." */
#define  CgiE_EndOfFile                   0x00800002  /* "End Of File has been returned for the logical network connection." */
#define  CgiE_UnGetCharNotMatched         0x00800003  /* "A call to CgiUnGetChar failed because the character was not matched." */
#define  CgiE_StrmWriteTimeout            0x00800004  /* "The transport was timeout on writing data." */
#define  CgiE_InvalidPtr                  0x00800005  /* "The calling process has specified a pointer that does not address valid memory." */
#define  CgiE_ModuleAlreadyRegistered     0x00800006  /* "The calling module has already registered with the HTTP Server." */
#define  CgiE_EnvVariableNotFound         0x00800007  /* "The specified environment variable was not found." */
#define  CgiE_InvalidCgiMemFree           0x00800008  /* "The memory being returned was not allocated through the CGI memory allocation API." */
#define  CgiE_FileOpenFail                0x00800009  /* "The requested file open failed" */
#define  CgiE_InvalidOptions              0x0080000A  /* "The specified options are invalid for the requested operation." */
#define  CgiE_InvalidOffset               0x0080000B  /* "The specified offset parameter is invalid for the requested operation." */
#define  CgiE_ReadError                   0x0080000C  /* "A error occurred while attempting to read from the specified file." */
#define  CgiE_WriteError                  0x0080000D  /* "A error occurred while attempting to write to the specified file." */
#define  CgiE_WebServerShutDown           0x0080000E  /* "The NetWare Web Server is being shutdown." */
#define  CgiE_ExtNameNotFound             0x0080000F  /* "The specified extension name was not found." */
#define  CgiE_ExtModLoadFailed            0x00800010  /* "The requested Web Server Extension Module could not be loaded." */
#define  CgiE_BufferLength                0x00800011  /* "The calling routine has specified an invalid buffer length." */
#define  CgiE_WebInRequestHandler         0x00800012  /* "Netware Web Server extension processes are busy executing in this NLM.  Please wait, it may take a few moments for this NLM to be unloaded." */

/******************************************************************************/
/************************ Function Prototype Definitions **********************/
/*******************************************************************************
**
** The following APIs are exported by the HTTP Server for use by the CGI
** Extension Modules running under the calling thread of the Server.  All 
** APIs return a status of SUCCESS or a non-zero registered API error value.  
** Any module receiving an error status can have the associated error text 
** displayed at the system console by calling one of the CsLib NLS enabled 
** output routines, i.e.:
**
** retCode = CSSM_DisplaySysMsg  (CSSMC_LogOutput,          // options 
**                                retCode,                  // API error code
**                                "<optional caller ID>");  // identify yourself
**
**                               N O T E
** Since the extension NLM runs under the context of the Http Server thread
** all memory allocations are owned by the server, a memory manager has been 
** implemented to decrease the memory fragmentation that typically occurs on
** a NetWare Server when memory is continuously being allocated and freed.
** 
*******************************************************************************/
/**************** CgiStatusGet & CgiStatusSet Bit Definitions *****************/
/******************************************************************************/
/* The following bit definitions are defined for the Cgi_t status field that */
/* will be examined by the server on returned from the called extension */
/* processor's request handler. */
/******************************************************************************/

#define CgiC_UrlReParse       0x00000001     /* When this bit is set in the Cgi_t */
                                             /* status field, the server will reparse */
                                             /* the URL set by CgiUrlSet and reexecute */
                                             /* the URL as if it had just been received */
                                             /* from the network. */

/*********************** CgiExtReg Typedef Definitions ************************/

#define CgiC_ParseHeaders     0x00000001     /* extOptions: Indicates whether the extension NLM */
                                             /* expects the Server to determine header length, etc., */
                                             /* prior to sending the response data to the client. */

#define CgiC_IsSmpEnabled     0x00000002     /* extOptions: When set on CgiExtReg,     */
                                             /* the Web Server process thread will be  */
                                             /* migrated to SMP prior to calling the   */
                                             /* extensions request handler.  Note      */
                                             /* that being SMP enabled means that      */
                                             /* all thread processes are executing in  */
                                             /* a logically pre-emptive operation      */
                                             /* system.                                */
                                             
typedef LONG (*CgiRequest) (struct Cgi_t  *  cgiInfo);      /* I/O ptr to Cgi Information */

/*********************** UnLoadHndlr Bit Definitions **************************/

#define CgiC_UnloadImmediate                 0x00000001     /* An immediate unload is requested, if possible */

typedef LONG (*CgiUnload)  (LONG             unloadFlags);  /* I   Unload request flags */

/************************* CgiFileOpen - FileOptions  *************************/

#define CgiFileC_ReadOnly        0x00000001  /* Permits the disk file to be read only */
#define CgiFileC_ReadWrite       0x00000002  /* Permits the disk file to be both read and written */
#define CgiFileC_Truncate        0x00000004  /* Causes the disk file to be truncated to contain no data when the file existes; */
                                             /* has no effect when the file does not exist */
#define CgiFileC_Exclusive       0x00000008  /* Prevents read/write access to the disk file */

/************************* CgiFileLSeek - seekOptions *************************/

#define CgiFileC_SeekStart       0x00000001  /* The new file position is computed relative  */
                                             /* to the start of the memory file */
#define CgiFileC_SeekCurrent     0x00000002  /* The new file position is computed relative  */
                                             /* to the current of the memory file */
#define CgiFileC_SeekEnd         0x00000004  /* The new file position is computed relative  */
                                             /* to the end of the memory file */

/******************************************************************************/

#ifndef FROM_CGIAPI
LONG  CgiEnvGet         (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         BYTE             *  envVariable,   /* I   environment variable to search for */
                         BYTE             ** envValue);     /* I/O returned string value (momory is allocated to user) */

LONG  CgiEnvPut         (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         BYTE             *  envVariable,   /* I   environment variable to set or add */
                         BYTE             *  envValue);     /* I   associated string value (case unchanged) */
                      
LONG  CgiEnvListCreate  (struct Cgi_t     *  cgiInfo,       /* I   Cgi Info control struct */
                         BYTE             ** envList []);   /* I/O retnd argv type list of strings */

LONG  CgiEnvListDestroy (struct Cgi_t     *  cgiInfo,       /* I   Cgi Info control struct */
                         BYTE             ** envList []);   /* I/O ptr set to NULL on return */

#endif
LONG  CgiExtDeReg       (LONG                cgiHandle);    /* I   caller's CgiExtReg handle */

LONG  CgiExtReg         (CgiRequest          ReqHndlr,      /* I   address of request handler */
                         CgiUnload           UnloadHndlr,   /* I   address of unload request handler */
                         LONG                extOptions,    /* I   Extension NLM registration options (see extOptions above) */
                         LONG             *  cgiHandle);    /* I/O returned Cgi module handle */

#ifndef FROM_CGIFILE
LONG  CgiFileClose      (struct CgiFile_t **  fileInfo);    /* I/O   ptr to the CgiFile info data struct */

LONG  CgiFileDataCat    (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         BYTE             *  appendData,    /* I   ptr to the string to be appended */
                         LONG                appendDataLen);/* I   the number of bytes to append */

LONG  CgiFileDataDelete (struct CgiFile_t *  fileInfo,      /* I   file info struct */
                         LONG             *  deleteOffset,  /* I   logical delete start offset */
                         LONG                deleteLen);    /* I   number of bytes to delete */

LONG  CgiFileDataFind   (struct CgiFile_t *  fileInfo,      /* I   file info struct */
                         LONG             *  searchOffset,  /* I/O logical search start offset */
                         BYTE             *  searchData,    /* I   Search data */
                         LONG                searchLen);    /* I   search length */

LONG  CgiFileDataInsert (struct CgiFile_t *  fileInfo,      /* I   file info struct */
                         LONG             *  insertOffset,  /* I/O logical search start offset */
                         BYTE             *  insertData,    /* I   search data */
                         LONG                insertLen);    /* I   search length */

LONG  CgiFileOpen       (struct CgiFile_t ** fileInfo,      /* I   ptr to the CgiFile info data struct */
                         BYTE             *  filePath,      /* I   ptr to the name of the file */
                         LONG                fileOptions);  /* I   access mode of the file (see fileOptions above) */

LONG  CgiFileRead       (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         LONG             *  bufLen,        /* I/O number of bytes to read */
                         BYTE             *  bufPtr);       /* I/O ptr to a buffer to receive data */

LONG  CgiFileSeek       (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         LONG                seekOptions,   /* I   the seek starting point (see seekOptions above) */
                         LONG             *  seekOffset);   /* I/O the new logical offset of the current memory file position */

LONG  CgiFileStrCat     (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         BYTE             *  appendStr);    /* I   ptr to the string to be appended */

LONG  CgiFileStrDelete  (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         LONG             *  delOffset,     /* I   logical delete offset */
                         BYTE             *  delStr);       /* I   ptr to the string to be deleted */

LONG  CgiFileStrFind    (struct CgiFile_t *  fileInfo,      /* I   file info struct */
                         LONG             *  searchOffset,  /* I/O logical search start offset, returns found offset */
                         BYTE             *  searchData);   /* I   search data */

LONG  CgiFileStrInsert  (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         LONG             *  insertOffset,  /* I/O logical insert offset */
                         BYTE             *  insertStr);    /* I   ptr to the string to be searched */

LONG  CgiFileStrmRead   (struct CgiFile_t *  fileInfo,      /* I   CgiFile info struct   */
                         struct Cgi_t     *  cgiInfo,       /* I   Cgi info struct */
                         LONG             *  bytesRead);    /* I/O Number of bytes read from the Stream */

LONG  CgiFileStrmWrite  (struct CgiFile_t *  fileInfo,      /* I   CgiFile info struct */
                         struct Cgi_t     *  cgiInfo,       /* I   Cgi info struct */
                         LONG             *  bytesWritten); /* O   Number of bytes written to the Stream */

LONG  CgiFileWrite      (struct CgiFile_t *  fileInfo,      /* I   ptr to the CgiFile info data struct */
                         LONG                bufLen,        /* I   number of bytes to write */
                         BYTE             *  bufPtr);       /* I   ptr to a buffer to write data */
#endif

#ifndef FROM_CGIAPI
LONG  CgiLogAccess      (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         BYTE             *  fmtStr,        /* I   printf style format string */
                         ...);                              /* I   variable arguments associated with fmtStr */

LONG  CgiLogError       (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         BYTE             *  fmtStr,        /* I   printf style format string */
                         ...);                              /* I   variable arguments associated with fmtStr */
#endif

LONG  CgiMemFree        (void             ** memPtr);       /* I/O ptr to memory to be freed, NULL'd on return */

LONG  CgiMemGet         (void             ** memPtr,        /* I/O returned ptr to allocated memory */
                         LONG                memSize);      /* I   requested memory size */

LONG  CgiMutexLock      (LONG                cgiHandle);    /* I/O caller's returned Cgi module handle */

LONG  CgiMutexUnlock    (LONG                cgiHandle);    /* I/O caller's returned Cgi module handle */

#ifndef FROM_CGIAPI
LONG  CgiStatusGet      (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG             *  retStat);      /* I/O returned status value */

LONG  CgiStatusSet      (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG                setStat);      /* I   bit string to set  */
#endif

LONG  CgiStrDup         (BYTE             ** retStr,        /* I/O ptr to duplicated str */
                         BYTE             *  dupStr);       /* I   string to duplicate */

#ifndef FROM_CGIAPI
LONG  CgiStrmCharGet    (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG             *  getChar);      /* O   returned char from stream */

LONG  CgiStrmCharPut    (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG                putChar);      /* I   the character to be written */

LONG  CgiStrmCharUnGet  (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG                unGetChar);    /* I   the character to be pushed back */

LONG  CgiStrmDataGet    (struct Cgi_t     *  cgiInfo,       /* I   ptr to the Cgi info data struct  */
                         LONG             *  bufLen,        /* I/O on input, specifies the length   */
                                                            /*     of bufPtr.  On output, specifies */
                                                            /*     the number of bytes actually got.*/
                         LONG             *  bufPtr);       /* I/O the buffer in which to receive   */
                                                            /*     data.                            */

LONG  CgiStrmDataPut    (struct Cgi_t     *  cgiInfo,       /* I   ptr to the Cgi info data struct  */
                         LONG             *  bufLen,        /* I   specifies the length of bufPtr.  */
                         LONG             *  bufPtr);       /* I   points to the character to be    */
                                                            /*     written.                         */
LONG  CgiStrmFileSend   (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         BYTE             *  filePath);     /* I   ptr to the path of file to be sent */

LONG  CgiStrmFlush      (struct Cgi_t     *  cgiInfo);      /* I   caller's CGI Info struct */
   
LONG  CgiStrmPrintf     (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG             *  fmtLen,        /* I/O length of final output string, ignored if NULL */
                         BYTE             *  fmtStr,        /* I   a standard printf format specifier string */
                         ...);                              /* I   variable based on format specifier string */

LONG  CgiStrmStdHdrSend (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         const BYTE       *  contentType,   /* I   content type string of format */
                         LONG                contentLength);/* I   content length value of format (ignored if -1) */

LONG  CgiStrmStrGet     (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG             *  buflen,        /* I/O size of the buf, returns strlen() of recv  */
                         BYTE             *  bufPtr);       /* O   returned string or entire buf from stream  */

LONG  CgiStrmStrPut     (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         LONG             *  retsize,       /* O   the number of characters written (including 0) */
                         BYTE             *  buf);          /* I   ptr to the character string to be written  */
#endif

LONG  CgiUrlEscape      (BYTE             *  url,           /* I   URL to convert with escapes */
                         BYTE             ** escUrl);       /* I/O escaped Url (memory allocated to user) */

#ifndef FROM_CGIAPI
LONG  CgiUrlSet         (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         BYTE             *  urlStr);       /* I   new URL to duplicate/set in Cgi_t struct for re-parsing */
#endif
                         
LONG  CgiUrlUnEscape    (BYTE             *  urlString);    /* I   ptr to URL string to unescape */

#ifndef FROM_CGIAPI
LONG  CgiWorkPtrGet     (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         void             ** workPtr);      /* I/O returned caller's work ptr */

LONG  CgiWorkPtrSet     (struct Cgi_t     *  cgiInfo,       /* I   caller's CGI Info struct */
                         void             *  workPtr);      /* I   caller's work ptr to be set */
#endif

/******************************************************************************/
#endif                                                   /* _CgiApi_Included  */
/******************************************************************************/
