/* $Id: util.c,v 1.1.1.1 1995/07/09 18:25:44 brad Exp $ */
/*
   util.c

   various utility routines for rcgid
*/

#include "rcgid.h"

/*
   path_fix_parents()

   parse through a path name, interpreting any self-relative nodes ("..").
   if any ".." nodes are found, apply them and modify the path.

   the resulting path should be absolute and "safe" (safe means it will
   have no ".."'s)
*/

static char *lookfor = "..";

void
path_fix_parents(name)
char *name;
{
    int l = 0, w = 0;

    while (name[l] != '\0') {
	if (name[l] != lookfor[w])
	    (w > 0 ? (l -= (w - 1), w = 0) : l++);
	else {
	    if (lookfor[++w] == '\0') {
		/* found ".." */
		if (name[l + 1] == '\0' || (name[l + 1] == '/' &&
		    ((l > 3 && name[l - 2] == '/') || l <= 3)))
		{
		    register int m = l + 1, n;

		    l = l - 3;
		    if (l >= 0) {
			while (l != 0 && name[l] != '/')
			    --l;
		    } else
			l = 0;

		    n = l;
		    while ((name[n] = name[m]))
			(++n, ++m);
		    w = 0;
		} else
		    w = 0;
	    } else
		++l;
	}
    }
}

/*
   no2slash()

   remove any "//" from path, by making it a single "/"
*/

void
path_no2slash(name)
char *name;
{
    register int x, y;

    for (x = 0; name[x]; x++)
	if (x && name[x - 1] == '/' && name[x] == '/')
	    for (y = x + 1; name[y - 1]; y++)
		name[y - 1] = name[y];
}

int
clean_up_path(path)
char *path;
{
    path_no2slash(path);
    path_fix_parents(path);

    if (path[0] == '/')
	return -1;

    return 0;
}

static char
x2c(what)
char *what;
{
    register char digit;

    digit = ((what[0] >= 'A') ?
	     ((what[0] & 0xdf) - 'A') + 10 : (what[0] - '0'));
    digit *= 16;
    digit += (what[1] >= 'A' ?
	      ((what[1] & 0xdf) - 'A') + 10 : (what[1] - '0'));

    return (digit);
}

void
unescape_url(url)
char *url;
{
    int x, y;

    for (x = 0, y = 0; url[y]; ++x, ++y) {
	if ((url[x] = url[y]) == '%') {
	    url[x] = x2c(&url[y + 1]);
	    y += 2;
	}
    }

    url[x] = '\0';
}

void
escape_shell_cmd(cmd)
char *cmd;
{
    int x, y, l;

    l = strlen(cmd);
    for (x = 0; cmd[x]; x++) {
	if (strchr("&;`'\"|*?~<>^()[]{}$\\", cmd[x]))
	{
	    for (y = l + 1; y > x; y--)
		cmd[y] = cmd[y - 1];

	    /* length has been increased */
	    l++;
	    cmd[x] = '\\';

	    /* skip the character */
	    x++;	
	}
    }
}

/*
   create_argv()

   take a string of argument, terminated with whitespace and turn
   into an argv vector of ptrs to strings, ending with a zero ptr.
*/

char **
create_argv(args)
char *args;
{
    int x, n, i, len;
    char **av;
    char *w, *p, *oldp, ch;

    /* guess at how big the vector should be */
    for (x = 0, n = 1; ch = args[x]; x++)
        if (ch == '+' || ch == ' ' || ch == '\t') ++n;

    if (!(av = (char **)malloc((n + 1) * sizeof(char *))))
	return 0;

    /* scan for args */
    p = args;
    for (x = 0; x < n; x++) {
	oldp = p;
	while (ch = *p++)
	    if (ch == '+' || ch == ' ' || ch == '\t')
		break;

	if (ch == ' ' || ch == '\t')
	    while (*p == ' ' || *p == '\t')
		p++;

	len = (p - oldp) - 1;
	if (!(w = calloc(1, len * 2 + 1))) {
	    for (i = 0; i < x; i++)
		free(av[i]);
	    free(av);
	    return 0;
	}

	memcpy(w, oldp, len);
	w[len] = 0;

        unescape_url(w);
        escape_shell_cmd(w);

	av[x] = w;
    }

    av[x] = NULL;

    return av;
}

int
dumpv(what, vec)
char *what;
char **vec;
{
    char *p;
    int n;

    log_error(what);
    
    for (n = 0; (p = *vec++) && n < 20; n++) {
	char l[256];
	sprintf(l, " [%d] = '%s'", n, p);
	log_error(l);
    }
}

char *
ip_ntoa(ip)
unsigned long ip;
{
    static char b[32];

    sprintf(b, "%d.%d.%d.%d",
	    (int)(ip >> 24) & 0xff,
	    (int)(ip >> 16) & 0xff,
	    (int)(ip >> 8) & 0xff,
	    (int)(ip     ) & 0xff);

    return b;
}
