//INSTALL  JOB            MSGCLASS=T,CLASS=A
//*********************************************************************
//*                                                                   *
//*  DESCRIPTION: PARSE, ASSEMBLE, AND LINKEDIT USER DEFINED CODE     *
//*               POINT TABLES.                                       *
//*                                                                   *
//*  NOTE ===>  THIS JCL ASSUMES:                                     *
//*                 1.)  THE CODE POINT SOURCE IS CONTAINED IN A      *
//*                      SINGLE LIBRARY                               *
//*                 2.)  THE MEMBER NAMES ARE FORMATED AS AAABBCCC    *
//*                      WHERE AAA = BNJ                              *
//*                            BB  = CODE POINT TABLE NUMBER          *
//*                            CCC = UTB (MODIFIABLE BY SYMBOLIC      *
//*                                  VARIABLE "NAME")                 *
//*                                                                   *
//*  TO EXECUTE THIS JCL:                                             *
//*       1.)  PUT YOUR OWN JOB CARD ON THE JOB                       *
//*       2.)  MODIFY SYMBOLIC VARIABLE "NETLNK" TO POINT TO THE      *
//*            NETVIEW LOAD LIBRARY YOU WANT THE CODE POINTS LINKED   *
//*            INTO                                                   *
//*       3.)  MODIFY SYMBOLIC VARIABLE "USERLIB" TO POINT TO THE     *
//*            SOURCE LIBRARY NAME CONTAINING THE CODE POINTS.        *
//*********************************************************************
//CNMUSER PROC    NUMBER=,
//        NAME=UTB,
//        NETLNK='CNM.USERLNK',      ** OUTPUT LIBRARY
//        REG=1,                     ** REGION SIZE IN MEG
//        SOUTA='*',                 ** DEFAULT PRINTED OUTPUT CLASS
//        UNIT=SYSDA,                ** DEVICE TYPE FOR DASD
//        USERLIB='SYS2.NTVW.CODE.POINTS', ** CODE POINTS SOURCE
//        PS=3,                      ** PRIMARY CYLINDER ALLOCATION
//        SS=1                       ** SECONDARY CYLINDER ALLOCATION
//*********************************************************************
//*  VERIFY USER TABLE INPUT
//*********************************************************************
//PARSE    EXEC   PGM=BNJUSTBL,REGION=&REG.M,
//            PARM='&NUMBER'
//STEPLIB  DD DSN=SYS1.NPDALIB,DISP=SHR
//INTABLE  DD DSN=&USERLIB(BNJ&NUMBER&NAME),DISP=SHR
//OUTTABLE DD DSN=&&OUTDCB,DISP=(NEW,PASS),UNIT=&UNIT,
//            SPACE=(CYL,(&PS,&SS)),
//            DCB=(DSORG=PS,LRECL=80,BLKSIZE=3120,RECFM=FB)
//SYSPRINT DD SYSOUT=&SOUTA
//SYSUDUMP DD DUMMY
//SYSUT1   DD UNIT=&UNIT,SPACE=(CYL,(&PS,&SS))
//*********************************************************************
//*  ASSEMBLE STEP
//*********************************************************************
//ASM     EXEC PGM=IFOX00,PARM='LOAD,NODECK,OBJECT',
//             REGION=&REG.M,COND=(4,LT)
//SYSPRINT  DD SYSOUT=&SOUTA
//SYSLIB    DD DSNAME=SYS1.MACLIB,DISP=SHR
//SYSUT1    DD UNIT=&UNIT,SPACE=(CYL,(1,1))
//SYSUT2    DD UNIT=&UNIT,SPACE=(CYL,(1,1))
//SYSUT3    DD UNIT=&UNIT,SPACE=(CYL,(1,1))
//SYSGO     DD DSNAME=&&SYSGO,DISP=(NEW,PASS),UNIT=&UNIT,
//       SPACE=(CYL,(&PS,&SS)),
//       DCB=(DSORG=PS,LRECL=80,BLKSIZE=3120,RECFM=FB)
//SYSIN    DD DSN=*.PARSE.OUTTABLE,
//         DISP=(OLD,DELETE)
//*********************************************************************
//*  LINKEDIT STEP
//*********************************************************************
//LINK    EXEC PGM=IEWL,
//             PARM='XREF,LET,LIST,SIZE=(512K,128K),NCAL,REUS',
//             REGION=&REG.M,COND=(4,LT)
//SYSPRINT  DD SYSOUT=&SOUTA
//SYSUT1    DD SPACE=(CYL,(1,1)),DISP=(NEW,PASS),UNIT=&UNIT
//SYSLMOD  DD DSN=&NETLNK(BNJ&NUMBER&NAME),
//         DISP=SHR
//SYSLIN   DD DSNAME=&&SYSGO,DISP=(OLD,DELETE)
//         PEND
//STEP1    EXEC PROC=CNMUSER,NUMBER=92
//STEP2    EXEC PROC=CNMUSER,NUMBER=93
//STEP3    EXEC PROC=CNMUSER,NUMBER=94
//STEP4    EXEC PROC=CNMUSER,NUMBER=95
//STEP5    EXEC PROC=CNMUSER,NUMBER=96
//STEP6    EXEC PROC=CNMUSER,NUMBER=81
//STEP7    EXEC PROC=CNMUSER,NUMBER=82
