/*******************************************************************
*                                                                  *
*  MODULE : mailbox.c                                              *
*                                                                  *
*  Realization of asynchronus message passing via                  *
*  Mailboxes that can contain one message from every process       *
*                                                                  *
*******************************************************************/

#include <stdio.h>
#include "system.h"
#include "pvm3.h"

/*******************************************************************
*                                                                  *
*  Sending and receiving of messages                               *
*                                                                  *
*******************************************************************/

void asend (from, to, message, length)
int from, to;
unsigned char *message;
int length;
/* Process 'from' sends a message to process 'to' */

{  int i;

   if (from == to)
   { if (own_mailbox.full == 1)
       { printf ("send: there is already own mail\n");
         exit (-1);
       }
     own_mailbox.msg_length = length;
     own_mailbox.msg = (unsigned char *) malloc (length);
     for (i=0; i<length; i++)
       own_mailbox.msg[i] = message[i];
     own_mailbox.full = 1;
   }
   else
   { pvm_initsend (PvmDataRaw);
     /* printf ("call of send : to = %d, from = %d , length = %d\n",
                to, from, length);        */
     pvm_pkbyte (message, length, 1);
     pvm_send (tids[to], from);
   }
}

void areceive (to, from, message, length)
/* process 'to' gets a message from process 'from' */
int to, from;
unsigned char *message;
int length;
{  int i;
   if (to == from)
   { if (own_mailbox.full == 0)
       { printf ("receive: no own mail\n");
         exit (-1);
       }
     if (own_mailbox.msg_length != length)
       { printf ("receive: own mail wrong length\n");
         exit (-1);
       }
     for (i=0; i<length; i++)
       message[i] = own_mailbox.msg[i];
     free (own_mailbox.msg);
     own_mailbox.full = 0;
   }
   else
   { /* printf ("call of recv : to = %d, from = %d , length = %d\n",
                to, from, length);       */
     pvm_recv (tids[from], from);
     pvm_upkbyte (message, length, 1);
     /* printf ("has recvd : to = %d, from = %d , length = %d\n",
                to, from, length);      */
   }
}

/*******************************************************************
*                                                                  *
*  DALIB : Fortran Interface                                       *
*                                                                  *
*******************************************************************/

dalib_receive__ (from, message, length)
int *from;
unsigned char * message;
int *length;
{ int to;
  to = dalib_pid_ ();
  /* printf ("call of dalib_receive : to = %d, from = %d , length = %d\n",
              to, *from, *length);     */
  areceive (to, *from, message, *length);
}

dalib_send__ (to, message, length)
int *to;
unsigned char * message;
int *length;
{ int from;
  from = dalib_pid_ ();
  /* printf ("call of dalib_receive : from = %d, to = %d , length = %d\n",
              *to, from, *length);     */
  asend (from, *to, message, *length);
}
