/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                    *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Feb 93                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  MAIN OF NODE PROGRAM for PVM (Version 3.0)                      *
*                                                                  *
*  MODULE : mnode.c                                                *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*  - is spawned by the host process                                *
*  - enrolls node in PVM                                           *
*  - calls nodemodule ()                                           *
*                                                                  *
*******************************************************************/

/*******************************************************************
*                                                                  *
*  Interface to Adaptor:                                           *
*                                                                  *
*    dalib_pid_   ()                                               *
*    dalib_nproc_ ()                                               *
*                                                                  *
*******************************************************************/

#include <stdio.h>
#include <string.h>
#include "system.h"
#include "pvm3.h"

#define INIT_MSGID  9999

int NP;          /* number of node processes */
int my_id;       /* number of my process: 0 (host), 1 .. NP */

#ifdef IBM
void nodemodule ();
#else
void nodemodule_ ();
#endif

void MAIN__ ()

{ int i;
  int waitid;
  int status;
  int mytid;

  unsigned long startt;   /* start timer value */
  int htrace_flag;

  target_model = 0;       /* with host */

  /* enroll in PVM */

  mytid = pvm_mytid();

  /* recv initial message */

  pvm_recv (-1, INIT_MSGID);
  pvm_upkbyte (&NP, sizeof(int), 1);
  pvm_upkbyte (tids, (NP+1)*sizeof(int), 1);

  /* try to find my_id */

  for (i=1; i<=NP ; i++)
     if (mytid == tids[i]) { my_id = i; break; }

  /* tell host that I am ready */

  pvm_initsend (PvmDataRaw);
  pvm_pkbyte (&my_id, sizeof(int), 1);
  pvm_send (tids[0], INIT_MSGID -1);

  /* definition of the process control block */

  pcb.i       = my_id;
  pcb.p       = NP;

  random_block_init ();
  dalib_init_walltime ();

  /* initialization of tracing */

#ifdef IBM
  nodemodule ();
#else
  nodemodule_ ();
#endif

  pvm_exit ();   /* exit PVM */
}

/*******************************************************************
*                                                                  *
*  number and ids of processes                                     *
*                                                                  *
*******************************************************************/

int dalib_pid_ ()
{
   return (my_id);
}

int dalib_nproc_ ()
{ return (NP); }
