/*******************************************************************
*                                                                  *
*  DEFINITIONS : system.h                                          *
*                                                                  *
*  Definition of the process control block                         *
*                                                                  *
*  PVM Version (SUN4, IBM AIX, Alliant)                            *
*                                                                  *
*******************************************************************/

#define MAXP  16        /* maximal number of node processes */
#define MAXP1 MAXP+1

/*******************************************************************
*                                                                  *
*  Task Ids for PVM version 3.0                                    *
*                                                                  *
*******************************************************************/

int tids[MAXP1];

/* every array has an entry in the local process control block */

#define MAX_DIM     4   /* maximal rank of a distributed array   */
#define MAX_ARRAYS 90   /* maximal number of array - descriptors */

/*******************************************************************
*                                                                  *
*  own local mailbox                                               *
*                                                                  *
*******************************************************************/

typedef struct
  { int full, msg_length;
    unsigned char *msg;
  } local_mailbox;

local_mailbox own_mailbox;

/*******************************************************************
*                                                                  *
*  Process Control Block, local copy for host and all node proc.   *
*                                                                  *
*******************************************************************/

typedef struct
 { int i, p;          /* 0 <= i <= p = number of processes */
 } process_control_block;

process_control_block pcb;

/*******************************************************************
*                                                                  *
*  Model for Parallel execution (0 with Host, 1 without Host)      *
*                                                                  *
*******************************************************************/

int target_model; 

/*******************************************************************
*                                                                  *
*  Trace Information                                               *
*                                                                  *
*******************************************************************/

int trace_flag;   /* trace if trace_flag > 0 */


