# include "DataFlow.h"
# include "yyDFlow.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "DepGraph.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 10 "DataFlow.puma"

# include "Tree.h"
# include "DepGraph.h"
# include "Unparse.h"    /* for printing node information */

# define tExits int
typedef DepNodeSet* pDepNodeSet;

tTree LoopList;
tTree Stat;     /* global for the last statement */
tDepNode DN;

int DepErrorCount;    /* Counter for Errors */

FILE *DepFile;        /* will be exported */

short IsLoopVar (name)
tIdent name;
{  short found;
   tTree HL, HE, Id;
   HL = LoopList;
   found = 0;
   while ((HL->Kind != kACF_EMPTY) && (!found))
     {  HE = HL->ACF_LIST.Elem;
        if (HE->Kind == kACF_DO)
           {  Id = HE->ACF_DO.DO_ID;
              if (Id->Kind == kLOOP_VAR)
                found = (Id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == name);
           }
        HL = HL->ACF_LIST.Next;
     }
   return (found);
} /* IsLoopVar */

/* The following subroutine is used for chaining definitions and uses */

void DepChaining (R_In, Defs, Uses, Depth, R_Out)
pDepNodeSet Uses, Defs, R_In, R_Out;
int Depth;

/* means :  Bestimmung von OUT-Mengen fuer Basis-Knoten im ACF_Graphen
   USE       : Benutzungen in elementaren Knoten
   DEF       : Definitionen in elementaren Knoten
   R_IN      : Menge der Defintionen/Benutzungen, die Knoten N erreichen
   LOOPLIST  : <Lm,...,L1> Liste der Schleifen, die N umgeben; Lm ist
               innerste, L1 ist aeusserste Schleife
   DEPTH     : Anzahl umgebender Schleifen, die nicht konstant gehalten werden
               d.h. L1, ..., Lk mit k = m - Depth werden konstant gehalten
   R_OUT     : Mengen der Defintionen/Benutzungen, die Ausgang von N erreichen

   Bemerkung : Nur fuer DEPTH = 0 werden Defintionen und Benutzungen aus Knoten
               N betrachtet, ob sie entsprechende Ausgaenge erreichen

  global used : LoopList */

{
   printf ("*** Start : DepChaining\\n");
   printf ("R_In : "); WriteSet (stdout, R_In); printf("\\n");
   printf ("Defs : "); WriteSet (stdout, Defs); printf("\\n");
   printf ("Uses : "); WriteSet (stdout, Uses); printf("\\n");
   Assign (R_Out, R_In);
   Union (R_Out, Uses);
   Union (R_Out, Defs);
   ReleaseSet (Uses);
   ReleaseSet (Defs);
   printf ("R_Out : "); WriteSet (stdout, R_Out); printf("\\n");
   printf ("*** End : DepChaining\\n");
} /* depchaining , means basic i-o */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module DataFlow, routine %s failed\n", yyFunction);
 exit (1);
}

void DataFlow ARGS((tTree t));
static void Building ARGS((tTree t));
static void Reaching ARGS((tTree t, pDepNodeSet in, pDepNodeSet out, tExits eout, int depth, int new));
void OutDependences ARGS((tTree t));
static void OutDepNode ARGS((tDepGraph d));
static void OutPosition ARGS((tTree t));

void DataFlow
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 96 "DataFlow.puma"

unsigned char string[256];
DepNodeSet R_In, R_Out;
tExits E_Out;

  if (t == NoTree) return;
  if (t->Kind == kCOMP_UNIT) {
# line 108 "DataFlow.puma"
  {
# line 109 "DataFlow.puma"
   DataFlow (t->COMP_UNIT.COMP_ELEMENTS);
  }
   return;

  }
  if (t->Kind == kDECL_LIST) {
# line 114 "DataFlow.puma"
  {
# line 115 "DataFlow.puma"
   DataFlow (t->DECL_LIST.Elem);
# line 116 "DataFlow.puma"
   DataFlow (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kPROGRAM_DECL) {
# line 119 "DataFlow.puma"
  {
# line 120 "DataFlow.puma"
   DepCreateGraph (t);
# line 121 "DataFlow.puma"
   GetString (t->PROGRAM_DECL.Name, string);
# line 122 "DataFlow.puma"
   printf ("PROGRAM %s; \n", string);
# line 123 "DataFlow.puma"
   DataFlow (t->PROGRAM_DECL.PROGRAM_BODY);
# line 124 "DataFlow.puma"
   DepCloseGraph ();
  }
   return;

  }
  if (t->Kind == kPROC_DECL) {
# line 127 "DataFlow.puma"
  {
# line 128 "DataFlow.puma"
   DepCreateGraph (t);
# line 129 "DataFlow.puma"
   GetString (t->PROC_DECL.Name, string);
# line 130 "DataFlow.puma"
   printf ("SUBROUTINE %s; \n", string);
# line 131 "DataFlow.puma"
   DataFlow (t->PROC_DECL.PROC_BODY);
# line 132 "DataFlow.puma"
   DepCloseGraph ();
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
# line 135 "DataFlow.puma"
  {
# line 136 "DataFlow.puma"
   DepCreateGraph (t);
# line 137 "DataFlow.puma"
   GetString (t->FUNC_DECL.Name, string);
# line 138 "DataFlow.puma"
   printf ("FUNCTION %s; \n", string);
# line 139 "DataFlow.puma"
   DataFlow (t->FUNC_DECL.FUNC_BODY);
# line 140 "DataFlow.puma"
   DepCloseGraph ();
  }
   return;

  }
  if (t->Kind == kBODY_NODE) {
# line 143 "DataFlow.puma"
  {
# line 144 "DataFlow.puma"
   Building (t->BODY_NODE.STATS);
# line 145 "DataFlow.puma"
   MakeSet (& R_In, MaxDepNode);
# line 146 "DataFlow.puma"
   MakeSet (& R_Out, MaxDepNode);
# line 147 "DataFlow.puma"
   printf ("Calling of Reaching from Body\n");
# line 148 "DataFlow.puma"
   Reaching (t, & R_In, & R_Out, E_Out, 0, 1);
# line 149 "DataFlow.puma"
   ReleaseSet (& R_In);
# line 150 "DataFlow.puma"
   ReleaseSet (& R_Out);
  }
   return;

  }
;
}

static void Building
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 161 "DataFlow.puma"

unsigned char string[256];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kVAR_DECL:
# line 171 "DataFlow.puma"
   return;

  case kPARAMETER_DECL:
# line 174 "DataFlow.puma"
   return;

  case kCOMMON_DECL:
# line 177 "DataFlow.puma"
  {
# line 179 "DataFlow.puma"
   Building (t->COMMON_DECL.IDS);
  }
   return;

  case kEQV_DECL:
# line 182 "DataFlow.puma"
  {
# line 184 "DataFlow.puma"
   Building (t->EQV_DECL.VARS);
  }
   return;

  case kDATA_DECL:
# line 187 "DataFlow.puma"
  {
# line 188 "DataFlow.puma"
   Building (t->DATA_DECL.VARS);
# line 189 "DataFlow.puma"
   Building (t->DATA_DECL.VALS);
  }
   return;

  case kTYPE_LIST:
# line 207 "DataFlow.puma"
  {
# line 208 "DataFlow.puma"
   Building (t->TYPE_LIST.Elem);
# line 209 "DataFlow.puma"
   Building (t->TYPE_LIST.Next);
  }
   return;

  case kINDEX_TYPE:
# line 212 "DataFlow.puma"
  {
# line 213 "DataFlow.puma"
   Building (t->INDEX_TYPE.LOWER);
# line 214 "DataFlow.puma"
   Building (t->INDEX_TYPE.UPPER);
  }
   return;

  case kACF_LIST:
# line 223 "DataFlow.puma"
  {
# line 224 "DataFlow.puma"
 Stat = t->ACF_LIST.Elem;
# line 225 "DataFlow.puma"
   Building (t->ACF_LIST.Elem);
# line 226 "DataFlow.puma"
   Building (t->ACF_LIST.Next);
  }
   return;

  case kACF_BASIC:
# line 229 "DataFlow.puma"
  {
# line 230 "DataFlow.puma"
   Building (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
# line 233 "DataFlow.puma"
  {
# line 234 "DataFlow.puma"
   Building (t->ACF_IF.IF_EXP);
# line 235 "DataFlow.puma"
   Building (t->ACF_IF.THEN_PART);
# line 236 "DataFlow.puma"
   Building (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 239 "DataFlow.puma"
  {
# line 240 "DataFlow.puma"
   Building (t->ACF_WHERE.WHERE_EXP);
# line 241 "DataFlow.puma"
   Building (t->ACF_WHERE.TRUE_PART);
# line 242 "DataFlow.puma"
   Building (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 245 "DataFlow.puma"
  {
# line 246 "DataFlow.puma"
   Building (t->ACF_CASE.CASE_EXP);
# line 247 "DataFlow.puma"
   Building (t->ACF_CASE.CASE_ALTS);
# line 248 "DataFlow.puma"
   Building (t->ACF_CASE.CASE_OTHERWISE);
  }
   return;

  case kACF_WHILE:
# line 251 "DataFlow.puma"
  {
# line 252 "DataFlow.puma"
 LoopList = mACF_LIST (t, LoopList);
# line 253 "DataFlow.puma"
   Building (t->ACF_WHILE.WHILE_EXP);
# line 254 "DataFlow.puma"
   Building (t->ACF_WHILE.WHILE_BODY);
# line 255 "DataFlow.puma"
 LoopList = LoopList->ACF_LIST.Next;
  }
   return;

  case kACF_DO:
# line 258 "DataFlow.puma"
  {
# line 259 "DataFlow.puma"
 LoopList = mACF_LIST (t, LoopList);
# line 260 "DataFlow.puma"
   Building (t->ACF_DO.DO_RANGE);
# line 261 "DataFlow.puma"
   Building (t->ACF_DO.DO_BODY);
# line 262 "DataFlow.puma"
 LoopList = LoopList->ACF_LIST.Next;
  }
   return;

  case kASSIGN_STMT:
# line 265 "DataFlow.puma"
  {
# line 266 "DataFlow.puma"
   Building (t->ASSIGN_STMT.ASSIGN_VAR);
# line 267 "DataFlow.puma"
   Building (t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kCALL_STMT:
# line 270 "DataFlow.puma"
  {
# line 271 "DataFlow.puma"
   Building (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  case kBTP_LIST:
# line 280 "DataFlow.puma"
  {
# line 281 "DataFlow.puma"
   Building (t->BTP_LIST.Elem);
# line 282 "DataFlow.puma"
   Building (t->BTP_LIST.Next);
  }
   return;

  case kVAR_PARAM:
# line 285 "DataFlow.puma"
  {
# line 286 "DataFlow.puma"
   Building (t->VAR_PARAM.V);
  }
   return;

  case kVALUE_PARAM:
# line 289 "DataFlow.puma"
  {
# line 290 "DataFlow.puma"
   printf ("There shouldn't be any value params in FORTRAN\n");
  }
   return;

  case kBTE_LIST:
# line 293 "DataFlow.puma"
  {
# line 294 "DataFlow.puma"
   Building (t->BTE_LIST.Elem);
# line 295 "DataFlow.puma"
   Building (t->BTE_LIST.Next);
  }
   return;

  case kVAR_EXP:
  if (t->VAR_EXP.V->Kind == kUSED_VAR) {
# line 304 "DataFlow.puma"
  {
# line 305 "DataFlow.puma"
   GetString (t->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, string);
# line 306 "DataFlow.puma"
 if (IsLoopVar (t->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident))
            { printf ("%s is LoopVariable\n",string);
              t->VAR_EXP.V->Kind = kLOOP_VAR;
            }
          else
            {
              printf ("%s will be a use-node\n", string);
              DN = mDepNode (t->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, 0, t->VAR_EXP.V, Stat, LoopList);
              DepGraphNodeInsert (DN);
            }

  }
   return;

  }
  if (t->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 337 "DataFlow.puma"
  {
# line 338 "DataFlow.puma"
   GetString (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, string);
# line 339 "DataFlow.puma"
 DN = mDepNode (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, 0, t->VAR_EXP.V, Stat, LoopList);
# line 340 "DataFlow.puma"
   DepGraphNodeInsert (DN);
# line 341 "DataFlow.puma"
   printf ("%s will be a use-node\n", string);
  }
   return;

  }
  }
# line 392 "DataFlow.puma"
  {
# line 393 "DataFlow.puma"
   printf ("Building for VarExp should not be called here\n");
  }
   return;

  case kUSED_VAR:
# line 319 "DataFlow.puma"
  {
# line 320 "DataFlow.puma"
   GetString (t->USED_VAR.VARNAME->VAR_OBJ.Ident, string);
# line 321 "DataFlow.puma"
 if (IsLoopVar (t->USED_VAR.VARNAME->VAR_OBJ.Ident))
            { printf ("LoopVariable %s is set \n",string);
            }
          else
            {
              printf ("%s will be a def-node \n", string);
              DN = mDepNode (t->USED_VAR.VARNAME->VAR_OBJ.Ident, 1, t, Stat, LoopList);
              DepGraphNodeInsert (DN);
            }

  }
   return;

  case kLOOP_VAR:
# line 333 "DataFlow.puma"
   return;

  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 344 "DataFlow.puma"
  {
# line 345 "DataFlow.puma"
   Building (t->INDEXED_VAR.IND_EXPS);
# line 346 "DataFlow.puma"
 DN = mDepNode (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, 1, t, Stat, LoopList);
# line 347 "DataFlow.puma"
   DepGraphNodeInsert (DN);
# line 348 "DataFlow.puma"
   GetString (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, string);
# line 349 "DataFlow.puma"
   printf ("%s will be a def-node\n", string);
  }
   return;

  }
  break;
  case kVAR_OBJ:
# line 358 "DataFlow.puma"
   return;

  case kDUMMY_EXP:
# line 367 "DataFlow.puma"
   return;

  case kCONST_EXP:
# line 370 "DataFlow.puma"
   return;

  case kARRAY_EXP:
# line 373 "DataFlow.puma"
  {
# line 374 "DataFlow.puma"
   Building (t->ARRAY_EXP.ELEMENTS);
  }
   return;

  case kSLICE_EXP:
# line 377 "DataFlow.puma"
  {
# line 378 "DataFlow.puma"
   Building (t->SLICE_EXP.START);
# line 379 "DataFlow.puma"
   Building (t->SLICE_EXP.STOP);
# line 380 "DataFlow.puma"
   Building (t->SLICE_EXP.INC);
  }
   return;

  case kOP_EXP:
# line 383 "DataFlow.puma"
  {
# line 384 "DataFlow.puma"
   Building (t->OP_EXP.OPND1);
# line 385 "DataFlow.puma"
   Building (t->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 388 "DataFlow.puma"
  {
# line 389 "DataFlow.puma"
   Building (t->OP1_EXP.OPND);
  }
   return;

  case kFUNC_CALL_EXP:
# line 396 "DataFlow.puma"
  {
# line 397 "DataFlow.puma"
   Building (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return;

  }

;
}

static void Reaching
# if defined __STDC__ | defined __cplusplus
(register tTree t, pDepNodeSet in, pDepNodeSet out, tExits eout, register int depth, register int new)
# else
(t, in, out, eout, depth, new)
 register tTree t;
 pDepNodeSet in;
 pDepNodeSet out;
 tExits eout;
 register int depth;
 register int new;
# endif
{
# line 438 "DataFlow.puma"

DepNodeSet H, Defs, Uses;

  if (t == NoTree) return;

  switch (t->Kind) {
  case kBODY_NODE:
# line 442 "DataFlow.puma"
  {
# line 444 "DataFlow.puma"
   printf ("R_IN : ");
# line 444 "DataFlow.puma"
   WriteSet (stdout, in);
# line 444 "DataFlow.puma"
   printf ("\n");
# line 445 "DataFlow.puma"
   printf ("R_OUT : ");
# line 445 "DataFlow.puma"
   WriteSet (stdout, out);
# line 445 "DataFlow.puma"
   printf ("\n");
# line 446 "DataFlow.puma"
   Reaching (t->BODY_NODE.STATS, in, out, eout, depth, new);
  }
   return;

  case kACF_EMPTY:
# line 455 "DataFlow.puma"
  {
# line 456 "DataFlow.puma"
   Assign (out, in);
  }
   return;

  case kACF_LIST:
# line 459 "DataFlow.puma"
  {
# line 466 "DataFlow.puma"
   printf ("ACF_LIST: R_IN = ");
# line 466 "DataFlow.puma"
   WriteSet (stdout, in);
# line 466 "DataFlow.puma"
   printf ("\n");
# line 467 "DataFlow.puma"
   MakeSet (& H, MaxDepNode);
# line 468 "DataFlow.puma"
   Reaching (t->ACF_LIST.Elem, in, & H, eout, depth, new);
# line 469 "DataFlow.puma"
   Reaching (t->ACF_LIST.Next, & H, out, eout, depth, new);
# line 470 "DataFlow.puma"
   printf ("ACF_LIST: R_OUT = ");
# line 470 "DataFlow.puma"
   WriteSet (stdout, out);
# line 470 "DataFlow.puma"
   printf ("\n");
# line 471 "DataFlow.puma"
   ReleaseSet (& H);
  }
   return;

  case kACF_IF:
# line 474 "DataFlow.puma"
  {
# line 485 "DataFlow.puma"
   MakeSet (& H, MaxDepNode);
# line 486 "DataFlow.puma"
   DepGraphGetForStmt (t, & Defs, & Uses);
# line 487 "DataFlow.puma"
   DepChaining (in, & Defs, & Uses, depth, & H);
# line 490 "DataFlow.puma"
   Reaching (t->ACF_IF.THEN_PART, & H, out, eout, depth, 0);
# line 491 "DataFlow.puma"
   Reaching (t->ACF_IF.ELSE_PART, & H, out, eout, depth, 0);
# line 492 "DataFlow.puma"
   ReleaseSet (& H);
  }
   return;

  case kACF_WHERE:
# line 495 "DataFlow.puma"
  {
# line 496 "DataFlow.puma"
   MakeSet (& H, MaxDepNode);
# line 497 "DataFlow.puma"
   DepGraphGetForStmt (t, & Defs, & Uses);
# line 498 "DataFlow.puma"
   DepChaining (in, & Defs, & Uses, depth, & H);
# line 499 "DataFlow.puma"
   Reaching (t->ACF_WHERE.TRUE_PART, & H, out, eout, depth, 0);
# line 500 "DataFlow.puma"
   Reaching (t->ACF_WHERE.FALSE_PART, & H, out, eout, depth, 0);
# line 501 "DataFlow.puma"
   ReleaseSet (& H);
  }
   return;

  case kACF_CASE:
# line 504 "DataFlow.puma"
  {
# line 525 "DataFlow.puma"
   printf ("CASE not implemented for Reaching\n");
  }
   return;

  case kACF_WHILE:
# line 528 "DataFlow.puma"
  {
# line 538 "DataFlow.puma"
 LoopList = mACF_LIST (t, LoopList);
# line 539 "DataFlow.puma"
   Reaching (t->ACF_WHILE.WHILE_BODY, in, out, eout, depth, new);
# line 540 "DataFlow.puma"
 LoopList = LoopList->ACF_LIST.Next;
  }
   return;

  case kACF_REPEAT:
# line 543 "DataFlow.puma"
  {
# line 553 "DataFlow.puma"
 LoopList = mACF_LIST (t, LoopList);
# line 554 "DataFlow.puma"
   Reaching (t->ACF_REPEAT.REPEAT_BODY, in, out, eout, depth, new);
# line 555 "DataFlow.puma"
 LoopList = LoopList->ACF_LIST.Next;
  }
   return;

  case kACF_DO:
# line 558 "DataFlow.puma"
  {
# line 571 "DataFlow.puma"
 LoopList = mACF_LIST (t, LoopList);
# line 572 "DataFlow.puma"
   printf ("ACF_DO: R_IN = ");
# line 572 "DataFlow.puma"
   WriteSet (stdout, in);
# line 572 "DataFlow.puma"
   printf ("\n");
# line 573 "DataFlow.puma"
   Reaching (t->ACF_DO.DO_BODY, in, out, eout, depth, new);
# line 574 "DataFlow.puma"
   printf ("ACF_DO: R_OUT = ");
# line 574 "DataFlow.puma"
   WriteSet (stdout, out);
# line 574 "DataFlow.puma"
   printf ("\n");
# line 575 "DataFlow.puma"
 LoopList = LoopList->ACF_LIST.Next;
  }
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 578 "DataFlow.puma"
  {
# line 580 "DataFlow.puma"
   printf ("Reaching an assignment\n");
# line 581 "DataFlow.puma"
   printf ("ASSIGN: R_IN = ");
# line 581 "DataFlow.puma"
   WriteSet (stdout, in);
# line 581 "DataFlow.puma"
   printf ("\n");
# line 582 "DataFlow.puma"
   DepGraphGetForStmt (t, & Defs, & Uses);
# line 583 "DataFlow.puma"
   DepChaining (in, & Defs, & Uses, depth, out);
# line 584 "DataFlow.puma"
   printf ("ASSIGN: R_OUT : ");
# line 584 "DataFlow.puma"
   WriteSet (stdout, out);
# line 584 "DataFlow.puma"
   printf ("\n");
  }
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 587 "DataFlow.puma"
  {
# line 589 "DataFlow.puma"
   DepGraphGetForStmt (t, & Defs, & Uses);
# line 590 "DataFlow.puma"
   DepChaining (in, & Defs, & Uses, depth, out);
  }
   return;

  }
# line 593 "DataFlow.puma"
  {
# line 594 "DataFlow.puma"
   Assign (out, in);
# line 595 "DataFlow.puma"
   printf ("No Data Flow for this Statement\n");
  }
   return;

  }

# line 598 "DataFlow.puma"
  {
# line 599 "DataFlow.puma"
   Assign (out, in);
# line 600 "DataFlow.puma"
   printf ("Error: Unknown Node for Reaching\n");
  }
   return;

;
}

void OutDependences
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 611 "DataFlow.puma"

unsigned char string[256];
tDepNode DN;
DepNodeSet Defs, Uses;
int i, count;

  if (t == NoTree) return;
  if (t->Kind == kCOMP_UNIT) {
# line 618 "DataFlow.puma"
  {
# line 619 "DataFlow.puma"
   OutDependences (t->COMP_UNIT.COMP_ELEMENTS);
  }
   return;

  }
  if (t->Kind == kDECL_LIST) {
# line 622 "DataFlow.puma"
  {
# line 623 "DataFlow.puma"
   OutDependences (t->DECL_LIST.Elem);
# line 624 "DataFlow.puma"
   OutDependences (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kPROGRAM_DECL) {
# line 627 "DataFlow.puma"
  {
# line 628 "DataFlow.puma"
   DepOpenGraph (t);
# line 629 "DataFlow.puma"
   GetString (t->PROGRAM_DECL.Name, string);
# line 630 "DataFlow.puma"
   fprintf (DepFile, "PROGRAM %s; \n", string);
# line 631 "DataFlow.puma"
 DepGraphAllNodes (&count, &Defs, &Uses);
          fprintf (DepFile, "There are %d nodes\n", count);
          fprintf (DepFile, "%d Definitions, %d Uses\n",
                   Card(&Defs), Card(&Uses));
          for (i=1; i<= count; i++)
             { DN = DepGraphGetNode (i);
               OutDepNode (DN);         }
# line 638 "DataFlow.puma"
   fprintf (DepFile, "\n");
# line 639 "DataFlow.puma"
   DepCloseGraph ();
  }
   return;

  }
  if (t->Kind == kPROC_DECL) {
# line 642 "DataFlow.puma"
  {
# line 643 "DataFlow.puma"
   DepOpenGraph (t);
# line 644 "DataFlow.puma"
   GetString (t->PROC_DECL.Name, string);
# line 645 "DataFlow.puma"
   fprintf (DepFile, "SUBROUTINE %s \n", string);
# line 646 "DataFlow.puma"
 DepGraphAllNodes (&count, &Defs, &Uses);
          fprintf (DepFile, "There are %d nodes\n", count);
          fprintf (DepFile, "%d Definitions, %d Uses\n",
                   Card(&Defs), Card(&Uses));
          for (i=1; i<= count; i++)
             { DN = DepGraphGetNode (i);
               OutDepNode (DN);         }
# line 653 "DataFlow.puma"
   fprintf (DepFile, "\n");
# line 654 "DataFlow.puma"
   DepCloseGraph ();
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
# line 657 "DataFlow.puma"
  {
# line 658 "DataFlow.puma"
   DepOpenGraph (t);
# line 659 "DataFlow.puma"
   GetString (t->FUNC_DECL.Name, string);
# line 660 "DataFlow.puma"
   fprintf (DepFile, "FUNCTION %s; \n", string);
# line 661 "DataFlow.puma"
 DepGraphAllNodes (&count, &Defs, &Uses);
          fprintf (DepFile, "There are %d nodes\n", count);
          fprintf (DepFile, "%d Definitions, %d Uses\n",
                   Card(&Defs), Card(&Uses));
          for (i=1; i<= count; i++)
             { DN = DepGraphGetNode (i);
               OutDepNode (DN);         }
# line 668 "DataFlow.puma"
   fprintf (DepFile, "\n");
# line 669 "DataFlow.puma"
   DepCloseGraph ();
  }
   return;

  }
;
}

static void OutDepNode
# if defined __STDC__ | defined __cplusplus
(register tDepGraph d)
# else
(d)
 register tDepGraph d;
# endif
{
# line 674 "DataFlow.puma"

unsigned char string[256];

  if (d == NoDepGraph) return;
  if (d->Kind == kDepNode) {
# line 678 "DataFlow.puma"
  {
# line 679 "DataFlow.puma"
   GetString (d->DepNode.Name, string);
# line 680 "DataFlow.puma"
   fprintf (DepFile, "%s ", string);
# line 681 "DataFlow.puma"
   OutPosition (d->DepNode.Access);
# line 682 "DataFlow.puma"
   fprintf (DepFile, " : ");
# line 683 "DataFlow.puma"
   FileUnparse (DepFile, d->DepNode.Access);
# line 684 "DataFlow.puma"
   fprintf (DepFile, " kind = %d \n", d->DepNode.NodeKind);
  }
   return;

  }
;
}

static void OutPosition
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kUSED_VAR) {
# line 689 "DataFlow.puma"
  {
# line 690 "DataFlow.puma"
   fprintf (DepFile, "(P=%d)", t->USED_VAR.VARNAME->VAR_OBJ.Pos);
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 693 "DataFlow.puma"
  {
# line 694 "DataFlow.puma"
   OutPosition (t->INDEXED_VAR.IND_VAR);
  }
   return;

  }
;
}

void BeginDataFlow ()
{
# line 82 "DataFlow.puma"

  BeginDepGraph ();
  LoopList = mACF_EMPTY ();
  DepErrorCount = 0;

}

void CloseDataFlow ()
{
# line 89 "DataFlow.puma"

  if (DepErrorCount > 0)
     printf ("Fatal Errors for Data Flow Analysis ");

}
