# include "Dependen.h"
# include "yyDepend.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "Dependences.puma"


# include "Tree.h"
# include "Idents.h"
# include "StringMe.h"

# undef DEBUG

void PrintNormRecord (s, e, loops, n)
char s[];
ExpNormRecord e;
tTree loops[];
int n;

{  int i;
   printf ("Normalized Expression %s in %d loops: %d", s, n, e.vals[0]);
   for (i=1; i<=n;i++)
     printf (" + %d*I%d", e.vals[i], i);
   printf ("\n");
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Dependences, routine %s failed\n", yyFunction);
 exit (1);
}

static void ExpNormal ARGS((tTree e, ptree loops, int n, bool * yyP2, ExpNormRecord * yyP1));
static bool IsLoopVar ARGS((tIdent name, tTree loop));
static void GetLoopIncrement ARGS((tTree t, bool * yyP4, int * yyP3));
static void ForIdUpperBound ARGS((tTree slice, ptree loops, int m, bool * yyP6, ExpNormRecord * yyP5));
static void ForIdLowerBound ARGS((tTree slice, ptree loops, int m, bool * yyP8, ExpNormRecord * yyP7));
static void ExpUpperBound ARGS((ExpNormRecord e, ptree loops, int n, int ConstLoops, bool * yyP10, ExpNormRecord * yyP9));
static void ExpLowerBound ARGS((ExpNormRecord e, ptree loops, int n, int ConstLoops, bool * yyP12, ExpNormRecord * yyP11));
static bool ExpDifferent ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int ConstLoops));
static void DiffUppBound ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, bool * yyP14, int * yyP13));
static void DiffLowBound ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, bool * yyP16, int * yyP15));
static void DeltaCheck ARGS((ExpNormRecord e, ptree loops, int n, bool flow, int low, bool fup, int up, pPredVector p));
static void ExpCompare ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void IndexCompare ARGS((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
void Dependences ARGS((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));

static void ExpNormal
# if defined __STDC__ | defined __cplusplus
(register tTree e, ptree loops, register int n, register bool * yyP2, ExpNormRecord * yyP1)
# else
(e, loops, n, yyP2, yyP1)
 register tTree e;
 ptree loops;
 register int n;
 register bool * yyP2;
 ExpNormRecord * yyP1;
# endif
{
# line 75 "Dependences.puma"

int i;

# line 85 "Dependences.puma"
 {
  int c;
  bool found;
  ExpNormRecord val;
  {
# line 86 "Dependences.puma"

# line 87 "Dependences.puma"

# line 88 "Dependences.puma"

# line 89 "Dependences.puma"
   GetIntConstValue (e, & found, & c);
# line 90 "Dependences.puma"
   if (! (found)) goto yyL1;
  {
# line 91 "Dependences.puma"
 for (i=1;i<=n;i++) val.vals[i] = 0;
     val.vals[0] = c;

  }
  }
   * yyP2 = found;
   * yyP1 = val;
   return;
 }
yyL1:;

  if (e->Kind == kOP_EXP) {
  if (e->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 102 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  {
# line 103 "Dependences.puma"
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
# line 104 "Dependences.puma"
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
# line 105 "Dependences.puma"
 if (yyV1 && yyV3)
       { for (i=0; i<=n; i++)
            yyV2.vals[i] += yyV4.vals[i];
       }

  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV2;
   return;
 }

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 112 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  {
# line 113 "Dependences.puma"
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
# line 114 "Dependences.puma"
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
# line 115 "Dependences.puma"
 if (yyV1 && yyV3)
       { for (i=0; i<=n; i++)
            yyV2.vals[i] -= yyV4.vals[i];
       }

  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV2;
   return;
 }

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 122 "Dependences.puma"
 {
  int c;
  bool found1;
  bool yyV1;
  ExpNormRecord yyV2;
  {
# line 123 "Dependences.puma"

# line 124 "Dependences.puma"

# line 125 "Dependences.puma"
   GetIntConstValue (e->OP_EXP.OPND1, & found1, & c);
# line 126 "Dependences.puma"
   if (! (found1)) goto yyL4;
  {
# line 127 "Dependences.puma"
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV1, & yyV2);
# line 130 "Dependences.puma"
 if (yyV1) { for (i=0;i<=n;i++) yyV2.vals[i] *= c; }
  }
  }
   * yyP2 = found1 && yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

# line 133 "Dependences.puma"
 {
  int c;
  bool found2;
  bool yyV1;
  ExpNormRecord yyV2;
  {
# line 135 "Dependences.puma"

# line 136 "Dependences.puma"

# line 137 "Dependences.puma"
   GetIntConstValue (e->OP_EXP.OPND2, & found2, & c);
# line 139 "Dependences.puma"
   if (! (found2)) goto yyL5;
  {
# line 141 "Dependences.puma"
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
# line 144 "Dependences.puma"
 if (yyV1) { for (i=0;i<=n;i++) yyV2.vals[i] *= c; }
  }
  }
   * yyP2 = yyV1 && found2;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

  }
  }
  if (e->Kind == kOP1_EXP) {
  if (e->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 147 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  {
# line 148 "Dependences.puma"
   ExpNormal (e->OP1_EXP.OPND, loops, n, & yyV1, & yyV2);
# line 149 "Dependences.puma"
 if (yyV1)
       { for (i=0; i<=n; i++)
            yyV2.vals[i] = -yyV2.vals[i];
       }

  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  }
  if (e->Kind == kVAR_EXP) {
  if (e->VAR_EXP.V->Kind == kLOOP_VAR) {
# line 156 "Dependences.puma"
 {
  bool found;
  ExpNormRecord val;
  {
# line 157 "Dependences.puma"

# line 158 "Dependences.puma"

# line 159 "Dependences.puma"
 found = false;
     val.vals[0] = 0;
     for (i=1; i<= n; i++)
       { if (IsLoopVar (e->VAR_EXP.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, loops[i-1]))
            { val.vals[i] = 1;
              found  = true;
            }
           else
            val.vals[i] = 0;
       }

  }
   * yyP2 = found;
   * yyP1 = val;
   return;
 }

  }
  if (e->VAR_EXP.V->Kind == kUSED_VAR) {
# line 172 "Dependences.puma"
 {
  bool found;
  ExpNormRecord val;
  {
# line 173 "Dependences.puma"

# line 174 "Dependences.puma"

# line 175 "Dependences.puma"
 found = false;
     val.vals[0] = 0;
     for (i=1; i<= n; i++)
       { if (IsLoopVar (e->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, loops[i-1]))
            { val.vals[i] = 1;
              found  = true;
            }
           else
            val.vals[i] = 0;
       }

  }
   * yyP2 = found;
   * yyP1 = val;
   return;
 }

  }
  }
  if (e->Kind == kSLICE_EXP) {
# line 196 "Dependences.puma"
 {
  ExpNormRecord val;
  {
# line 197 "Dependences.puma"

  }
   * yyP2 = false;
   * yyP1 = val;
   return;
 }

  }
# line 200 "Dependences.puma"
 {
  ExpNormRecord val;
  {
# line 203 "Dependences.puma"

  }
   * yyP2 = false;
   * yyP1 = val;
   return;
 }

;
}

static bool IsLoopVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree loop)
# else
(name, loop)
 register tIdent name;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
# line 208 "Dependences.puma"
  {
# line 209 "Dependences.puma"
   if (! (IsLoopVar (name, loop->ACF_FORALL.FORALL_ID))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (loop->Kind == kUSED_VAR) {
# line 212 "Dependences.puma"
  {
# line 213 "Dependences.puma"
   if (! (name == loop->USED_VAR.VARNAME->VAR_OBJ.Ident)) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (loop->Kind == kLOOP_VAR) {
# line 216 "Dependences.puma"
  {
# line 217 "Dependences.puma"
   if (! (name == loop->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident)) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static void GetLoopIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree t, register bool * yyP4, register int * yyP3)
# else
(t, yyP4, yyP3)
 register tTree t;
 register bool * yyP4;
 register int * yyP3;
# endif
{
  if (t->Kind == kACF_DO) {
# line 228 "Dependences.puma"
 {
  bool found;
  int val;
  {
# line 230 "Dependences.puma"

# line 232 "Dependences.puma"
 if (t->ACF_DO.DO_RANGE->SLICE_EXP.INC == NoTree)
         { found = true;
           val   = 1;
         }
       else if (t->ACF_DO.DO_RANGE->SLICE_EXP.INC->Kind == kDUMMY_EXP)
         { found = true;
           val   = 1;
         }
       else
         GetIntConstValue (t->ACF_DO.DO_RANGE->SLICE_EXP.INC, &found, &val);

  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }

  }
  if (t->Kind == kACF_DOLOCAL) {
# line 245 "Dependences.puma"
 {
  bool found;
  int val;
  {
# line 247 "Dependences.puma"

# line 249 "Dependences.puma"
 if (t->ACF_DOLOCAL.DOLOCAL_RANGE->SLICE_EXP.INC == NoTree)
         { found = true;
           val   = 1;
         }
       else if (t->ACF_DOLOCAL.DOLOCAL_RANGE->SLICE_EXP.INC->Kind == kDUMMY_EXP)
         { found = true;
           val   = 1;
         }
       else
         GetIntConstValue (t->ACF_DOLOCAL.DOLOCAL_RANGE->SLICE_EXP.INC, &found, &val);

  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }

  }
  if (t->Kind == kACF_FORALL) {
# line 262 "Dependences.puma"
 {
  bool found;
  int val;
  {
# line 264 "Dependences.puma"

# line 266 "Dependences.puma"
 if (t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.INC == NoTree)
         { found = true;
           val   = 1;
         }
       else if (t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.INC->Kind == kDUMMY_EXP)
         { found = true;
           val   = 1;
         }
       else
         GetIntConstValue (t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.INC, &found, &val);

  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }

  }
# line 279 "Dependences.puma"
  {
# line 280 "Dependences.puma"
   printf ("Illegal Call of GetLoopIncrement\n");
# line 281 "Dependences.puma"
   FileUnparse (stdout, t);
# line 282 "Dependences.puma"
   exit (- 1);
  }
   * yyP4 = false;
   * yyP3 = 0;
   return;

;
}

static void ForIdUpperBound
# if defined __STDC__ | defined __cplusplus
(register tTree slice, ptree loops, register int m, register bool * yyP6, ExpNormRecord * yyP5)
# else
(slice, loops, m, yyP6, yyP5)
 register tTree slice;
 ptree loops;
 register int m;
 register bool * yyP6;
 ExpNormRecord * yyP5;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
# line 303 "Dependences.puma"
 {
  bool f;
  ExpNormRecord r;
  int incval;
  {
# line 305 "Dependences.puma"

# line 306 "Dependences.puma"

# line 307 "Dependences.puma"

# line 309 "Dependences.puma"

     if (slice->SLICE_EXP.INC == NoTree)
        { f = true;
          incval = 1;
        }
      else if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP)
        { f = true;
          incval = 1;
        }
      else
        GetIntConstValue (slice->SLICE_EXP.INC, &f, &incval);



     if (f)
       {
         if (incval > 0)
           {
             ExpNormal (slice->SLICE_EXP.STOP, loops, m-1, &f, &r);
           }
         else
           {
             ExpNormal (slice->SLICE_EXP.START, loops, m-1, &f, &r);
           }
       }



# if DEBUG
     if (f)
       { printf ("Upper bound for loop variable %d found\n", m);
         PrintNormRecord ("up", r, loops, m-1);
       }
      else
         printf ("Upper bound for loop variable %d not found\n", m);
# endif


  }
   * yyP6 = f;
   * yyP5 = r;
   return;
 }

  }
;
}

static void ForIdLowerBound
# if defined __STDC__ | defined __cplusplus
(register tTree slice, ptree loops, register int m, register bool * yyP8, ExpNormRecord * yyP7)
# else
(slice, loops, m, yyP8, yyP7)
 register tTree slice;
 ptree loops;
 register int m;
 register bool * yyP8;
 ExpNormRecord * yyP7;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
# line 352 "Dependences.puma"
 {
  bool f;
  ExpNormRecord r;
  int incval;
  {
# line 354 "Dependences.puma"

# line 355 "Dependences.puma"

# line 356 "Dependences.puma"

# line 358 "Dependences.puma"

     if (slice->SLICE_EXP.INC == NoTree)
        { f = true;
          incval = 1;
        }
      else if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP)
        { f = true;
          incval = 1;
        }
      else
        GetIntConstValue (slice->SLICE_EXP.INC, &f, &incval);



     if (f)
       {
         if (incval < 0)
           {
             ExpNormal (slice->SLICE_EXP.STOP, loops, m-1, &f, &r);
           }
         else
           {
             ExpNormal (slice->SLICE_EXP.START, loops, m-1, &f, &r);
           }
       }



# ifdef DEBUG
     if (f)
       { printf ("Lower bound for loop variable %d found\n", m);
         PrintNormRecord ("low", r, loops, m-1);
       }
      else
         printf ("Lower bound for loop variable %d not found\n", m);
# endif


  }
   * yyP8 = f;
   * yyP7 = r;
   return;
 }

  }
;
}

static void ExpUpperBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register int ConstLoops, register bool * yyP10, ExpNormRecord * yyP9)
# else
(e, loops, n, ConstLoops, yyP10, yyP9)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register int ConstLoops;
 register bool * yyP10;
 ExpNormRecord * yyP9;
# endif
{
# line 420 "Dependences.puma"
 {
  bool found;
  ExpNormRecord bound;
  ExpNormRecord h;
  int k;
  int i;
  int a;
  {
# line 422 "Dependences.puma"

# line 423 "Dependences.puma"

# line 424 "Dependences.puma"

# line 425 "Dependences.puma"

# line 426 "Dependences.puma"

# line 427 "Dependences.puma"

# line 430 "Dependences.puma"
 found = true;
     bound = e;

# ifdef DEBUG
     printf ("Call of ExpUpperBound, ConstLoops = %d\n", ConstLoops);
     PrintNormRecord ("e", e, loops, n);
# endif

     k     = n;
     while (found && (k > ConstLoops))
      {
        a = bound.vals[k];
        if (a > 0)
         {
           ForIdUpperBound (loops[k-1]->ACF_DO.DO_RANGE,loops,k,&found,&h);
           if (found)
             {
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         }
        else if (a < 0)
         {
           ForIdLowerBound (loops[k-1]->ACF_DO.DO_RANGE,loops,k,&found,&h);
           if (found)
             {
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         }
        k = k - 1;
      }

# ifdef DEBUG
     if (found)
       { printf ("Upper Bound found\n");
         PrintNormRecord ("up", bound, loops, ConstLoops);
       }
      else
         printf ("Upper Bound not found\n");
# endif


  }
   * yyP10 = found;
   * yyP9 = bound;
   return;
 }

;
}

static void ExpLowerBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register int ConstLoops, register bool * yyP12, ExpNormRecord * yyP11)
# else
(e, loops, n, ConstLoops, yyP12, yyP11)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register int ConstLoops;
 register bool * yyP12;
 ExpNormRecord * yyP11;
# endif
{
# line 481 "Dependences.puma"
 {
  bool found;
  ExpNormRecord bound;
  ExpNormRecord h;
  int k;
  int i;
  int a;
  {
# line 483 "Dependences.puma"

# line 484 "Dependences.puma"

# line 485 "Dependences.puma"

# line 486 "Dependences.puma"

# line 487 "Dependences.puma"

# line 488 "Dependences.puma"

# line 490 "Dependences.puma"
 found = true;
     bound = e;

# ifdef DEBUG
     printf ("Call of ExpLowerBound, ConstLoops = %d\n", ConstLoops);
     PrintNormRecord ("e", e, loops, n);
# endif

     k     = n;
     while (found && (k > ConstLoops))
      {
        a = bound.vals[k];
        if (a > 0)
         {
           ForIdLowerBound (loops[k-1]->ACF_DO.DO_RANGE,loops,k,&found,&h);
           if (found)
             {
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         }
        else if (a < 0)
         {
           ForIdUpperBound (loops[k-1]->ACF_DO.DO_RANGE,loops,k,&found,&h);
           if (found)
             {
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         }
        k = k - 1;
      }

# ifdef DEBUG
     if (found)
       { printf ("Lower Bound found\n");
         PrintNormRecord ("low", bound, loops, ConstLoops);
       }
      else
         printf ("Lower Bound not found\n");
# endif

  }
   * yyP12 = found;
   * yyP11 = bound;
   return;
 }

;
}

static bool ExpDifferent
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int ConstLoops)
# else
(e1, loops1, n1, e2, loops2, n2, ConstLoops)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int ConstLoops;
# endif
{
# line 547 "Dependences.puma"

int i;

# line 551 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  bool yyV5;
  ExpNormRecord yyV6;
  {
# line 560 "Dependences.puma"
   ExpUpperBound (e1, loops1, n1, ConstLoops, & yyV1, & yyV2);
# line 561 "Dependences.puma"
   if (! (yyV1)) goto yyL1;
  {
# line 568 "Dependences.puma"
   ExpLowerBound (e2, loops2, n2, ConstLoops, & yyV3, & yyV4);
# line 569 "Dependences.puma"
   if (! (yyV3)) goto yyL1;
  {
# line 576 "Dependences.puma"
 for (i=0; i<=ConstLoops; i++)
        yyV4.vals[i] -= yyV2.vals[i];


# line 584 "Dependences.puma"
   ExpLowerBound (yyV4, loops1, ConstLoops, 0, & yyV5, & yyV6);
# line 585 "Dependences.puma"
   if (! (yyV5)) goto yyL1;
  {
# line 592 "Dependences.puma"
   if (! ( yyV6.vals[0]  > 0)) goto yyL1;
  }
  }
  }
  }
   return true;
 }
yyL1:;

# line 595 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  bool yyV5;
  ExpNormRecord yyV6;
  {
# line 604 "Dependences.puma"
   ExpLowerBound (e1, loops1, n1, ConstLoops, & yyV1, & yyV2);
# line 605 "Dependences.puma"
   if (! (yyV1)) goto yyL2;
  {
# line 612 "Dependences.puma"
   ExpUpperBound (e2, loops2, n2, ConstLoops, & yyV3, & yyV4);
# line 613 "Dependences.puma"
   if (! (yyV3)) goto yyL2;
  {
# line 620 "Dependences.puma"
 for (i=0; i<=ConstLoops; i++)
        yyV2.vals[i] -= yyV4.vals[i];


# line 628 "Dependences.puma"
   ExpLowerBound (yyV2, loops1, ConstLoops, 0, & yyV5, & yyV6);
# line 629 "Dependences.puma"
   if (! (yyV5)) goto yyL2;
  {
# line 636 "Dependences.puma"
   if (! ( yyV6.vals[0]  > 0)) goto yyL2;
  }
  }
  }
  }
   return true;
 }
yyL2:;

  return false;
}

static void DiffUppBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, register bool * yyP14, register int * yyP13)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, yyP14, yyP13)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 register bool * yyP14;
 register int * yyP13;
# endif
{
# line 663 "Dependences.puma"

int i;

# line 667 "Dependences.puma"
 {
  bool found;
  int val;
  int m;
  int i;
  ExpNormRecord H1;
  ExpNormRecord H2;
  {
# line 669 "Dependences.puma"

# line 670 "Dependences.puma"

# line 671 "Dependences.puma"

# line 672 "Dependences.puma"

# line 674 "Dependences.puma"

# line 675 "Dependences.puma"

# line 683 "Dependences.puma"
 for (i=0; i<= n1; i++) H1.vals[i] = - e1.vals[i];
# line 684 "Dependences.puma"
   H2 = e2;
# line 687 "Dependences.puma"
 if (n1 > n2) m = n1;
       else m = n2;
# line 690 "Dependences.puma"
   found = true;
# line 692 "Dependences.puma"



     if (n1 > m)
       ExpUpperBound (H1, loops1, n1, m, &found, &H1);
     if (n2 > m)
       ExpUpperBound (H2, loops2, n2, m, &found, &H2);



     for (i=CommonLoops+1; i<=m; i++)
       found = (found && ( H1.vals[i] + H2.vals[i] == 0));

# line 706 "Dependences.puma"
   if (! (found)) goto yyL1;
  {
# line 708 "Dependences.puma"

     for (i=0; i<=CommonLoops; i++)
        H1.vals[i] += H2.vals[i];
     ExpUpperBound (H1, loops1, CommonLoops, 0, &found, &H2);

     if (found)
        val = H2.vals[0];

  }
  }
   * yyP14 = found;
   * yyP13 = val;
   return;
 }
yyL1:;

;
}

static void DiffLowBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, register bool * yyP16, register int * yyP15)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, yyP16, yyP15)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 register bool * yyP16;
 register int * yyP15;
# endif
{
# line 723 "Dependences.puma"

int i;

# line 727 "Dependences.puma"
 {
  bool found;
  int val;
  int m;
  int i;
  ExpNormRecord H1;
  ExpNormRecord H2;
  {
# line 729 "Dependences.puma"

# line 730 "Dependences.puma"

# line 731 "Dependences.puma"

# line 732 "Dependences.puma"

# line 734 "Dependences.puma"

# line 735 "Dependences.puma"

# line 743 "Dependences.puma"
 for (i=0; i<= n1; i++) H1.vals[i] = - e1.vals[i];
# line 744 "Dependences.puma"
   H2 = e2;
# line 747 "Dependences.puma"
 if (n1 > n2) m = n1;
       else m = n2;
# line 750 "Dependences.puma"
   found = true;
# line 752 "Dependences.puma"



     if (n1 > m)
       ExpLowerBound (H1, loops1, n1, m, &found, &H1);
     if (n2 > m)
       ExpLowerBound (H2, loops2, n2, m, &found, &H2);



     for (i=CommonLoops+1; i<=m; i++)
       found = (found && ( H1.vals[i] + H2.vals[i] == 0));

# line 766 "Dependences.puma"
   if (! (found)) goto yyL1;
  {
# line 768 "Dependences.puma"

     for (i=0; i<=CommonLoops; i++)
        H1.vals[i] += H2.vals[i];
     ExpLowerBound (H1, loops1, CommonLoops, 0, &found, &H2);

     if (found)
        val = H2.vals[0];

  }
  }
   * yyP16 = found;
   * yyP15 = val;
   return;
 }
yyL1:;

;
}

static void DeltaCheck
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register bool flow, register int low, register bool fup, register int up, pPredVector p)
# else
(e, loops, n, flow, low, fup, up, p)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register bool flow;
 register int low;
 register bool fup;
 register int up;
 pPredVector p;
# endif
{
# line 798 "Dependences.puma"

int i, comp, ncomps, dim, incval;
bool found;
int p_low, p_up, c;
char PVString[100];
ExpNormRecord inc;

# line 806 "Dependences.puma"
  {
# line 808 "Dependences.puma"
 ncomps = 0;
     dim    = PVGetDimension (p);
     c      = 0;

# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Call of DeltaCheck, p = %s\n", PVString);
     PrintNormRecord ("e", e, loops, n);
# endif



     inc = e;
     for (i=1; i<=n; i++)
       if ((inc.vals[i] != 0) && (i <= dim))
         {
           PVGetComponent (p, i, &p_low, &p_up);
           if ((p_low != 0) || (p_up != 0))
             {
               GetLoopIncrement (loops[i-1], &found, &incval);
               if (!found)
                 {
                   goto stop;
                 }
               inc.vals[i] *= incval;
             }
         }



     for (i=1; i<=n; i++)
       if ((inc.vals[i] != 0) && (i <= dim))
         {
           PVGetComponent (p, i, &p_low, &p_up);
           if (p_low == p_up)

             c += p_low * inc.vals[i];
           else
             { ncomps += 1;
               comp   = i;
             }
         }

     if (ncomps == 0)
        {
# ifdef DEBUG
          printf ("Delta Check, 0 relevant components\n");
# endif
          if (fup)
            { if (c < -up) PVSetFalse (p); }
          if (flow)
            { if (c > -low) PVSetFalse (p); }
        }
     if (ncomps == 1)
        {

# ifdef DEBUG
          printf ("Delta Check, 1 relevant component is %d\n", comp);
# endif







          if (inc.vals[comp] > 0)
            { if (fup)

                 p_low = (- up - c) / inc.vals[comp];
               else
                 p_low = -32767;
              if (flow)
                 p_up  = (- low - c) / inc.vals[comp];
               else
                 p_up  = 32767;
            }
           else
            { if (fup)

                 p_up  = (- up - c) / inc.vals[comp];
               else
                 p_up  = -32767;
              if (flow)
                 p_low = (- low - c) / inc.vals[comp];
               else
                 p_low = 32767;
            }

# ifdef DEBUG
          printf ("DeltaCheck, 1 comp, new range : %d - %d\n", p_low, p_up);
# endif

          PVAndComponent (p, comp, p_low, p_up);
          if (p_low != p_up) PVSetNotExact (p);
        }



    stop: ;

# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Result of DeltaCheck, p = %s\n", PVString);
# endif


  }
   return;

;
}

static void ExpCompare
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
# line 932 "Dependences.puma"

char PVString[100];

# line 950 "Dependences.puma"
 {
  int low;
  int up;
  bool flow;
  bool fup;
  {
# line 952 "Dependences.puma"

# line 953 "Dependences.puma"

# line 954 "Dependences.puma"

# line 955 "Dependences.puma"

# line 957 "Dependences.puma"

# ifdef DEBUG
     printf ("Call of ExpCompare\n");
     PrintNormRecord ("e1", e1, loops1, n1);
     PrintNormRecord ("e2", e2, loops2, n2);
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Predicate = %s\n", PVString);
# endif

     if (ExpDifferent (e1, loops1, n1, e2, loops2, n2, ConstLoops))
       {
          PVSetFalse (p);
# ifdef DEBUG
          printf ("ExpCompare: FALSE, both expressions are different\n");
          strcpy (PVString,""); PVOut (PVString, p);
          printf ("Result Predicate = %s\n", PVString);
# endif
          return;
       }

# ifdef DEBUG
     printf ("Expressions are not absolute different, consider e1 - e2\n");
# endif

     DiffLowBound (e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops,
                   &flow, &low);

     DiffUppBound (e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops,
                   &fup, &up);

# ifdef DEBUG
     if (flow)
        printf ("Difference has lower bound : %d\n", low);
      else
        printf ("Difference has no lower bound\n");
     if (fup)
        printf ("Difference has upper bound : %d\n", up);
      else
        printf ("Difference has no upper bound\n");
# endif

     if ((!flow) || (!fup))
        PVSetNotExact (p);
      else if (low != up)
        PVSetNotExact (p);

     DeltaCheck (e1, loops1, n1, flow, low, fup, up, p);
     if (!PVIsFalse (p))
       DeltaCheck (e2, loops2, n2, flow, low, fup, up, p);

# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("ExpCompare: Final Result Predicate = %s\n", PVString);
# endif

  }
   return;
 }

;
}

static void IndexCompare
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
# line 1020 "Dependences.puma"

char PVString[100];

  if (e1->Kind == kBTE_LIST) {
  if (e2->Kind == kBTE_LIST) {
# line 1024 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  {
# line 1029 "Dependences.puma"
   IndexCompare (e1->BTE_LIST.Next, loops1, n1, e2->BTE_LIST.Next, loops2, n2, CommonLoops, ConstLoops, p);
# line 1032 "Dependences.puma"
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
# line 1036 "Dependences.puma"
   ExpNormal (e1->BTE_LIST.Elem, loops1, n1, & yyV1, & yyV2);
# line 1037 "Dependences.puma"
   if (! (yyV1)) goto yyL1;
  {
# line 1039 "Dependences.puma"
   ExpNormal (e2->BTE_LIST.Elem, loops2, n2, & yyV3, & yyV4);
# line 1040 "Dependences.puma"
   if (! (yyV3)) goto yyL1;
  {
# line 1044 "Dependences.puma"
   ExpCompare (yyV2, loops1, n1, yyV4, loops2, n2, CommonLoops, ConstLoops, p);
  }
  }
  }
  }
   return;
 }
yyL1:;

# line 1048 "Dependences.puma"
   return;

  }
  }
  if (e1->Kind == kBTE_EMPTY) {
  if (e2->Kind == kBTE_EMPTY) {
# line 1054 "Dependences.puma"
   return;

  }
  }
# line 1058 "Dependences.puma"
  {
# line 1060 "Dependences.puma"
   printf ("Internal Error in IndexCompare\n");
# line 1061 "Dependences.puma"
   printf ("e1 = ");
# line 1061 "Dependences.puma"
   FileUnparse (stdout, e1);
# line 1061 "Dependences.puma"
   printf ("\n");
# line 1062 "Dependences.puma"
   printf ("e2 = ");
# line 1062 "Dependences.puma"
   FileUnparse (stdout, e2);
# line 1062 "Dependences.puma"
   printf ("\n");
# line 1063 "Dependences.puma"
   exit (- 1);
  }
   return;

;
}

void Dependences
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
# line 1071 "Dependences.puma"

char PVString [100];

  if (e1->Kind == kINDEXED_VAR) {
  if (e1->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
  if (e2->Kind == kINDEXED_VAR) {
  if (e2->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 1075 "Dependences.puma"
  {
# line 1078 "Dependences.puma"
   if (! (e1->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident == e2->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident)) goto yyL1;
  {
# line 1080 "Dependences.puma"

# ifdef DEBUG
     printf ("Call of Dependences\n");
     printf ("e1 = "); FileUnparse (stdout, e1); printf ("\n");
     printf ("e2 = "); FileUnparse (stdout, e2); printf ("\n");
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Dependences : Predicate = %s\n", PVString);
# endif

     IndexCompare (e1->INDEXED_VAR.IND_EXPS, loops1, n1, e2->INDEXED_VAR.IND_EXPS, loops2, n2,
                   CommonLoops, ConstLoops, p);
# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Dependences : ResultPredicate = %s\n", PVString);
# endif

  }
  }
   return;
yyL1:;

  }
  }
  }
  }
# line 1098 "Dependences.puma"
  {
# line 1100 "Dependences.puma"
   printf ("Dependences failed, only allowed for indexed expressions\n");
# line 1101 "Dependences.puma"
   FileUnparse (stdout, e1);
# line 1102 "Dependences.puma"
   FileUnparse (stdout, e2);
# line 1103 "Dependences.puma"
   exit (- 1);
  }
   return;

;
}

void BeginDependences ()
{
}

void CloseDependences ()
{
}
